::**************************************************
:: PSXMinimise-Compress is part of:
:: PSXMinimise v0.52 by jcx - Released on 2021-07-15
:: https://jcx.life/tech/psxminimise
::**************************************************

@echo off
if "%~1"=="" cls
if "%~1"=="" color 5F
call psxminimise-header.bat
if "%~1"=="" echo PSXMinimise is running in compression mode.
if "%~1"=="" timeout /T 3

if "%~1"=="1" echo ---------------------------------------------------------
echo Generating checksums....
if "%~1"=="1" echo ---------------------------------------------------------
call hashsum.bat /A SHA256 /T *.bin > uncompressed.sha256
	IF %ERRORLEVEL% EQU 0 GOTO start
GOTO error

:start
if "%~1"=="1" type uncompressed.sha256
if "%~1"=="1" echo.
if "%~1"=="1" echo ---------------------------------------------------------
echo Encoding ECM Data...
if "%~1"=="1" echo ---------------------------------------------------------
IF EXIST "*(Track 01).bin" ( 
if "%~1"=="1" ecm *"(Track 01).bin" 
if "%~1"=="" ecm *"(Track 01).bin" >NUL 2>NUL
del *"(Track 01).bin"
if "%~1"=="1" echo.
goto audiocomp
) ELSE (
IF EXIST "*(Track 1).bin" (
if "%~1"=="1" ecm *"(Track 1).bin"
if "%~1"=="" ecm *"(Track 1).bin" >NUL 2>NUL
del *"(Track 1).bin" 
if "%~1"=="1" echo.
goto audiocomp
) ELSE ( 
if "%~1"=="1" ecm *".bin"
if "%~1"=="" ecm *".bin" >NUL 2>NUL
del *.bin
if "%~1"=="1" echo.
goto compress
)
)

:audiocomp
if "%~1"=="1" echo ---------------------------------------------------------
echo Encoding audio tracks....
if "%~1"=="1" echo ---------------------------------------------------------
if "%~1"=="1" flac -8 -V --delete-input-file --force-raw-format --endian=little --channels=2 --bps=16 --sample-rate=44100 --sign=signed *.bin
if "%~1"=="" flac -8 -V --silent --delete-input-file --force-raw-format --endian=little --channels=2 --bps=16 --sample-rate=44100 --sign=signed *.bin
if "%~1"=="1" echo.

:compress
if "%~1"=="1" echo ---------------------------------------------------------
echo Generating FreeArc Archive....
if "%~1"=="1" echo ---------------------------------------------------------
for %%I in (.) do set CurrDirName=%%~nxI
freearc a -t -df -m9x -ma9 -mt8 "%CurrDirName%.arc" *.bin.ecm *.flac *.cue *.sha256
	IF %ERRORLEVEL% EQU 0 GOTO success
GOTO error

:success
if "%~1"=="1" echo ---------------------------------------------------------
if "%~1"=="" color 2f
echo Compression Successful.
if "%~1"=="" timeout /T 3
if "%~1"=="1" echo ---------------------------------------------------------
GOTO end

:error
if "%~1"=="1" echo ---------------------------------------------------------
if "%~1"=="" color 4f
echo "An error occured."
if "%~1"=="" timeout /T 3
if "%~1"=="1" echo ---------------------------------------------------------

:end
