/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ant.compress.util.ArchiveStreamFactory;
import org.apache.ant.compress.util.EntryHelper;
import org.apache.ant.compress.util.StreamHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.util.FileUtils;

public abstract class CommonsCompressArchiveResource
extends ArchiveResource {
    private String encoding;
    private final ArchiveStreamFactory factory;
    private final String archiveType;
    private int gid;
    private int uid;

    protected CommonsCompressArchiveResource(ArchiveStreamFactory factory, String archiveType) {
        this.factory = factory;
        this.archiveType = archiveType;
    }

    protected CommonsCompressArchiveResource(ArchiveStreamFactory factory, String archiveType, File a, ArchiveEntry e) {
        super(a, true);
        this.factory = factory;
        this.archiveType = archiveType;
    }

    protected CommonsCompressArchiveResource(ArchiveStreamFactory factory, String archiveType, Resource a, ArchiveEntry e) {
        super(a, true);
        this.factory = factory;
        this.archiveType = archiveType;
    }

    public void setEncoding(String enc) {
        this.checkAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.isReference() ? ((CommonsCompressArchiveResource)((Object)this.getCheckedRef())).getEncoding() : this.encoding;
    }

    public void setRefid(Reference r) {
        if (this.getEncoding() != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public InputStream getInputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getInputStream();
        }
        ArchiveInputStream i = this.getStream();
        ArchiveEntry ae = null;
        while ((ae = i.getNextEntry()) != null) {
            if (!ae.getName().equals(this.getName())) continue;
            return i;
        }
        FileUtils.close((InputStream)i);
        throw new BuildException("no entry " + this.getName() + " in " + this.getArchive());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isReference()) {
            return ((Resource)this.getCheckedRef()).getOutputStream();
        }
        throw new UnsupportedOperationException("Use the " + this.archiveType + " task for " + this.archiveType + " output.");
    }

    public int getUid() {
        if (this.isReference()) {
            return ((CommonsCompressArchiveResource)((Object)this.getCheckedRef())).getUid();
        }
        this.checkEntry();
        return this.uid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((CommonsCompressArchiveResource)((Object)this.getCheckedRef())).getGid();
        }
        this.checkEntry();
        return this.gid;
    }

    protected void fetchEntry() {
        ArchiveInputStream i = null;
        try {
            i = this.getStream();
            ArchiveEntry ae = null;
            while ((ae = i.getNextEntry()) != null) {
                if (!ae.getName().equals(this.getName())) continue;
                this.setEntry(ae);
                return;
            }
        }
        catch (IOException e) {
            this.log(e.getMessage(), 4);
            throw new BuildException((Throwable)e);
        }
        finally {
            if (i != null) {
                FileUtils.close((InputStream)i);
            }
        }
        this.setEntry(null);
    }

    protected void setEntry(ArchiveEntry e) {
        if (e == null) {
            this.setExists(false);
            return;
        }
        this.setName(e.getName());
        this.setExists(true);
        this.setLastModified(e.getLastModifiedDate().getTime());
        this.setDirectory(e.isDirectory());
        this.setSize(e.getSize());
        this.setMode(EntryHelper.getMode(e));
        this.uid = EntryHelper.getUserId(e);
        this.gid = EntryHelper.getGroupId(e);
    }

    private ArchiveInputStream getStream() throws IOException {
        Resource archive = this.getArchive();
        ArchiveInputStream s = StreamHelper.getInputStream(this.factory, archive, this.getEncoding());
        return s != null ? s : this.factory.getArchiveStream(new BufferedInputStream(archive.getInputStream()), this.getEncoding());
    }
}

