/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import redstone.xmlrpc.XmlRpcJsonSerializer;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcServer;

public class XmlRpcServlet
extends HttpServlet {
    private XmlRpcServer server;
    private boolean streamMessages;
    private String contentType;
    private static final long serialVersionUID = 3544388119488050993L;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = servletConfig.getInitParameter("services");
        String string2 = servletConfig.getInitParameter("contentType");
        String string3 = servletConfig.getInitParameter("streamMessages");
        if (string3 != null && string3.equals("1")) {
            this.streamMessages = true;
        }
        if (string2 != null && string2.startsWith("text/javascript+json")) {
            this.contentType = "text/javascript+json";
            this.server = new XmlRpcServer(new XmlRpcJsonSerializer());
        } else {
            this.contentType = "text/xml";
            this.server = new XmlRpcServer();
        }
        this.contentType = this.contentType + "; charset=" + XmlRpcMessages.getString("XmlRpcServlet.Encoding");
        if (string != null) {
            this.addInvocationHandlers(string);
        }
    }

    public XmlRpcServer getXmlRpcServer() {
        return this.server;
    }

    public boolean getStreamMessages() {
        return this.streamMessages;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setCharacterEncoding(XmlRpcMessages.getString("XmlRpcServlet.Encoding"));
        httpServletResponse.setContentType(this.contentType);
        if (this.streamMessages) {
            this.server.execute((InputStream)httpServletRequest.getInputStream(), httpServletResponse.getWriter());
            httpServletResponse.getWriter().flush();
        } else {
            Writer writer = new StringWriter(2048);
            this.server.execute((InputStream)httpServletRequest.getInputStream(), writer);
            String string = writer.toString();
            httpServletResponse.setContentLength(string.length());
            writer = httpServletResponse.getWriter();
            writer.write(string);
            writer.flush();
        }
    }

    private void addInvocationHandlers(String string) throws ServletException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n > -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                try {
                    Class<?> clazz = Class.forName(string4);
                    Object obj = clazz.newInstance();
                    this.server.addInvocationHandler(string3, obj);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ServletException(XmlRpcMessages.getString("XmlRpcServlet.ServiceClassNotFound") + string4, (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ServletException(XmlRpcMessages.getString("XmlRpcServlet.ServiceClassNotInstantiable") + string4, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ServletException(XmlRpcMessages.getString("XmlRpcServlet.ServiceClassNotAccessible") + string4, (Throwable)illegalAccessException);
                }
            }
            throw new ServletException(XmlRpcMessages.getString("XmlRpcServlet.InvalidServicesFormat") + string);
        }
    }
}

