/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import org.apache.ant.compress.taskdefs.ExpandBase;
import org.apache.ant.compress.util.Messages;
import org.apache.ant.compress.util.ZipStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class Unzip
extends ExpandBase {
    public Unzip() {
        super(new ZipStreamFactory());
    }

    public void setEncoding(String encoding) {
        this.internalSetEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        this.log("Expanding: " + srcF + " into " + dir, 2);
        ZipFile zf = null;
        FileNameMapper mapper = this.getMapper();
        if (!srcF.exists()) {
            throw new BuildException("Unable to expand " + srcF + " as the file does not exist", this.getLocation());
        }
        try {
            zf = new ZipFile(srcF, this.getEncoding(), true);
            boolean empty = true;
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                empty = false;
                ZipArchiveEntry ze = (ZipArchiveEntry)e.nextElement();
                if (this.getSkipUnreadableEntries() && !zf.canReadEntryData(ze)) {
                    this.log(Messages.skippedIsUnreadable((ArchiveEntry)ze));
                    continue;
                }
                this.log("extracting " + ze.getName(), 4);
                InputStream is = null;
                try {
                    is = zf.getInputStream(ze);
                    this.extractFile(fileUtils, srcF, dir, is, ze.getName(), new Date(ze.getTime()), ze.isDirectory(), mapper);
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
                FileUtils.close((InputStream)is);
            }
            if (empty && this.getFailOnEmptyArchive()) {
                throw new BuildException("archive '" + srcF + "' is empty");
            }
            this.log("expand complete", 3);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Error while expanding " + srcF.getPath() + "\n" + ioe.toString(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                ZipFile.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipFile.closeQuietly((ZipFile)zf);
    }
}

