
package net.filebot.hash;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Date;

import net.filebot.Settings;

public class VerificationFileWriter implements Closeable {

	protected PrintWriter out;
	protected VerificationFormat format;

	public VerificationFileWriter(File file, VerificationFormat format, Charset charset) throws IOException {
		this(new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), charset)), false), format, charset);
	}

	public VerificationFileWriter(PrintWriter out, VerificationFormat format, Charset charset) {
		this.out = out;
		this.format = format;

		// start by printing the file header
		writeHeader(charset);
	}

	protected void writeHeader(Charset charset) {
		out.format("; Generated by %s %s on %tF at %<tT%n", Settings.getApplicationName(), Settings.getApplicationVersion(), new Date());
		out.format("; charset=%s%n", charset);
		out.format(";%n");
	}

	public void write(String path, String hash) {
		out.format("%s%n", format.format(path, hash));
	}

	@Override
	public void close() throws IOException {
		out.close();
	}

}
