/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextColor;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;

public class TextCharacter {
    public static final TextCharacter DEFAULT_CHARACTER = new TextCharacter(' ', (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]);
    private final char character;
    private final TextColor foregroundColor;
    private final TextColor backgroundColor;
    private final EnumSet<SGR> modifiers;

    private static EnumSet<SGR> toEnumSet(SGR ... modifiers) {
        if (modifiers.length == 0) {
            return EnumSet.noneOf(SGR.class);
        }
        return EnumSet.copyOf(Arrays.asList(modifiers));
    }

    public TextCharacter(char character) {
        this(character, (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]);
    }

    public TextCharacter(TextCharacter character) {
        this(character.getCharacter(), character.getForegroundColor(), character.getBackgroundColor(), character.getModifiers().toArray(new SGR[character.getModifiers().size()]));
    }

    public TextCharacter(char character, TextColor foregroundColor, TextColor backgroundColor, SGR ... styles) {
        this(character, foregroundColor, backgroundColor, TextCharacter.toEnumSet(styles));
    }

    public TextCharacter(char character, TextColor foregroundColor, TextColor backgroundColor, EnumSet<SGR> modifiers) {
        if (TerminalTextUtils.isControlCharacter(character) && character != '\t') {
            throw new IllegalArgumentException("Cannot create a TextCharacter from a control character (0x" + Integer.toHexString(character) + ")");
        }
        if (foregroundColor == null) {
            foregroundColor = TextColor.ANSI.DEFAULT;
        }
        if (backgroundColor == null) {
            backgroundColor = TextColor.ANSI.DEFAULT;
        }
        this.character = character;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.modifiers = EnumSet.copyOf(modifiers);
    }

    public char getCharacter() {
        return this.character;
    }

    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public EnumSet<SGR> getModifiers() {
        return EnumSet.copyOf(this.modifiers);
    }

    public boolean isBold() {
        return this.modifiers.contains((Object)SGR.BOLD);
    }

    public boolean isReversed() {
        return this.modifiers.contains((Object)SGR.REVERSE);
    }

    public boolean isUnderlined() {
        return this.modifiers.contains((Object)SGR.UNDERLINE);
    }

    public boolean isBlinking() {
        return this.modifiers.contains((Object)SGR.BLINK);
    }

    public boolean isBordered() {
        return this.modifiers.contains((Object)SGR.BORDERED);
    }

    public boolean isCrossedOut() {
        return this.modifiers.contains((Object)SGR.CROSSED_OUT);
    }

    public boolean isItalic() {
        return this.modifiers.contains((Object)SGR.ITALIC);
    }

    public TextCharacter withCharacter(char character) {
        if (this.character == character) {
            return this;
        }
        return new TextCharacter(character, this.foregroundColor, this.backgroundColor, this.modifiers);
    }

    public TextCharacter withForegroundColor(TextColor foregroundColor) {
        if (this.foregroundColor == foregroundColor || this.foregroundColor.equals(foregroundColor)) {
            return this;
        }
        return new TextCharacter(this.character, foregroundColor, this.backgroundColor, this.modifiers);
    }

    public TextCharacter withBackgroundColor(TextColor backgroundColor) {
        if (this.backgroundColor == backgroundColor || this.backgroundColor.equals(backgroundColor)) {
            return this;
        }
        return new TextCharacter(this.character, this.foregroundColor, backgroundColor, this.modifiers);
    }

    public TextCharacter withModifiers(Collection<SGR> modifiers) {
        EnumSet<SGR> newSet = EnumSet.copyOf(modifiers);
        if (modifiers.equals(newSet)) {
            return this;
        }
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public TextCharacter withModifier(SGR modifier) {
        if (this.modifiers.contains((Object)modifier)) {
            return this;
        }
        EnumSet<SGR> newSet = EnumSet.copyOf(this.modifiers);
        newSet.add(modifier);
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public TextCharacter withoutModifier(SGR modifier) {
        if (!this.modifiers.contains((Object)modifier)) {
            return this;
        }
        EnumSet<SGR> newSet = EnumSet.copyOf(this.modifiers);
        newSet.remove((Object)modifier);
        return new TextCharacter(this.character, this.foregroundColor, this.backgroundColor, newSet);
    }

    public boolean isDoubleWidth() {
        return TerminalTextUtils.isCharDoubleWidth(this.character);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextCharacter other = (TextCharacter)obj;
        if (this.character != other.character) {
            return false;
        }
        if (!(this.foregroundColor == other.foregroundColor || this.foregroundColor != null && this.foregroundColor.equals(other.foregroundColor))) {
            return false;
        }
        if (!(this.backgroundColor == other.backgroundColor || this.backgroundColor != null && this.backgroundColor.equals(other.backgroundColor))) {
            return false;
        }
        return this.modifiers == other.modifiers || this.modifiers != null && this.modifiers.equals(other.modifiers);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.character;
        hash = 37 * hash + (this.foregroundColor != null ? this.foregroundColor.hashCode() : 0);
        hash = 37 * hash + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        hash = 37 * hash + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "TextCharacter{character=" + this.character + ", foregroundColor=" + this.foregroundColor + ", backgroundColor=" + this.backgroundColor + ", modifiers=" + this.modifiers + '}';
    }
}

