/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.AbstractListBox;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CheckBoxList<V>
extends AbstractListBox<V, CheckBoxList<V>> {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final List<Boolean> itemStatus = new ArrayList<Boolean>();

    public CheckBoxList() {
        this(null);
    }

    public CheckBoxList(TerminalSize preferredSize) {
        super(preferredSize);
    }

    @Override
    protected AbstractListBox.ListItemRenderer<V, CheckBoxList<V>> createDefaultListItemRenderer() {
        return new CheckBoxListItemRenderer();
    }

    @Override
    public synchronized CheckBoxList<V> clearItems() {
        this.itemStatus.clear();
        return (CheckBoxList)super.clearItems();
    }

    @Override
    public CheckBoxList<V> addItem(V object) {
        return this.addItem(object, false);
    }

    @Override
    public synchronized V removeItem(int index) {
        Object item = super.removeItem(index);
        this.itemStatus.remove(index);
        return item;
    }

    public synchronized CheckBoxList<V> addItem(V object, boolean checkedState) {
        this.itemStatus.add(checkedState);
        return (CheckBoxList)super.addItem(object);
    }

    public synchronized Boolean isChecked(V object) {
        if (this.indexOf(object) == -1) {
            return null;
        }
        return this.itemStatus.get(this.indexOf(object));
    }

    public synchronized Boolean isChecked(int index) {
        if (index < 0 || index >= this.itemStatus.size()) {
            return null;
        }
        return this.itemStatus.get(index);
    }

    public synchronized CheckBoxList<V> setChecked(V object, boolean checked) {
        int index = this.indexOf(object);
        if (index != -1) {
            this.setChecked(index, checked);
        }
        return (CheckBoxList)this.self();
    }

    private void setChecked(final int index, final boolean checked) {
        this.itemStatus.set(index, checked);
        this.runOnGUIThreadIfExistsOtherwiseRunDirect(new Runnable(){

            @Override
            public void run() {
                for (Listener listener : CheckBoxList.this.listeners) {
                    listener.onStatusChanged(index, checked);
                }
            }
        });
    }

    public synchronized List<V> getCheckedItems() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.itemStatus.size(); ++i) {
            if (!this.itemStatus.get(i).booleanValue()) continue;
            result.add(this.getItemAt(i));
        }
        return result;
    }

    public synchronized CheckBoxList<V> addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public CheckBoxList<V> removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (keyStroke.getKeyType() == KeyType.Enter || keyStroke.getKeyType() == KeyType.Character && keyStroke.getCharacter().charValue() == ' ') {
            if (this.itemStatus.get(this.getSelectedIndex()).booleanValue()) {
                this.setChecked(this.getSelectedIndex(), (boolean)Boolean.FALSE);
            } else {
                this.setChecked(this.getSelectedIndex(), (boolean)Boolean.TRUE);
            }
            return Interactable.Result.HANDLED;
        }
        return super.handleKeyStroke(keyStroke);
    }

    public static class CheckBoxListItemRenderer<V>
    extends AbstractListBox.ListItemRenderer<V, CheckBoxList<V>> {
        @Override
        public int getHotSpotPositionOnLine(int selectedIndex) {
            return 1;
        }

        @Override
        public String getLabel(CheckBoxList<V> listBox, int index, V item) {
            String check = " ";
            List itemStatus = ((CheckBoxList)listBox).itemStatus;
            if (((Boolean)itemStatus.get(index)).booleanValue()) {
                check = "x";
            }
            String text = item.toString();
            return "[" + check + "] " + text;
        }

        @Override
        public void drawItem(TextGUIGraphics graphics, CheckBoxList<V> listBox, int index, V item, boolean selected, boolean focused) {
            ThemeDefinition themeDefinition = listBox.getTheme().getDefinition(CheckBoxList.class);
            ThemeStyle itemStyle = selected && !focused ? themeDefinition.getSelected() : (selected ? themeDefinition.getActive() : (focused ? themeDefinition.getInsensitive() : themeDefinition.getNormal()));
            if (themeDefinition.getBooleanProperty("CLEAR_WITH_NORMAL", false)) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
                graphics.fill(' ');
                graphics.applyThemeStyle(itemStyle);
            } else {
                graphics.applyThemeStyle(itemStyle);
                graphics.fill(' ');
            }
            String brackets = themeDefinition.getCharacter("LEFT_BRACKET", '[') + " " + themeDefinition.getCharacter("RIGHT_BRACKET", ']');
            if (themeDefinition.getBooleanProperty("FIXED_BRACKET_COLOR", false)) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
                graphics.putString(0, 0, brackets);
                graphics.applyThemeStyle(itemStyle);
            } else {
                graphics.putString(0, 0, brackets);
            }
            String text = (item != null ? item : "<null>").toString();
            graphics.putString(4, 0, text);
            boolean itemChecked = listBox.isChecked(index);
            char marker = themeDefinition.getCharacter("MARKER", 'x');
            if (themeDefinition.getBooleanProperty("MARKER_WITH_NORMAL", false)) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            if (selected && focused && themeDefinition.getBooleanProperty("HOTSPOT_PRELIGHT", false)) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            }
            graphics.setCharacter(1, 0, itemChecked ? marker : (char)' ');
        }
    }

    public static interface Listener {
        public void onStatusChanged(int var1, boolean var2);
    }
}

