/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.dialogs;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.dialogs.AbstractDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.ActionListDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ActionListDialogBuilder
extends AbstractDialogBuilder<ActionListDialogBuilder, ActionListDialog> {
    private final List<Runnable> actions = new ArrayList<Runnable>();
    private TerminalSize listBoxSize = null;
    private boolean canCancel = true;

    public ActionListDialogBuilder() {
        super("ActionListDialogBuilder");
    }

    @Override
    protected ActionListDialogBuilder self() {
        return this;
    }

    @Override
    protected ActionListDialog buildDialog() {
        return new ActionListDialog(this.title, this.description, this.listBoxSize, this.canCancel, this.actions);
    }

    public ActionListDialogBuilder setListBoxSize(TerminalSize listBoxSize) {
        this.listBoxSize = listBoxSize;
        return this;
    }

    public TerminalSize getListBoxSize() {
        return this.listBoxSize;
    }

    public ActionListDialogBuilder setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
        return this;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public ActionListDialogBuilder addAction(final String label, final Runnable action) {
        return this.addAction(new Runnable(){

            public String toString() {
                return label;
            }

            @Override
            public void run() {
                action.run();
            }
        });
    }

    public ActionListDialogBuilder addAction(Runnable action) {
        this.actions.add(action);
        return this;
    }

    public ActionListDialogBuilder addActions(Runnable ... actions) {
        this.actions.addAll(Arrays.asList(actions));
        return this;
    }

    public List<Runnable> getActions() {
        return new ArrayList<Runnable>(this.actions);
    }
}

