/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.ScrollBar;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.gui2.table.TableCellBorderStyle;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;
import com.googlecode.lanterna.gui2.table.TableHeaderRenderer;
import com.googlecode.lanterna.gui2.table.TableModel;
import com.googlecode.lanterna.gui2.table.TableRenderer;
import java.util.ArrayList;
import java.util.List;

public class DefaultTableRenderer<V>
implements TableRenderer<V> {
    private final ScrollBar verticalScrollBar = new ScrollBar(Direction.VERTICAL);
    private final ScrollBar horizontalScrollBar = new ScrollBar(Direction.HORIZONTAL);
    private TableCellBorderStyle headerVerticalBorderStyle = TableCellBorderStyle.None;
    private TableCellBorderStyle headerHorizontalBorderStyle = TableCellBorderStyle.EmptySpace;
    private TableCellBorderStyle cellVerticalBorderStyle = TableCellBorderStyle.None;
    private TableCellBorderStyle cellHorizontalBorderStyle = TableCellBorderStyle.EmptySpace;
    private TerminalSize cachedSize = null;
    private final List<Integer> columnSizes = new ArrayList<Integer>();
    private final List<Integer> rowSizes = new ArrayList<Integer>();
    private int headerSizeInRows = 0;

    public void setHeaderVerticalBorderStyle(TableCellBorderStyle headerVerticalBorderStyle) {
        this.headerVerticalBorderStyle = headerVerticalBorderStyle;
    }

    public void setHeaderHorizontalBorderStyle(TableCellBorderStyle headerHorizontalBorderStyle) {
        this.headerHorizontalBorderStyle = headerHorizontalBorderStyle;
    }

    public void setCellVerticalBorderStyle(TableCellBorderStyle cellVerticalBorderStyle) {
        this.cellVerticalBorderStyle = cellVerticalBorderStyle;
    }

    public void setCellHorizontalBorderStyle(TableCellBorderStyle cellHorizontalBorderStyle) {
        this.cellHorizontalBorderStyle = cellHorizontalBorderStyle;
    }

    private boolean isHorizontallySpaced() {
        return this.headerHorizontalBorderStyle != TableCellBorderStyle.None || this.cellHorizontalBorderStyle != TableCellBorderStyle.None;
    }

    @Override
    public TerminalSize getPreferredSize(Table<V> table) {
        int listOffset;
        int columnIndex;
        if (!table.isInvalid() && this.cachedSize != null) {
            return this.cachedSize;
        }
        TableModel<V> tableModel = table.getTableModel();
        int viewLeftColumn = table.getViewLeftColumn();
        int viewTopRow = table.getViewTopRow();
        int visibleColumns = table.getVisibleColumns();
        int visibleRows = table.getVisibleRows();
        List<List<V>> rows = tableModel.getRows();
        List<String> columnHeaders = tableModel.getColumnLabels();
        TableHeaderRenderer<V> tableHeaderRenderer = table.getTableHeaderRenderer();
        TableCellRenderer<V> tableCellRenderer = table.getTableCellRenderer();
        if (visibleColumns == 0) {
            visibleColumns = tableModel.getColumnCount();
        }
        if (visibleRows == 0) {
            visibleRows = tableModel.getRowCount();
        }
        this.columnSizes.clear();
        this.rowSizes.clear();
        if (tableModel.getColumnCount() == 0) {
            return TerminalSize.ZERO;
        }
        if (rows.size() == 0) {
            for (columnIndex = viewLeftColumn; columnIndex < viewLeftColumn + visibleColumns; ++columnIndex) {
                int columnSize = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex), columnIndex).getColumns();
                int listOffset2 = columnIndex - viewLeftColumn;
                if (this.columnSizes.size() == listOffset2) {
                    this.columnSizes.add(columnSize);
                    continue;
                }
                if (this.columnSizes.get(listOffset2) >= columnSize) continue;
                this.columnSizes.set(listOffset2, columnSize);
            }
        }
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            int columnIndex2;
            List<V> row = rows.get(rowIndex);
            for (columnIndex2 = viewLeftColumn; columnIndex2 < Math.min(row.size(), viewLeftColumn + visibleColumns); ++columnIndex2) {
                V cell = row.get(columnIndex2);
                int columnSize = tableCellRenderer.getPreferredSize(table, cell, columnIndex2, rowIndex).getColumns();
                int listOffset3 = columnIndex2 - viewLeftColumn;
                if (this.columnSizes.size() == listOffset3) {
                    this.columnSizes.add(columnSize);
                    continue;
                }
                if (this.columnSizes.get(listOffset3) >= columnSize) continue;
                this.columnSizes.set(listOffset3, columnSize);
            }
            if (rowIndex != 0) continue;
            for (columnIndex2 = viewLeftColumn; columnIndex2 < Math.min(row.size(), viewLeftColumn + visibleColumns); ++columnIndex2) {
                int columnSize = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex2), columnIndex2).getColumns();
                listOffset = columnIndex2 - viewLeftColumn;
                if (this.columnSizes.size() == listOffset) {
                    this.columnSizes.add(columnSize);
                    continue;
                }
                if (this.columnSizes.get(listOffset) >= columnSize) continue;
                this.columnSizes.set(listOffset, columnSize);
            }
        }
        for (columnIndex = 0; columnIndex < columnHeaders.size(); ++columnIndex) {
            for (int rowIndex = viewTopRow; rowIndex < Math.min(rows.size(), viewTopRow + visibleRows); ++rowIndex) {
                V cell = rows.get(rowIndex).get(columnIndex);
                int rowSize = tableCellRenderer.getPreferredSize(table, cell, columnIndex, rowIndex).getRows();
                listOffset = rowIndex - viewTopRow;
                if (this.rowSizes.size() == listOffset) {
                    this.rowSizes.add(rowSize);
                    continue;
                }
                if (this.rowSizes.get(listOffset) >= rowSize) continue;
                this.rowSizes.set(listOffset, rowSize);
            }
        }
        int preferredRowSize = 0;
        int preferredColumnSize = 0;
        for (int size : this.columnSizes) {
            preferredColumnSize += size;
        }
        for (int size : this.rowSizes) {
            preferredRowSize += size;
        }
        this.headerSizeInRows = 0;
        for (int columnIndex3 = 0; columnIndex3 < columnHeaders.size(); ++columnIndex3) {
            int headerRows = tableHeaderRenderer.getPreferredSize(table, columnHeaders.get(columnIndex3), columnIndex3).getRows();
            if (this.headerSizeInRows >= headerRows) continue;
            this.headerSizeInRows = headerRows;
        }
        preferredRowSize += this.headerSizeInRows;
        if (this.headerVerticalBorderStyle != TableCellBorderStyle.None) {
            ++preferredRowSize;
        }
        if (this.cellVerticalBorderStyle != TableCellBorderStyle.None && !rows.isEmpty()) {
            preferredRowSize += Math.min(rows.size(), visibleRows) - 1;
        }
        if (this.isHorizontallySpaced() && !columnHeaders.isEmpty()) {
            preferredColumnSize += Math.min(tableModel.getColumnCount(), visibleColumns) - 1;
        }
        if (visibleRows < rows.size()) {
            ++preferredColumnSize;
        }
        if (visibleColumns < tableModel.getColumnCount()) {
            ++preferredRowSize;
        }
        this.cachedSize = new TerminalSize(preferredColumnSize, preferredRowSize);
        return this.cachedSize;
    }

    @Override
    public TerminalPosition getCursorLocation(Table<V> component) {
        return null;
    }

    @Override
    public void drawComponent(TextGUIGraphics graphics, Table<V> table) {
        TerminalSize area = graphics.getSize();
        if (area.getRows() == 0 || area.getColumns() == 0) {
            return;
        }
        if (table.isInvalid()) {
            this.getPreferredSize(table);
        }
        int topPosition = this.drawHeader(graphics, table);
        this.drawRows(graphics, table, topPosition);
    }

    private int drawHeader(TextGUIGraphics graphics, Table<V> table) {
        Theme theme = table.getTheme();
        TableHeaderRenderer<V> tableHeaderRenderer = table.getTableHeaderRenderer();
        List<String> headers = table.getTableModel().getColumnLabels();
        int viewLeftColumn = table.getViewLeftColumn();
        int visibleColumns = table.getVisibleColumns();
        if (visibleColumns == 0) {
            visibleColumns = table.getTableModel().getColumnCount();
        }
        int topPosition = 0;
        int leftPosition = 0;
        int endColumnIndex = Math.min(headers.size(), viewLeftColumn + visibleColumns);
        for (int index = viewLeftColumn; index < endColumnIndex; ++index) {
            String label = headers.get(index);
            TerminalSize size = new TerminalSize(this.columnSizes.get(index - viewLeftColumn), this.headerSizeInRows);
            tableHeaderRenderer.drawHeader(table, label, index, graphics.newTextGraphics(new TerminalPosition(leftPosition, 0), size));
            leftPosition += size.getColumns();
            if (this.headerHorizontalBorderStyle == TableCellBorderStyle.None || index >= endColumnIndex - 1) continue;
            graphics.applyThemeStyle(theme.getDefinition(Table.class).getNormal());
            graphics.setCharacter(leftPosition, 0, this.getVerticalCharacter(this.headerHorizontalBorderStyle));
            ++leftPosition;
        }
        topPosition += this.headerSizeInRows;
        if (this.headerVerticalBorderStyle != TableCellBorderStyle.None) {
            leftPosition = 0;
            graphics.applyThemeStyle(theme.getDefinition(Table.class).getNormal());
            for (int i = 0; i < this.columnSizes.size(); ++i) {
                if (i > 0) {
                    graphics.setCharacter(leftPosition, topPosition, this.getJunctionCharacter(this.headerVerticalBorderStyle, this.headerHorizontalBorderStyle, this.cellHorizontalBorderStyle));
                    ++leftPosition;
                }
                int columnWidth = this.columnSizes.get(i);
                graphics.drawLine(leftPosition, topPosition, leftPosition + columnWidth - 1, topPosition, this.getHorizontalCharacter(this.headerVerticalBorderStyle));
                leftPosition += columnWidth;
            }
            if (leftPosition < graphics.getSize().getColumns()) {
                graphics.drawLine(leftPosition, topPosition, graphics.getSize().getColumns() - 1, topPosition, this.getHorizontalCharacter(this.headerVerticalBorderStyle));
            }
            ++topPosition;
        }
        return topPosition;
    }

    private void drawRows(TextGUIGraphics graphics, Table<V> table, int topPosition) {
        Theme theme = table.getTheme();
        ThemeDefinition themeDefinition = theme.getDefinition(Table.class);
        TerminalSize area = graphics.getSize();
        TableCellRenderer<V> tableCellRenderer = table.getTableCellRenderer();
        TableModel<V> tableModel = table.getTableModel();
        List<List<V>> rows = tableModel.getRows();
        int viewTopRow = table.getViewTopRow();
        int viewLeftColumn = table.getViewLeftColumn();
        int visibleRows = table.getVisibleRows();
        int visibleColumns = table.getVisibleColumns();
        if (visibleColumns == 0) {
            visibleColumns = tableModel.getColumnCount();
        }
        if (visibleRows == 0) {
            visibleRows = tableModel.getRowCount();
        }
        if (visibleRows < rows.size()) {
            TerminalSize verticalScrollBarPreferredSize = this.verticalScrollBar.getPreferredSize();
            int scrollBarHeight = graphics.getSize().getRows() - topPosition;
            if (visibleColumns < tableModel.getColumnCount()) {
                --scrollBarHeight;
            }
            this.verticalScrollBar.setPosition(new TerminalPosition(graphics.getSize().getColumns() - verticalScrollBarPreferredSize.getColumns(), topPosition));
            this.verticalScrollBar.setSize(verticalScrollBarPreferredSize.withRows(scrollBarHeight));
            this.verticalScrollBar.setScrollMaximum(rows.size());
            this.verticalScrollBar.setViewSize(visibleRows);
            this.verticalScrollBar.setScrollPosition(viewTopRow);
            if (table.getParent() != this.verticalScrollBar.getParent()) {
                if (this.verticalScrollBar.getParent() != null) {
                    this.verticalScrollBar.onRemoved(this.verticalScrollBar.getParent());
                }
                if (table.getParent() != null) {
                    this.verticalScrollBar.onAdded(table.getParent());
                }
            }
            this.verticalScrollBar.draw(graphics.newTextGraphics(this.verticalScrollBar.getPosition(), this.verticalScrollBar.getSize()));
            graphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, graphics.getSize().withRelativeColumns(-verticalScrollBarPreferredSize.getColumns()));
        }
        if (visibleColumns < tableModel.getColumnCount()) {
            TerminalSize horizontalScrollBarPreferredSize = this.horizontalScrollBar.getPreferredSize();
            int scrollBarWidth = graphics.getSize().getColumns();
            this.horizontalScrollBar.setPosition(new TerminalPosition(0, graphics.getSize().getRows() - horizontalScrollBarPreferredSize.getRows()));
            this.horizontalScrollBar.setSize(horizontalScrollBarPreferredSize.withColumns(scrollBarWidth));
            this.horizontalScrollBar.setScrollMaximum(tableModel.getColumnCount());
            this.horizontalScrollBar.setViewSize(visibleColumns);
            this.horizontalScrollBar.setScrollPosition(viewLeftColumn);
            if (table.getParent() != this.horizontalScrollBar.getParent()) {
                if (this.horizontalScrollBar.getParent() != null) {
                    this.horizontalScrollBar.onRemoved(this.horizontalScrollBar.getParent());
                }
                if (table.getParent() != null) {
                    this.horizontalScrollBar.onAdded(table.getParent());
                }
            }
            this.horizontalScrollBar.draw(graphics.newTextGraphics(this.horizontalScrollBar.getPosition(), this.horizontalScrollBar.getSize()));
            graphics = graphics.newTextGraphics(TerminalPosition.TOP_LEFT_CORNER, graphics.getSize().withRelativeRows(-horizontalScrollBarPreferredSize.getRows()));
        }
        for (int rowIndex = viewTopRow; rowIndex < Math.min(viewTopRow + visibleRows, rows.size()); ++rowIndex) {
            int leftPosition = 0;
            List<V> row = rows.get(rowIndex);
            for (int columnIndex = viewLeftColumn; columnIndex < Math.min(viewLeftColumn + visibleColumns, row.size()); ++columnIndex) {
                if (columnIndex > viewLeftColumn) {
                    if (table.getSelectedRow() == rowIndex && !table.isCellSelection()) {
                        if (table.isFocused()) {
                            graphics.applyThemeStyle(themeDefinition.getActive());
                        } else {
                            graphics.applyThemeStyle(themeDefinition.getSelected());
                        }
                    } else {
                        graphics.applyThemeStyle(themeDefinition.getNormal());
                    }
                    graphics.setCharacter(leftPosition, topPosition, this.getVerticalCharacter(this.cellHorizontalBorderStyle));
                    ++leftPosition;
                }
                V cell = row.get(columnIndex);
                TerminalPosition cellPosition = new TerminalPosition(leftPosition, topPosition);
                TerminalSize cellArea = new TerminalSize(this.columnSizes.get(columnIndex - viewLeftColumn), this.rowSizes.get(rowIndex - viewTopRow));
                tableCellRenderer.drawCell(table, cell, columnIndex, rowIndex, graphics.newTextGraphics(cellPosition, cellArea));
                if ((leftPosition += cellArea.getColumns()) > area.getColumns()) break;
            }
            topPosition += this.rowSizes.get(rowIndex - viewTopRow).intValue();
            if (this.cellVerticalBorderStyle != TableCellBorderStyle.None) {
                leftPosition = 0;
                graphics.applyThemeStyle(themeDefinition.getNormal());
                for (int i = 0; i < this.columnSizes.size(); ++i) {
                    if (i > 0) {
                        graphics.setCharacter(leftPosition, topPosition, this.getJunctionCharacter(this.cellVerticalBorderStyle, this.cellHorizontalBorderStyle, this.cellHorizontalBorderStyle));
                        ++leftPosition;
                    }
                    int columnWidth = this.columnSizes.get(i);
                    graphics.drawLine(leftPosition, topPosition, leftPosition + columnWidth - 1, topPosition, this.getHorizontalCharacter(this.cellVerticalBorderStyle));
                    leftPosition += columnWidth;
                }
                ++topPosition;
            }
            if (topPosition > area.getRows()) break;
        }
    }

    private char getHorizontalCharacter(TableCellBorderStyle style) {
        switch (style) {
            case SingleLine: {
                return '\u2500';
            }
            case DoubleLine: {
                return '\u2550';
            }
        }
        return ' ';
    }

    private char getVerticalCharacter(TableCellBorderStyle style) {
        switch (style) {
            case SingleLine: {
                return '\u2502';
            }
            case DoubleLine: {
                return '\u2551';
            }
        }
        return ' ';
    }

    private char getJunctionCharacter(TableCellBorderStyle mainStyle, TableCellBorderStyle styleAbove, TableCellBorderStyle styleBelow) {
        if (mainStyle == TableCellBorderStyle.SingleLine) {
            if (styleAbove == TableCellBorderStyle.SingleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u253c';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u2534';
                }
                return '\u2534';
            }
            if (styleAbove == TableCellBorderStyle.DoubleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u2568';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u256b';
                }
                return '\u2568';
            }
            if (styleBelow == TableCellBorderStyle.SingleLine) {
                return '\u252c';
            }
            if (styleBelow == TableCellBorderStyle.DoubleLine) {
                return '\u2565';
            }
            return '\u2500';
        }
        if (mainStyle == TableCellBorderStyle.DoubleLine) {
            if (styleAbove == TableCellBorderStyle.SingleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u256a';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u2567';
                }
                return '\u2567';
            }
            if (styleAbove == TableCellBorderStyle.DoubleLine) {
                if (styleBelow == TableCellBorderStyle.SingleLine) {
                    return '\u2569';
                }
                if (styleBelow == TableCellBorderStyle.DoubleLine) {
                    return '\u256c';
                }
                return '\u2569';
            }
            if (styleBelow == TableCellBorderStyle.SingleLine) {
                return '\u2564';
            }
            if (styleBelow == TableCellBorderStyle.DoubleLine) {
                return '\u2566';
            }
            return '\u2550';
        }
        return ' ';
    }
}

