/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.terminal.Terminal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class TerminalTextGraphics
extends AbstractTextGraphics {
    private final Terminal terminal;
    private final TerminalSize terminalSize;
    private final Map<TerminalPosition, TextCharacter> writeHistory;
    private AtomicInteger manageCallStackSize;
    private TextCharacter lastCharacter;
    private TerminalPosition lastPosition;

    TerminalTextGraphics(Terminal terminal) throws IOException {
        this.terminal = terminal;
        this.terminalSize = terminal.getTerminalSize();
        this.manageCallStackSize = new AtomicInteger(0);
        this.writeHistory = new HashMap<TerminalPosition, TextCharacter>();
        this.lastCharacter = null;
        this.lastPosition = null;
    }

    @Override
    public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
        return this.setCharacter(new TerminalPosition(columnIndex, rowIndex), textCharacter);
    }

    @Override
    public synchronized TextGraphics setCharacter(TerminalPosition position, TextCharacter textCharacter) {
        try {
            if (this.manageCallStackSize.get() > 0) {
                if (this.lastCharacter == null || !this.lastCharacter.equals(textCharacter)) {
                    this.applyGraphicState(textCharacter);
                    this.lastCharacter = textCharacter;
                }
                if (this.lastPosition == null || !this.lastPosition.equals(position)) {
                    this.terminal.setCursorPosition(position.getColumn(), position.getRow());
                    this.lastPosition = position;
                }
            } else {
                this.terminal.setCursorPosition(position.getColumn(), position.getRow());
                this.applyGraphicState(textCharacter);
            }
            this.terminal.putCharacter(textCharacter.getCharacter());
            if (this.manageCallStackSize.get() > 0) {
                this.lastPosition = position.withRelativeColumn(1);
            }
            this.writeHistory.put(position, textCharacter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public TextCharacter getCharacter(int column, int row) {
        return this.getCharacter(new TerminalPosition(column, row));
    }

    @Override
    public synchronized TextCharacter getCharacter(TerminalPosition position) {
        return this.writeHistory.get(position);
    }

    private void applyGraphicState(TextCharacter textCharacter) throws IOException {
        this.terminal.resetColorAndSGR();
        this.terminal.setForegroundColor(textCharacter.getForegroundColor());
        this.terminal.setBackgroundColor(textCharacter.getBackgroundColor());
        for (SGR sgr : textCharacter.getModifiers()) {
            this.terminal.enableSGR(sgr);
        }
    }

    @Override
    public TerminalSize getSize() {
        return this.terminalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics drawLine(TerminalPosition fromPoint, TerminalPosition toPoint, char character) {
        try {
            this.enterAtomic();
            super.drawLine(fromPoint, toPoint, character);
            TerminalTextGraphics terminalTextGraphics = this;
            return terminalTextGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics drawTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        try {
            this.enterAtomic();
            super.drawTriangle(p1, p2, p3, character);
            TerminalTextGraphics terminalTextGraphics = this;
            return terminalTextGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics fillTriangle(TerminalPosition p1, TerminalPosition p2, TerminalPosition p3, char character) {
        try {
            this.enterAtomic();
            super.fillTriangle(p1, p2, p3, character);
            TerminalTextGraphics terminalTextGraphics = this;
            return terminalTextGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics fillRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        try {
            this.enterAtomic();
            super.fillRectangle(topLeft, size, character);
            TerminalTextGraphics terminalTextGraphics = this;
            return terminalTextGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics drawRectangle(TerminalPosition topLeft, TerminalSize size, char character) {
        try {
            this.enterAtomic();
            super.drawRectangle(topLeft, size, character);
            TerminalTextGraphics terminalTextGraphics = this;
            return terminalTextGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TextGraphics putString(int column, int row, String string) {
        try {
            this.enterAtomic();
            TextGraphics textGraphics = super.putString(column, row, string);
            return textGraphics;
        }
        finally {
            this.leaveAtomic();
        }
    }

    private void enterAtomic() {
        this.manageCallStackSize.incrementAndGet();
    }

    private void leaveAtomic() {
        if (this.manageCallStackSize.decrementAndGet() == 0) {
            this.lastPosition = null;
            this.lastCharacter = null;
        }
    }
}

