/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.terminal.ansi.ANSITerminal;
import com.googlecode.lanterna.terminal.ansi.TelnetProtocol;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TelnetTerminal
extends ANSITerminal {
    private final Socket socket;
    private final NegotiationState negotiationState;

    TelnetTerminal(Socket socket, Charset terminalCharset) throws IOException {
        this(socket, new TelnetClientIACFilterer(socket.getInputStream()), socket.getOutputStream(), terminalCharset);
    }

    private TelnetTerminal(Socket socket, TelnetClientIACFilterer inputStream, OutputStream outputStream, Charset terminalCharset) throws IOException {
        super(inputStream, outputStream, terminalCharset);
        this.socket = socket;
        this.negotiationState = inputStream.negotiationState;
        inputStream.setEventListener(new TelnetClientEventListener(){

            @Override
            public void onResize(int columns, int rows) {
                TelnetTerminal.this.onResized(columns, rows);
            }

            @Override
            public void requestReply(boolean will, byte option) throws IOException {
                TelnetTerminal.this.writeToTerminal(-1, will ? (byte)-5 : -4, option);
            }
        });
        this.setLineMode0();
        this.setEchoOff();
        this.setResizeNotificationOn();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    private void setEchoOff() throws IOException {
        this.writeToTerminal(-1, -5, 1);
        this.flush();
    }

    private void setLineMode0() throws IOException {
        this.writeToTerminal(-1, -3, 34, -1, -6, 34, 1, 0, -1, -16);
        this.flush();
    }

    private void setResizeNotificationOn() throws IOException {
        this.writeToTerminal(-1, -3, 31);
        this.flush();
    }

    public NegotiationState getNegotiationState() {
        return this.negotiationState;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.socket.close();
    }

    private static int convertTwoBytesToInt2(byte b1, byte b2) {
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    private static class TelnetClientIACFilterer
    extends InputStream {
        private final NegotiationState negotiationState = new NegotiationState();
        private final InputStream inputStream;
        private final byte[] buffer;
        private final byte[] workingBuffer;
        private int bytesInBuffer;
        private TelnetClientEventListener eventListener;

        TelnetClientIACFilterer(InputStream inputStream) {
            this.inputStream = inputStream;
            this.buffer = new byte[65536];
            this.workingBuffer = new byte[1024];
            this.bytesInBuffer = 0;
            this.eventListener = null;
        }

        private void setEventListener(TelnetClientEventListener eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("TelnetClientIACFilterer doesn't support .read()");
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public int available() throws IOException {
            int underlyingStreamAvailable = this.inputStream.available();
            if (underlyingStreamAvailable == 0 && this.bytesInBuffer == 0) {
                return 0;
            }
            if (underlyingStreamAvailable == 0) {
                return this.bytesInBuffer;
            }
            if (this.bytesInBuffer == this.buffer.length) {
                return this.bytesInBuffer;
            }
            this.fillBuffer();
            return this.bytesInBuffer;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.inputStream.available() > 0) {
                this.fillBuffer();
            }
            if (this.bytesInBuffer == 0) {
                return -1;
            }
            int bytesToCopy = Math.min(len, this.bytesInBuffer);
            System.arraycopy(this.buffer, 0, b, off, bytesToCopy);
            System.arraycopy(this.buffer, bytesToCopy, this.buffer, 0, this.buffer.length - bytesToCopy);
            this.bytesInBuffer -= bytesToCopy;
            return bytesToCopy;
        }

        private void fillBuffer() throws IOException {
            int readBytes = this.inputStream.read(this.workingBuffer, 0, Math.min(this.workingBuffer.length, this.buffer.length - this.bytesInBuffer));
            if (readBytes == -1) {
                return;
            }
            for (int i = 0; i < readBytes; ++i) {
                if (this.workingBuffer[i] == -1) {
                    if (Arrays.asList((byte)-3, (byte)-2, (byte)-5, (byte)-4).contains(this.workingBuffer[++i])) {
                        this.parseCommand(this.workingBuffer, i, readBytes);
                        ++i;
                        continue;
                    }
                    if (this.workingBuffer[i] == -6) {
                        i = i++ + this.parseSubNegotiation(this.workingBuffer, i, readBytes);
                        continue;
                    }
                    if (this.workingBuffer[i] != -1) {
                        System.err.println("Unknown Telnet command: " + this.workingBuffer[i]);
                    }
                }
                this.buffer[this.bytesInBuffer++] = this.workingBuffer[i];
            }
        }

        private void parseCommand(byte[] buffer, int position, int max) throws IOException {
            if (position + 1 >= max) {
                throw new IllegalStateException("State error, we got a command signal from the remote telnet client but not enough characters available in the stream");
            }
            byte command = buffer[position];
            byte value = buffer[position + 1];
            switch (command) {
                case -3: 
                case -2: {
                    if (value == 3) {
                        this.negotiationState.suppressGoAhead = command == -3;
                        this.eventListener.requestReply(command == -3, value);
                        break;
                    }
                    if (value == 1) {
                        this.negotiationState.extendedAscii = command == -3;
                        this.eventListener.requestReply(command == -3, value);
                        break;
                    }
                    this.negotiationState.onUnsupportedRequestCommand(command == -3, value);
                    break;
                }
                case -5: 
                case -4: {
                    if (value == 1) {
                        this.negotiationState.clientEcho = command == -5;
                        break;
                    }
                    if (value == 34) {
                        this.negotiationState.clientLineMode0 = command == -5;
                        break;
                    }
                    if (value == 31) {
                        this.negotiationState.clientResizeNotification = command == -5;
                        break;
                    }
                    this.negotiationState.onUnsupportedStateCommand(command == -5, value);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("No command handler implemented for " + TelnetProtocol.CODE_TO_NAME.get(command));
                }
            }
        }

        private int parseSubNegotiation(byte[] buffer, int position, int max) {
            int originalPosition = position;
            byte operation = buffer[position++];
            ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
            while (position < max) {
                byte read = buffer[position];
                if (read != -1) {
                    outputBuffer.write(read);
                } else {
                    if (position + 1 == max) {
                        throw new IllegalStateException("State error, unexpected end of buffer when reading subnegotiation");
                    }
                    if (buffer[++position] == -1) {
                        outputBuffer.write(-1);
                    } else if (buffer[position] == -16) {
                        this.parseSubNegotiation(operation, outputBuffer.toByteArray());
                        return ++position - originalPosition;
                    }
                }
                ++position;
            }
            throw new IllegalStateException("State error, unexpected end of buffer when reading subnegotiation, no IAC SE");
        }

        private void parseSubNegotiation(byte option, byte[] additionalData) {
            switch (option) {
                case 31: {
                    this.eventListener.onResize(TelnetTerminal.convertTwoBytesToInt2(additionalData[1], additionalData[0]), TelnetTerminal.convertTwoBytesToInt2(additionalData[3], additionalData[2]));
                    break;
                }
                case 34: {
                    break;
                }
                default: {
                    this.negotiationState.onUnsupportedSubnegotiation(option, additionalData);
                }
            }
        }
    }

    private static interface TelnetClientEventListener {
        public void onResize(int var1, int var2);

        public void requestReply(boolean var1, byte var2) throws IOException;
    }

    public static class NegotiationState {
        private boolean clientEcho = true;
        private boolean clientLineMode0 = false;
        private boolean clientResizeNotification = false;
        private boolean suppressGoAhead = true;
        private boolean extendedAscii = true;

        NegotiationState() {
        }

        public boolean isClientEcho() {
            return this.clientEcho;
        }

        public boolean isClientLineMode0() {
            return this.clientLineMode0;
        }

        public boolean isClientResizeNotification() {
            return this.clientResizeNotification;
        }

        public boolean isSuppressGoAhead() {
            return this.suppressGoAhead;
        }

        public boolean isExtendedAscii() {
            return this.extendedAscii;
        }

        private void onUnsupportedStateCommand(boolean enabling, byte value) {
            System.err.println("Unsupported operation: Client says it " + (enabling ? "will" : "won't") + " do " + TelnetProtocol.CODE_TO_NAME.get(value));
        }

        private void onUnsupportedRequestCommand(boolean askedToDo, byte value) {
            System.err.println("Unsupported request: Client asks us, " + (askedToDo ? "do" : "don't") + " " + TelnetProtocol.CODE_TO_NAME.get(value));
        }

        private void onUnsupportedSubnegotiation(byte option, byte[] additionalData) {
            System.err.println("Unsupported subnegotiation: Client send " + TelnetProtocol.CODE_TO_NAME.get(option) + " with extra data " + NegotiationState.toList(additionalData));
        }

        private static List<String> toList(byte[] array) {
            ArrayList<String> list = new ArrayList<String>(array.length);
            for (byte b : array) {
                list.add(String.format("%02X ", b));
            }
            return list;
        }
    }
}

