/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.DefaultKeyDecodingProfile;
import com.googlecode.lanterna.input.InputDecoder;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import com.googlecode.lanterna.terminal.virtual.DefaultVirtualTerminal;
import com.googlecode.lanterna.terminal.virtual.VirtualTerminal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class GraphicalTerminalImplementation
implements IOSafeTerminal {
    private final TerminalEmulatorDeviceConfiguration deviceConfiguration;
    private final TerminalEmulatorColorConfiguration colorConfiguration;
    private final DefaultVirtualTerminal virtualTerminal;
    private final BlockingQueue<KeyStroke> keyQueue;
    private final TerminalScrollController scrollController;
    private final DirtyCellsLookupTable dirtyCellsLookupTable;
    private final String enquiryString;
    private boolean cursorIsVisible;
    private boolean enableInput;
    private Timer blinkTimer;
    private boolean hasBlinkingText;
    private boolean blinkOn;
    private boolean bellOn;
    private boolean needFullRedraw;
    private TerminalPosition lastDrawnCursorPosition;
    private int lastBufferUpdateScrollPosition;
    private int lastComponentWidth;
    private int lastComponentHeight;
    private BufferedImage backbuffer;
    private BufferedImage copybuffer;
    private static final Set<Character> TYPED_KEYS_TO_IGNORE = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\b'), Character.valueOf('\u001b'), Character.valueOf('\u007f')));

    GraphicalTerminalImplementation(TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        if (initialTerminalSize == null) {
            initialTerminalSize = new TerminalSize(80, 24);
        }
        this.virtualTerminal = new DefaultVirtualTerminal(initialTerminalSize);
        this.keyQueue = new LinkedBlockingQueue<KeyStroke>();
        this.deviceConfiguration = deviceConfiguration;
        this.colorConfiguration = colorConfiguration;
        this.scrollController = scrollController;
        this.dirtyCellsLookupTable = new DirtyCellsLookupTable();
        this.cursorIsVisible = true;
        this.enableInput = false;
        this.enquiryString = "TerminalEmulator";
        this.lastDrawnCursorPosition = null;
        this.lastBufferUpdateScrollPosition = 0;
        this.lastComponentHeight = 0;
        this.lastComponentWidth = 0;
        this.backbuffer = null;
        this.copybuffer = null;
        this.blinkTimer = null;
        this.hasBlinkingText = false;
        this.blinkOn = true;
        this.needFullRedraw = false;
        this.virtualTerminal.setBacklogSize(deviceConfiguration.getLineBufferScrollbackSize());
    }

    abstract int getFontHeight();

    abstract int getFontWidth();

    abstract int getHeight();

    abstract int getWidth();

    abstract Font getFontForCharacter(TextCharacter var1);

    abstract boolean isTextAntiAliased();

    abstract void repaint();

    synchronized void onCreated() {
        this.startBlinkTimer();
        this.enableInput = true;
        this.keyQueue.clear();
    }

    synchronized void onDestroyed() {
        this.stopBlinkTimer();
        this.enableInput = false;
        this.keyQueue.add(new KeyStroke(KeyType.EOF));
    }

    synchronized void startBlinkTimer() {
        if (this.blinkTimer != null) {
            return;
        }
        this.blinkTimer = new Timer("LanternaTerminalBlinkTimer", true);
        this.blinkTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                GraphicalTerminalImplementation.this.blinkOn = !GraphicalTerminalImplementation.this.blinkOn;
                if (GraphicalTerminalImplementation.this.hasBlinkingText) {
                    GraphicalTerminalImplementation.this.repaint();
                }
            }
        }, this.deviceConfiguration.getBlinkLengthInMilliSeconds(), (long)this.deviceConfiguration.getBlinkLengthInMilliSeconds());
    }

    synchronized void stopBlinkTimer() {
        if (this.blinkTimer == null) {
            return;
        }
        this.blinkTimer.cancel();
        this.blinkTimer = null;
    }

    synchronized Dimension getPreferredSize() {
        return new Dimension(this.getFontWidth() * this.virtualTerminal.getTerminalSize().getColumns(), this.getFontHeight() * this.virtualTerminal.getTerminalSize().getRows());
    }

    synchronized void paintComponent(Graphics componentGraphics) {
        boolean needToUpdateBackBuffer;
        int width = this.getWidth();
        int height = this.getHeight();
        this.scrollController.updateModel(this.virtualTerminal.getBufferLineCount() * this.getFontHeight(), height);
        boolean bl = needToUpdateBackBuffer = this.lastBufferUpdateScrollPosition != this.scrollController.getScrollingOffset() || this.hasBlinkingText || this.needFullRedraw;
        if (width != this.lastComponentWidth || height != this.lastComponentHeight) {
            int columns = width / this.getFontWidth();
            int rows = height / this.getFontHeight();
            TerminalSize terminalSize = this.virtualTerminal.getTerminalSize().withColumns(columns).withRows(rows);
            this.virtualTerminal.setTerminalSize(terminalSize);
            needToUpdateBackBuffer = true;
        }
        if (needToUpdateBackBuffer) {
            this.updateBackBuffer(this.scrollController.getScrollingOffset());
        }
        this.ensureGraphicBufferHasRightSize();
        Rectangle clipBounds = componentGraphics.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        componentGraphics.drawImage(this.backbuffer, clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height, clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height, null);
        int leftoverWidth = this.getWidth() % this.getFontWidth();
        componentGraphics.setColor(Color.BLACK);
        if (leftoverWidth > 0) {
            componentGraphics.fillRect(this.getWidth() - leftoverWidth, 0, leftoverWidth, this.getHeight());
        }
        this.lastComponentWidth = width;
        this.lastComponentHeight = height;
        componentGraphics.dispose();
        this.notifyAll();
    }

    private synchronized void updateBackBuffer(final int scrollOffsetFromTopInPixels) {
        int row;
        Graphics2D graphics;
        int gap;
        final int fontWidth = this.getFontWidth();
        final int fontHeight = this.getFontHeight();
        final TerminalPosition cursorPosition = this.virtualTerminal.getCursorBufferPosition();
        final TerminalSize viewportSize = this.virtualTerminal.getTerminalSize();
        int firstVisibleRowIndex = scrollOffsetFromTopInPixels / fontHeight;
        int lastVisibleRowIndex = (scrollOffsetFromTopInPixels + this.getHeight()) / fontHeight;
        this.ensureGraphicBufferHasRightSize();
        final Graphics2D backbufferGraphics = this.backbuffer.createGraphics();
        if (this.isTextAntiAliased()) {
            backbufferGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            backbufferGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        final AtomicBoolean foundBlinkingCharacters = new AtomicBoolean(this.deviceConfiguration.isCursorBlinking());
        this.buildDirtyCellsLookupTable(firstVisibleRowIndex, lastVisibleRowIndex);
        if (this.lastBufferUpdateScrollPosition < scrollOffsetFromTopInPixels) {
            gap = scrollOffsetFromTopInPixels - this.lastBufferUpdateScrollPosition;
            if (gap / fontHeight < viewportSize.getRows()) {
                graphics = this.copybuffer.createGraphics();
                graphics.setClip(0, 0, this.getWidth(), this.getHeight() - gap);
                graphics.drawImage((Image)this.backbuffer, 0, -gap, null);
                graphics.dispose();
                backbufferGraphics.drawImage(this.copybuffer, 0, 0, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight(), null);
                if (!this.dirtyCellsLookupTable.isAllDirty()) {
                    int previousLastVisibleRowIndex;
                    for (row = previousLastVisibleRowIndex = (this.lastBufferUpdateScrollPosition + this.getHeight()) / fontHeight; row <= lastVisibleRowIndex; ++row) {
                        this.dirtyCellsLookupTable.setRowDirty(row);
                    }
                }
            } else {
                this.dirtyCellsLookupTable.setAllDirty();
            }
        } else if (this.lastBufferUpdateScrollPosition > scrollOffsetFromTopInPixels) {
            gap = this.lastBufferUpdateScrollPosition - scrollOffsetFromTopInPixels;
            if (gap / fontHeight < viewportSize.getRows()) {
                graphics = this.copybuffer.createGraphics();
                graphics.setClip(0, 0, this.getWidth(), this.getHeight() - gap);
                graphics.drawImage((Image)this.backbuffer, 0, 0, null);
                graphics.dispose();
                backbufferGraphics.drawImage(this.copybuffer, 0, gap, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight() - gap, null);
                if (!this.dirtyCellsLookupTable.isAllDirty()) {
                    int previousFirstVisibleRowIndex = this.lastBufferUpdateScrollPosition / fontHeight;
                    for (row = firstVisibleRowIndex; row <= previousFirstVisibleRowIndex; ++row) {
                        this.dirtyCellsLookupTable.setRowDirty(row);
                    }
                }
            } else {
                this.dirtyCellsLookupTable.setAllDirty();
            }
        }
        if (this.lastComponentWidth < this.getWidth() && !this.dirtyCellsLookupTable.isAllDirty()) {
            int previousLastVisibleColumnIndex;
            int lastVisibleColumnIndex = this.getWidth() / fontWidth;
            for (int column = previousLastVisibleColumnIndex = this.lastComponentWidth / fontWidth; column <= lastVisibleColumnIndex; ++column) {
                this.dirtyCellsLookupTable.setColumnDirty(column);
            }
        }
        if (this.lastComponentHeight < this.getHeight() && !this.dirtyCellsLookupTable.isAllDirty()) {
            int previousLastVisibleRowIndex;
            for (int row2 = previousLastVisibleRowIndex = (scrollOffsetFromTopInPixels + this.lastComponentHeight) / fontHeight; row2 <= lastVisibleRowIndex; ++row2) {
                this.dirtyCellsLookupTable.setRowDirty(row2);
            }
        }
        this.virtualTerminal.forEachLine(firstVisibleRowIndex, lastVisibleRowIndex, new VirtualTerminal.BufferWalker(){

            @Override
            public void onLine(int rowNumber, VirtualTerminal.BufferLine bufferLine) {
                for (int column = 0; column < viewportSize.getColumns(); ++column) {
                    boolean isBlinking;
                    TextCharacter textCharacter = bufferLine.getCharacterAt(column);
                    boolean atCursorLocation = cursorPosition.equals(column, rowNumber);
                    if (!atCursorLocation && cursorPosition.getColumn() == column + 1 && cursorPosition.getRow() == rowNumber && TerminalTextUtils.isCharCJK(textCharacter.getCharacter())) {
                        atCursorLocation = true;
                    }
                    if (isBlinking = textCharacter.getModifiers().contains((Object)SGR.BLINK)) {
                        foundBlinkingCharacters.set(true);
                    }
                    if (GraphicalTerminalImplementation.this.dirtyCellsLookupTable.isAllDirty() || GraphicalTerminalImplementation.this.dirtyCellsLookupTable.isDirty(rowNumber, column) || isBlinking) {
                        boolean drawCursor;
                        int characterWidth = fontWidth * (TerminalTextUtils.isCharCJK(textCharacter.getCharacter()) ? 2 : 1);
                        Color foregroundColor = GraphicalTerminalImplementation.this.deriveTrueForegroundColor(textCharacter, atCursorLocation);
                        Color backgroundColor = GraphicalTerminalImplementation.this.deriveTrueBackgroundColor(textCharacter, atCursorLocation);
                        boolean bl = drawCursor = atCursorLocation && (!GraphicalTerminalImplementation.this.deviceConfiguration.isCursorBlinking() || GraphicalTerminalImplementation.this.deviceConfiguration.isCursorBlinking() && GraphicalTerminalImplementation.this.blinkOn);
                        if (GraphicalTerminalImplementation.this.bellOn) {
                            Color temp = foregroundColor;
                            foregroundColor = backgroundColor;
                            backgroundColor = temp;
                        }
                        GraphicalTerminalImplementation.this.drawCharacter(backbufferGraphics, textCharacter, column, rowNumber, foregroundColor, backgroundColor, fontWidth, fontHeight, characterWidth, scrollOffsetFromTopInPixels, drawCursor);
                    }
                    if (!TerminalTextUtils.isCharCJK(textCharacter.getCharacter())) continue;
                    ++column;
                }
            }
        });
        backbufferGraphics.dispose();
        this.hasBlinkingText = foundBlinkingCharacters.get();
        this.lastDrawnCursorPosition = cursorPosition;
        this.lastBufferUpdateScrollPosition = scrollOffsetFromTopInPixels;
        this.needFullRedraw = false;
    }

    private void buildDirtyCellsLookupTable(int firstRowOffset, int lastRowOffset) {
        if (this.virtualTerminal.isWholeBufferDirtyThenReset() || this.needFullRedraw) {
            this.dirtyCellsLookupTable.setAllDirty();
            return;
        }
        TerminalSize viewportSize = this.virtualTerminal.getTerminalSize();
        TerminalPosition cursorPosition = this.virtualTerminal.getCursorBufferPosition();
        this.dirtyCellsLookupTable.resetAndInitialize(firstRowOffset, lastRowOffset, viewportSize.getColumns());
        this.dirtyCellsLookupTable.setDirty(cursorPosition);
        if (this.lastDrawnCursorPosition != null && !this.lastDrawnCursorPosition.equals(cursorPosition)) {
            if (this.virtualTerminal.getCharacter(this.lastDrawnCursorPosition).isDoubleWidth()) {
                this.dirtyCellsLookupTable.setDirty(this.lastDrawnCursorPosition.withRelativeColumn(1));
            }
            if (this.lastDrawnCursorPosition.getColumn() > 0 && this.virtualTerminal.getCharacter(this.lastDrawnCursorPosition.withRelativeColumn(-1)).isDoubleWidth()) {
                this.dirtyCellsLookupTable.setDirty(this.lastDrawnCursorPosition.withRelativeColumn(-1));
            }
            this.dirtyCellsLookupTable.setDirty(this.lastDrawnCursorPosition);
        }
        TreeSet<TerminalPosition> dirtyCells = this.virtualTerminal.getAndResetDirtyCells();
        for (TerminalPosition position : dirtyCells) {
            this.dirtyCellsLookupTable.setDirty(position);
        }
    }

    private void ensureGraphicBufferHasRightSize() {
        if (this.backbuffer == null) {
            this.backbuffer = new BufferedImage(this.getWidth() * 2, this.getHeight() * 2, 1);
            this.copybuffer = new BufferedImage(this.getWidth() * 2, this.getHeight() * 2, 1);
            Graphics2D graphics = this.backbuffer.createGraphics();
            graphics.setColor(this.colorConfiguration.toAWTColor(TextColor.ANSI.DEFAULT, false, false));
            graphics.fillRect(0, 0, this.getWidth() * 2, this.getHeight() * 2);
            graphics.dispose();
        }
        if (this.backbuffer.getWidth() < this.getWidth() || this.backbuffer.getWidth() > this.getWidth() * 4 || this.backbuffer.getHeight() < this.getHeight() || this.backbuffer.getHeight() > this.getHeight() * 4) {
            BufferedImage newBackbuffer = new BufferedImage(Math.max(this.getWidth(), 1) * 2, Math.max(this.getHeight(), 1) * 2, 1);
            Graphics2D graphics = newBackbuffer.createGraphics();
            graphics.fillRect(0, 0, newBackbuffer.getWidth(), newBackbuffer.getHeight());
            graphics.drawImage((Image)this.backbuffer, 0, 0, null);
            graphics.dispose();
            this.backbuffer = newBackbuffer;
            this.copybuffer = new BufferedImage(Math.max(this.getWidth(), 1) * 2, Math.max(this.getHeight(), 1) * 2, 1);
        }
    }

    private void drawCharacter(Graphics g, TextCharacter character, int columnIndex, int rowIndex, Color foregroundColor, Color backgroundColor, int fontWidth, int fontHeight, int characterWidth, int scrollingOffsetInPixels, boolean drawCursor) {
        int lineEndX;
        int lineStartY;
        int lineStartX;
        int x = columnIndex * fontWidth;
        int y = rowIndex * fontHeight - scrollingOffsetInPixels;
        g.setColor(backgroundColor);
        g.setClip(x, y, characterWidth, fontHeight);
        g.fillRect(x, y, characterWidth, fontHeight);
        g.setColor(foregroundColor);
        Font font = this.getFontForCharacter(character);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.drawString(Character.toString(character.getCharacter()), x, y + fontHeight - fontMetrics.getDescent() + 1);
        if (character.isCrossedOut()) {
            lineStartX = x;
            lineStartY = y + fontHeight / 2;
            lineEndX = lineStartX + characterWidth;
            g.drawLine(lineStartX, lineStartY, lineEndX, lineStartY);
        }
        if (character.isUnderlined()) {
            lineStartX = x;
            lineStartY = y + fontHeight - fontMetrics.getDescent() + 1;
            lineEndX = lineStartX + characterWidth;
            g.drawLine(lineStartX, lineStartY, lineEndX, lineStartY);
        }
        if (drawCursor) {
            if (this.deviceConfiguration.getCursorColor() == null) {
                g.setColor(foregroundColor);
            } else {
                g.setColor(this.colorConfiguration.toAWTColor(this.deviceConfiguration.getCursorColor(), false, false));
            }
            if (this.deviceConfiguration.getCursorStyle() == TerminalEmulatorDeviceConfiguration.CursorStyle.UNDER_BAR) {
                g.fillRect(x, y + fontHeight - 3, characterWidth, 2);
            } else if (this.deviceConfiguration.getCursorStyle() == TerminalEmulatorDeviceConfiguration.CursorStyle.VERTICAL_BAR) {
                g.fillRect(x, y + 1, 2, fontHeight - 2);
            }
        }
    }

    private Color deriveTrueForegroundColor(TextCharacter character, boolean atCursorLocation) {
        TextColor foregroundColor = character.getForegroundColor();
        TextColor backgroundColor = character.getBackgroundColor();
        boolean reverse = character.isReversed();
        boolean blink = character.isBlinking();
        if (this.cursorIsVisible && atCursorLocation && this.deviceConfiguration.getCursorStyle() == TerminalEmulatorDeviceConfiguration.CursorStyle.REVERSED && (!this.deviceConfiguration.isCursorBlinking() || !this.blinkOn)) {
            reverse = true;
        }
        if (!(!reverse || blink && this.blinkOn)) {
            return this.colorConfiguration.toAWTColor(backgroundColor, backgroundColor != TextColor.ANSI.DEFAULT, character.isBold());
        }
        if (!reverse && blink && this.blinkOn) {
            return this.colorConfiguration.toAWTColor(backgroundColor, false, character.isBold());
        }
        return this.colorConfiguration.toAWTColor(foregroundColor, true, character.isBold());
    }

    private Color deriveTrueBackgroundColor(TextCharacter character, boolean atCursorLocation) {
        TextColor foregroundColor = character.getForegroundColor();
        TextColor backgroundColor = character.getBackgroundColor();
        boolean reverse = character.isReversed();
        if (this.cursorIsVisible && atCursorLocation) {
            if (!(this.deviceConfiguration.getCursorStyle() != TerminalEmulatorDeviceConfiguration.CursorStyle.REVERSED || this.deviceConfiguration.isCursorBlinking() && this.blinkOn)) {
                reverse = true;
            } else if (this.deviceConfiguration.getCursorStyle() == TerminalEmulatorDeviceConfiguration.CursorStyle.FIXED_BACKGROUND) {
                backgroundColor = this.deviceConfiguration.getCursorColor();
            }
        }
        if (reverse) {
            return this.colorConfiguration.toAWTColor(foregroundColor, backgroundColor == TextColor.ANSI.DEFAULT, character.isBold());
        }
        return this.colorConfiguration.toAWTColor(backgroundColor, false, false);
    }

    void addInput(KeyStroke keyStroke) {
        this.keyQueue.add(keyStroke);
    }

    @Override
    public KeyStroke pollInput() {
        if (!this.enableInput) {
            return new KeyStroke(KeyType.EOF);
        }
        return (KeyStroke)this.keyQueue.poll();
    }

    @Override
    public KeyStroke readInput() {
        BlockingQueue<KeyStroke> blockingQueue = this.keyQueue;
        synchronized (blockingQueue) {
            if (!this.enableInput) {
                return new KeyStroke(KeyType.EOF);
            }
            try {
                return this.keyQueue.take();
            }
            catch (InterruptedException ignore) {
                throw new RuntimeException("Blocking input was interrupted");
            }
        }
    }

    @Override
    public synchronized void enterPrivateMode() {
        this.virtualTerminal.enterPrivateMode();
        this.clearBackBuffer();
        this.flush();
    }

    @Override
    public synchronized void exitPrivateMode() {
        this.virtualTerminal.exitPrivateMode();
        this.clearBackBuffer();
        this.flush();
    }

    @Override
    public synchronized void clearScreen() {
        this.virtualTerminal.clearScreen();
        this.clearBackBuffer();
    }

    private void clearBackBuffer() {
        if (this.backbuffer != null) {
            Graphics2D graphics = this.backbuffer.createGraphics();
            Color backgroundColor = this.colorConfiguration.toAWTColor(TextColor.ANSI.DEFAULT, false, false);
            graphics.setColor(backgroundColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.dispose();
        }
    }

    @Override
    public synchronized void setCursorPosition(int x, int y) {
        this.setCursorPosition(new TerminalPosition(x, y));
    }

    @Override
    public synchronized void setCursorPosition(TerminalPosition position) {
        if (position.getColumn() < 0) {
            position = position.withColumn(0);
        }
        if (position.getRow() < 0) {
            position = position.withRow(0);
        }
        this.virtualTerminal.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.virtualTerminal.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.cursorIsVisible = visible;
    }

    @Override
    public synchronized void putCharacter(char c) {
        this.virtualTerminal.putCharacter(c);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.virtualTerminal.newTextGraphics();
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.virtualTerminal.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.virtualTerminal.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.virtualTerminal.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.virtualTerminal.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.virtualTerminal.setBackgroundColor(color);
    }

    @Override
    public synchronized TerminalSize getTerminalSize() {
        return this.virtualTerminal.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutUnit) {
        return this.enquiryString.getBytes();
    }

    @Override
    public void bell() {
        if (this.bellOn) {
            return;
        }
        this.bellOn = true;
        this.needFullRedraw = true;
        this.updateBackBuffer(this.scrollController.getScrollingOffset());
        this.repaint();
        new Thread("BellSilencer"){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                GraphicalTerminalImplementation.this.bellOn = false;
                GraphicalTerminalImplementation.this.needFullRedraw = true;
                GraphicalTerminalImplementation.this.updateBackBuffer(GraphicalTerminalImplementation.this.scrollController.getScrollingOffset());
                GraphicalTerminalImplementation.this.repaint();
            }
        }.start();
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public synchronized void flush() {
        this.updateBackBuffer(this.scrollController.getScrollingOffset());
        this.repaint();
    }

    @Override
    public void close() {
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.virtualTerminal.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.virtualTerminal.removeResizeListener(listener);
    }

    private void pasteClipboardContent() {
        try {
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (systemClipboard != null) {
                this.injectStringAsKeyStrokes((String)systemClipboard.getData(DataFlavor.stringFlavor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void pasteSelectionContent() {
        try {
            Clipboard systemSelection = Toolkit.getDefaultToolkit().getSystemSelection();
            if (systemSelection != null) {
                this.injectStringAsKeyStrokes((String)systemSelection.getData(DataFlavor.stringFlavor));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void injectStringAsKeyStrokes(String string) {
        StringReader stringReader = new StringReader(string);
        InputDecoder inputDecoder = new InputDecoder(stringReader);
        inputDecoder.addProfile(new DefaultKeyDecodingProfile());
        try {
            KeyStroke keyStroke = inputDecoder.getNextCharacter(false);
            while (keyStroke != null && keyStroke.getKeyType() != KeyType.EOF) {
                this.keyQueue.add(keyStroke);
                keyStroke = inputDecoder.getNextCharacter(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class DirtyCellsLookupTable {
        private final List<BitSet> table = new ArrayList<BitSet>();
        private int firstRowIndex = -1;
        private boolean allDirty = false;

        DirtyCellsLookupTable() {
        }

        void resetAndInitialize(int firstRowIndex, int lastRowIndex, int columns) {
            this.firstRowIndex = firstRowIndex;
            this.allDirty = false;
            int rows = lastRowIndex - firstRowIndex + 1;
            while (this.table.size() < rows) {
                this.table.add(new BitSet(columns));
            }
            while (this.table.size() > rows) {
                this.table.remove(this.table.size() - 1);
            }
            for (int index = 0; index < this.table.size(); ++index) {
                if (this.table.get(index).size() != columns) {
                    this.table.set(index, new BitSet(columns));
                    continue;
                }
                this.table.get(index).clear();
            }
        }

        void setAllDirty() {
            this.allDirty = true;
        }

        boolean isAllDirty() {
            return this.allDirty;
        }

        void setDirty(TerminalPosition position) {
            if (position.getRow() < this.firstRowIndex || position.getRow() >= this.firstRowIndex + this.table.size()) {
                return;
            }
            BitSet tableRow = this.table.get(position.getRow() - this.firstRowIndex);
            if (position.getColumn() < tableRow.size()) {
                tableRow.set(position.getColumn());
            }
        }

        void setRowDirty(int rowNumber) {
            BitSet row = this.table.get(rowNumber - this.firstRowIndex);
            row.set(0, row.size());
        }

        void setColumnDirty(int column) {
            for (BitSet row : this.table) {
                if (column >= row.size()) continue;
                row.set(column);
            }
        }

        boolean isDirty(int row, int column) {
            if (row < this.firstRowIndex || row >= this.firstRowIndex + this.table.size()) {
                return false;
            }
            BitSet tableRow = this.table.get(row - this.firstRowIndex);
            if (column < tableRow.size()) {
                return tableRow.get(column);
            }
            return false;
        }
    }

    protected class TerminalMouseListener
    extends MouseAdapter {
        protected TerminalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseInfo.getNumberOfButtons() > 2 && e.getButton() == 2 && GraphicalTerminalImplementation.this.deviceConfiguration.isClipboardAvailable()) {
                GraphicalTerminalImplementation.this.pasteSelectionContent();
            }
        }
    }

    protected class TerminalInputListener
    extends KeyAdapter {
        protected TerminalInputListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            boolean shiftDown;
            char character = e.getKeyChar();
            boolean altDown = (e.getModifiersEx() & 0x200) != 0;
            boolean ctrlDown = (e.getModifiersEx() & 0x80) != 0;
            boolean bl = shiftDown = (e.getModifiersEx() & 0x40) != 0;
            if (!TYPED_KEYS_TO_IGNORE.contains(Character.valueOf(character))) {
                if (ctrlDown && character > '\u0000' && character < '\u001a') {
                    character = (char)(96 + character);
                    if (shiftDown) {
                        character = Character.toUpperCase(character);
                    }
                }
                if (!altDown && ctrlDown && shiftDown && character == 'V' && GraphicalTerminalImplementation.this.deviceConfiguration.isClipboardAvailable()) {
                    GraphicalTerminalImplementation.this.pasteClipboardContent();
                } else {
                    GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(Character.valueOf(character), ctrlDown, altDown, shiftDown));
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            boolean shiftDown;
            boolean altDown = (e.getModifiersEx() & 0x200) != 0;
            boolean ctrlDown = (e.getModifiersEx() & 0x80) != 0;
            boolean bl = shiftDown = (e.getModifiersEx() & 0x40) != 0;
            if (e.getKeyCode() == 10) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Enter, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 27) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Escape, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 8) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Backspace, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 37) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.ArrowLeft, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 39) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.ArrowRight, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 38) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.ArrowUp, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 40) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.ArrowDown, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 155) {
                if (!altDown && !ctrlDown && shiftDown && GraphicalTerminalImplementation.this.deviceConfiguration.isClipboardAvailable()) {
                    GraphicalTerminalImplementation.this.pasteClipboardContent();
                } else {
                    GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Insert, ctrlDown, altDown, shiftDown));
                }
            } else if (e.getKeyCode() == 127) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Delete, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 36) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Home, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 35) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.End, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 33) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.PageUp, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 34) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.PageDown, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 112) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F1, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 113) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F2, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 114) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F3, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 115) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F4, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 116) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F5, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 117) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F6, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 118) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F7, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 119) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F8, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 120) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F9, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 121) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F10, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 122) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F11, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 123) {
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.F12, ctrlDown, altDown, shiftDown));
            } else if (e.getKeyCode() == 9) {
                if (e.isShiftDown()) {
                    GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.ReverseTab, ctrlDown, altDown, shiftDown));
                } else {
                    GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(KeyType.Tab, ctrlDown, altDown, shiftDown));
                }
            } else if (altDown && ctrlDown && e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                char character = (char)e.getKeyCode();
                if (!shiftDown) {
                    character = Character.toLowerCase(character);
                }
                GraphicalTerminalImplementation.this.keyQueue.add(new KeyStroke(Character.valueOf(character), ctrlDown, altDown, shiftDown));
            }
        }
    }
}

