/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.time.Duration;
import net.sf.ehcache.config.CacheConfiguration;

public enum CacheType {
    Persistent(Duration.ofDays(180L), true),
    Monthly(Duration.ofDays(60L), true),
    Weekly(Duration.ofDays(12L), true),
    Daily(Duration.ofHours(18L), true),
    Ephemeral(Duration.ofDays(1L), false);

    final long timeToLiveSeconds;
    final boolean diskPersistent;

    private CacheType(Duration timeToLive, boolean diskPersistent) {
        this.timeToLiveSeconds = timeToLive.getSeconds();
        this.diskPersistent = diskPersistent;
    }

    CacheConfiguration getConfiguration(String name) {
        return new CacheConfiguration().name(name).maxEntriesLocalHeap(this.diskPersistent ? 200 : 20000).maxEntriesLocalDisk(0).eternal(false).timeToLiveSeconds(this.timeToLiveSeconds).timeToIdleSeconds(this.timeToLiveSeconds).overflowToDisk(this.diskPersistent).diskPersistent(this.diskPersistent);
    }
}

