/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import net.filebot.Logging;

@XmlRootElement(name="history")
public class History {
    @XmlElement(name="sequence")
    private List<Sequence> sequences;

    public History() {
        this.sequences = new ArrayList<Sequence>();
    }

    public History(Collection<Sequence> sequences) {
        this.sequences = new ArrayList<Sequence>(sequences);
    }

    public List<Sequence> sequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public void add(Collection<Element> elements) {
        Sequence sequence = new Sequence();
        sequence.date = new Date();
        sequence.elements = new ArrayList<Element>(elements);
        this.add(sequence);
    }

    public void add(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public void addAll(Collection<Sequence> sequences) {
        this.sequences.addAll(sequences);
    }

    public void merge(History history) {
        for (Sequence sequence : history.sequences()) {
            if (this.sequences.contains(sequence)) continue;
            this.add(sequence);
        }
    }

    public int totalSize() {
        int i = 0;
        for (Sequence it : this.sequences()) {
            i += it.elements.size();
        }
        return i;
    }

    public void clear() {
        this.sequences.clear();
    }

    public boolean equals(Object obj) {
        if (obj instanceof History) {
            History other = (History)obj;
            return this.sequences.equals(other.sequences);
        }
        return false;
    }

    public int hashCode() {
        return this.sequences.hashCode();
    }

    public Map<File, File> getRenameMap() {
        LinkedHashMap<File, File> map = new LinkedHashMap<File, File>();
        for (Sequence seq : this.sequences()) {
            for (Element elem : seq.elements()) {
                File to = new File(elem.to());
                if (!to.isAbsolute()) {
                    to = new File(elem.dir(), elem.to());
                }
                File from = new File(elem.dir(), elem.from());
                map.put(from, to);
            }
        }
        return map;
    }

    public static void exportHistory(History history, OutputStream output) {
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{History.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)history, output);
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to write history", e);
        }
    }

    public static History importHistory(InputStream stream) {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{History.class}).createUnmarshaller();
            return (History)unmarshaller.unmarshal(stream);
        }
        catch (Exception e) {
            Logging.debug.log(Level.SEVERE, "Failed to read history", e);
            return new History();
        }
    }

    public static class Element {
        @XmlAttribute(name="dir", required=true)
        private File dir;
        @XmlAttribute(name="from", required=true)
        private String from;
        @XmlAttribute(name="to", required=true)
        private String to;

        public Element() {
        }

        public Element(String from, String to, File dir) {
            this.from = from;
            this.to = to;
            this.dir = dir;
        }

        public File dir() {
            return this.dir;
        }

        public String from() {
            return this.from;
        }

        public String to() {
            return this.to;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Element) {
                Element element = (Element)obj;
                return this.to.equals(element.to) && this.from.equals(element.from) && this.dir.getPath().equals(element.dir.getPath());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.to, this.from, this.dir);
        }
    }

    public static class Sequence {
        @XmlAttribute(name="date", required=true)
        private Date date;
        @XmlElement(name="rename", required=true)
        private List<Element> elements;

        private Sequence() {
        }

        public Date date() {
            return this.date;
        }

        public List<Element> elements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.elements);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Sequence) {
                Sequence other = (Sequence)obj;
                return this.date.equals(other.date) && this.elements.equals(other.elements);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.elements, this.date);
        }
    }
}

