/*
 * Decompiled with CFR 0.152.
 */
package net.filebot;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.similarity.Normalization;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;

public class UserFiles {
    private static FileChooser defaultFileChooser = Settings.getPreferredFileChooser();
    private static final String PREF_KEY_PREFIX = "dialog.";
    private static final String KEY_OPEN_FILE = "open.file";
    private static final String KEY_OPEN_FOLDER = "open.folder";
    private static final String KEY_SAVE = "save.file";

    public static void trash(File file) throws IOException {
        if (Desktop.getDesktop().isSupported(Desktop.Action.MOVE_TO_TRASH)) {
            try {
                if (Desktop.getDesktop().moveToTrash(file)) {
                    return;
                }
                Logging.debug.log(Level.WARNING, Logging.message("Failed to move file to trash", file));
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e::toString);
            }
        }
        if (file.exists()) {
            FileUtilities.delete(file);
        }
    }

    public static void revealFiles(Collection<File> files) {
        if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
            files.stream().collect(Collectors.groupingBy(File::getParentFile, LinkedHashMap::new, Collectors.toList())).forEach((parent, children) -> {
                try {
                    Desktop.getDesktop().browseFileDirectory((File)children.get(children.size() - 1));
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e::toString);
                }
            });
            return;
        }
        files.stream().map(it -> it.getParentFile()).distinct().forEach(it -> {
            try {
                Desktop.getDesktop().open((File)it);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e::toString);
            }
        });
    }

    public static void setDefaultFileChooser(FileChooser fileChooser) {
        defaultFileChooser = fileChooser;
    }

    public static List<File> showLoadDialogSelectFiles(boolean folderMode, boolean multiSelection, File defaultFile, FileUtilities.ExtensionFileFilter filter, String title, ActionEvent evt) {
        String defaultFileKey = folderMode && filter == null || !folderMode || filter == null || !SwingUI.isShiftOrAltDown(evt) ? KEY_OPEN_FOLDER : KEY_OPEN_FILE;
        List<File> files = defaultFileChooser.showLoadDialogSelectFiles(defaultFileKey == KEY_OPEN_FOLDER, multiSelection, UserFiles.getFileChooserDefaultFile(defaultFileKey, defaultFile), filter, title, evt);
        if (files.size() > 0) {
            UserFiles.setFileChooserDefaultFile(defaultFileKey, files.get(0));
        }
        return files;
    }

    public static File showSaveDialogSelectFile(boolean folderMode, File defaultFile, String title, ActionEvent evt) {
        File file = defaultFileChooser.showSaveDialogSelectFile(folderMode, UserFiles.getFileChooserDefaultFile(KEY_SAVE, defaultFile), title, evt);
        if (file != null) {
            UserFiles.setFileChooserDefaultFile(KEY_SAVE, file);
        }
        return file;
    }

    public static File showOpenDialogSelectFolder(File defaultFile, String title, ActionEvent evt) {
        List<File> folder = defaultFileChooser.showLoadDialogSelectFiles(true, false, defaultFile, null, title, evt);
        return folder.size() > 0 ? folder.get(0) : null;
    }

    protected static File getFileChooserDefaultFile(String key, File userValue) {
        if (userValue != null && userValue.getParentFile() != null) {
            return userValue;
        }
        String path = Settings.forPackage(UserFiles.class).get(PREF_KEY_PREFIX + key);
        if (path == null || path.isEmpty()) {
            return userValue;
        }
        if (userValue != null && userValue.getParentFile() == null) {
            return new File(new File(path).getParentFile(), userValue.getName());
        }
        return new File(path);
    }

    protected static void setFileChooserDefaultFile(String name, File file) {
        Settings.forPackage(UserFiles.class).put(PREF_KEY_PREFIX + name, file.getPath());
    }

    public static enum FileChooser {
        Swing{

            @Override
            public List<File> showLoadDialogSelectFiles(boolean folderMode, boolean multiSelection, File defaultFile, FileUtilities.ExtensionFileFilter filter, String title, ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(title);
                chooser.setMultiSelectionEnabled(multiSelection);
                chooser.setFileSelectionMode(folderMode && filter == null ? 1 : 2);
                if (defaultFile != null) {
                    if (defaultFile.isFile()) {
                        chooser.setSelectedFile(defaultFile);
                    } else if (defaultFile.getParentFile() != null && defaultFile.getParentFile().isDirectory()) {
                        chooser.setCurrentDirectory(defaultFile.getParentFile());
                    }
                }
                if (filter != null && !filter.acceptAny()) {
                    chooser.setFileFilter(new FileNameExtensionFilter(Normalization.truncateText(filter.toString(), 80), filter.extensions()));
                }
                if (chooser.showOpenDialog(SwingUI.getWindow(evt.getSource())) == 0) {
                    if (chooser.getSelectedFiles().length > 0) {
                        return Arrays.asList(chooser.getSelectedFiles());
                    }
                    if (chooser.getSelectedFile() != null) {
                        return Arrays.asList(chooser.getSelectedFile());
                    }
                }
                return Arrays.asList(new File[0]);
            }

            @Override
            public File showSaveDialogSelectFile(boolean folderMode, File defaultFile, String title, ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(title);
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(folderMode ? 1 : 2);
                chooser.setSelectedFile(defaultFile);
                if (chooser.showSaveDialog(SwingUI.getWindow(evt.getSource())) != 0) {
                    return null;
                }
                return chooser.getSelectedFile();
            }
        }
        ,
        AWT{

            @Override
            public List<File> showLoadDialogSelectFiles(boolean folderMode, boolean multiSelection, File defaultFile, FileUtilities.ExtensionFileFilter filter, String title, ActionEvent evt) {
                FileDialog fileDialog = this.createFileDialog(evt, title, 0, folderMode);
                fileDialog.setTitle(title);
                fileDialog.setMultipleMode(multiSelection);
                if (defaultFile != null) {
                    if (folderMode && defaultFile.isDirectory()) {
                        fileDialog.setDirectory(defaultFile.getPath());
                    } else if (defaultFile.getParentFile() != null && defaultFile.getParentFile().isDirectory()) {
                        fileDialog.setDirectory(defaultFile.getParentFile().getPath());
                        fileDialog.setFile(defaultFile.getName());
                    }
                }
                if (filter != null) {
                    fileDialog.setFilenameFilter(filter);
                }
                fileDialog.setVisible(true);
                return Arrays.asList(fileDialog.getFiles());
            }

            @Override
            public File showSaveDialogSelectFile(boolean folderMode, File defaultFile, String title, ActionEvent evt) {
                FileDialog fileDialog = this.createFileDialog(evt, title, 1, folderMode);
                fileDialog.setTitle(title);
                fileDialog.setMultipleMode(false);
                if (defaultFile != null) {
                    if (defaultFile.getParentFile() != null && defaultFile.getParentFile().isDirectory()) {
                        fileDialog.setDirectory(defaultFile.getParentFile().getPath());
                    }
                    fileDialog.setFile(defaultFile.getName());
                }
                fileDialog.setVisible(true);
                File[] files = fileDialog.getFiles();
                return files.length > 0 ? files[0] : null;
            }

            public FileDialog createFileDialog(ActionEvent evt, String title, int mode, boolean fileDialogForDirectories) {
                System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(fileDialogForDirectories));
                if (evt.getSource() instanceof Frame) {
                    return new FileDialog((Frame)evt.getSource(), title, mode);
                }
                if (evt.getSource() instanceof Dialog) {
                    return new FileDialog((Dialog)evt.getSource(), title, mode);
                }
                Frame[] frames = Frame.getFrames();
                return new FileDialog(frames.length > 0 ? frames[0] : null, title, mode);
            }
        }
        ,
        COCOA{

            @Override
            public List<File> showLoadDialogSelectFiles(boolean folderMode, boolean multiSelection, File defaultFile, FileUtilities.ExtensionFileFilter filter, String title, ActionEvent evt) {
                if (folderMode && filter != null) {
                    return MacAppUtilities.NSOpenPanel_openPanel_runModal(title, true, true, true, filter.acceptAny() ? null : filter.extensions());
                }
                return AWT.showLoadDialogSelectFiles(folderMode, multiSelection, defaultFile, filter, title, evt);
            }

            @Override
            public File showSaveDialogSelectFile(boolean folderMode, File defaultFile, String title, ActionEvent evt) {
                return AWT.showSaveDialogSelectFile(folderMode, defaultFile, title, evt);
            }
        }
        ,
        JavaFX{

            @Override
            public List<File> showLoadDialogSelectFiles(final boolean folderMode, final boolean multiSelection, final File defaultFile, final FileUtilities.ExtensionFileFilter filter, final String title, ActionEvent evt) {
                return this.runAndWait(new Callable<List<File>>(){

                    @Override
                    public List<File> call() throws Exception {
                        if (folderMode) {
                            File file;
                            DirectoryChooser directoryChooser = new DirectoryChooser();
                            directoryChooser.setTitle(title);
                            if (defaultFile != null && defaultFile.isDirectory()) {
                                directoryChooser.setInitialDirectory(defaultFile);
                            }
                            if ((file = directoryChooser.showDialog(null)) != null) {
                                return Collections.singletonList(file);
                            }
                            return Collections.emptyList();
                        }
                        javafx.stage.FileChooser fileChooser = new javafx.stage.FileChooser();
                        fileChooser.setTitle(title);
                        if (filter != null && !filter.acceptAny()) {
                            String[] globFilter = filter.extensions();
                            for (int i = 0; i < globFilter.length; ++i) {
                                globFilter[i] = "*." + globFilter[i];
                            }
                            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(filter.toString(), globFilter));
                        }
                        if (defaultFile != null && defaultFile.getParentFile() != null && defaultFile.getParentFile().isDirectory()) {
                            fileChooser.setInitialDirectory(defaultFile.getParentFile());
                            fileChooser.setInitialFileName(defaultFile.getName());
                        }
                        if (multiSelection) {
                            List files = fileChooser.showOpenMultipleDialog(null);
                            if (files != null) {
                                return files;
                            }
                        } else {
                            File file = fileChooser.showOpenDialog(null);
                            if (file != null) {
                                return Collections.singletonList(file);
                            }
                        }
                        return Collections.emptyList();
                    }
                });
            }

            @Override
            public File showSaveDialogSelectFile(boolean folderMode, final File defaultFile, final String title, ActionEvent evt) {
                return this.runAndWait(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        javafx.stage.FileChooser fileChooser = new javafx.stage.FileChooser();
                        fileChooser.setTitle(title);
                        if (defaultFile != null) {
                            if (defaultFile.getParentFile() != null && defaultFile.getParentFile().isDirectory()) {
                                fileChooser.setInitialDirectory(defaultFile.getParentFile());
                            }
                            fileChooser.setInitialFileName(defaultFile.getName());
                        }
                        return fileChooser.showSaveDialog(null);
                    }
                });
            }

            public <T> T runAndWait(Callable<T> c) {
                try {
                    FutureTask<T> task = new FutureTask<T>(c);
                    SwingUI.invokeJavaFX(task);
                    return task.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };


        public abstract List<File> showLoadDialogSelectFiles(boolean var1, boolean var2, File var3, FileUtilities.ExtensionFileFilter var4, String var5, ActionEvent var6);

        public abstract File showSaveDialogSelectFile(boolean var1, File var2, String var3, ActionEvent var4);
    }
}

