/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.filebot.archive.ArchiveExtractor;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;

public class ApacheVFS
implements ArchiveExtractor,
Closeable {
    private static final FileSelector ALL_FILES = new AllFileSelector();
    private final FileSystemManager fsm;
    private final FileObject archive;

    public ApacheVFS(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.fsm = VFS.getManager();
        this.archive = this.fsm.createFileSystem(this.fsm.toFileObject(file));
    }

    @Override
    public List<FileInfo> listFiles() throws Exception {
        ArrayList<FileInfo> paths = new ArrayList<FileInfo>();
        for (FileObject it : this.archive.findFiles(ALL_FILES)) {
            if (it.getType() != FileType.FILE) continue;
            paths.add(new SimpleFileInfo(it.getName().getPathDecoded().substring(1), it.getContent().getSize()));
        }
        return paths;
    }

    @Override
    public void extract(File outputDir) throws Exception {
        this.extract(outputDir, null);
    }

    @Override
    public void extract(File outputDir, FileFilter filter) throws Exception {
        this.fsm.toFileObject(outputDir).copyFrom(this.archive, filter == null ? ALL_FILES : new FileFilterSelector(filter));
    }

    @Override
    public void close() throws IOException {
        this.archive.close();
    }

    private static class FileFilterSelector
    implements FileSelector {
        private final FileFilter filter;

        public FileFilterSelector(FileFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean traverseDescendents(FileSelectInfo it) throws Exception {
            return true;
        }

        @Override
        public boolean includeFile(FileSelectInfo it) throws Exception {
            return this.filter.accept(new File(it.getFile().getName().getPathDecoded().substring(1)));
        }
    }
}

