/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.filebot.archive.ExtractOutProvider;
import net.filebot.vfs.FileInfo;

public class FileMapper
implements ExtractOutProvider {
    private File outputDir;
    private boolean flatten;

    public FileMapper(File outputDir) {
        this(outputDir, false);
    }

    public FileMapper(File outputDir, boolean flatten) {
        this.outputDir = outputDir;
        this.flatten = flatten;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getOutputFile(File entry) {
        return new File(this.outputDir, this.flatten ? entry.getName() : entry.getPath());
    }

    @Override
    public OutputStream getStream(File entry) throws IOException {
        File outputFile = this.getOutputFile(entry);
        File outputFolder = outputFile.getParentFile();
        if (!outputFolder.isDirectory() && !outputFolder.mkdirs()) {
            throw new IOException("Failed to create folder: " + outputFolder);
        }
        return new FileOutputStream(outputFile);
    }

    public FileFilter newPathFilter(Collection<FileInfo> selection) {
        return this.newPathFilter(selection.stream().map(FileInfo::getPath).collect(Collectors.toSet()));
    }

    public FileFilter newPathFilter(Set<String> selection) {
        return f -> selection.contains(this.getOutputFile(f).getPath());
    }
}

