/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.filebot.archive.Archive;
import net.filebot.archive.ArchiveExtractor;
import net.filebot.archive.ArchiveOpenVolumeCallback;
import net.filebot.archive.ExtractCallback;
import net.filebot.archive.ExtractOutProvider;
import net.filebot.archive.FileMapper;
import net.filebot.archive.SevenZipLoader;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.VolumedArchiveInStream;

public class SevenZipNativeBindings
implements ArchiveExtractor,
Closeable {
    private IInArchive inArchive;
    private ArchiveOpenVolumeCallback openVolume;

    public SevenZipNativeBindings(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        this.openVolume = new ArchiveOpenVolumeCallback();
        this.inArchive = !Archive.hasMultiPartIndex(file) ? SevenZipLoader.open(this.openVolume.getStream(file.getAbsolutePath()), this.openVolume) : SevenZipLoader.open(new VolumedArchiveInStream(file.getAbsolutePath(), this.openVolume), null);
    }

    public int itemCount() throws SevenZipException {
        return this.inArchive.getNumberOfItems();
    }

    public Map<PropID, Object> getItem(int index) throws SevenZipException {
        EnumMap<PropID, Object> item = new EnumMap<PropID, Object>(PropID.class);
        for (PropID prop : PropID.values()) {
            Object value = this.inArchive.getProperty(index, prop);
            if (value == null) continue;
            item.put(prop, value);
        }
        return item;
    }

    @Override
    public List<FileInfo> listFiles() throws SevenZipException {
        ArrayList<FileInfo> paths = new ArrayList<FileInfo>();
        for (int i = 0; i < this.inArchive.getNumberOfItems(); ++i) {
            boolean isFolder = (Boolean)this.inArchive.getProperty(i, PropID.IS_FOLDER);
            if (isFolder) continue;
            String path = (String)this.inArchive.getProperty(i, PropID.PATH);
            Long length = (Long)this.inArchive.getProperty(i, PropID.SIZE);
            if (path == null) continue;
            paths.add(new SimpleFileInfo(path, length != null ? length : -1L));
        }
        return paths;
    }

    @Override
    public void extract(File outputDir) throws Exception {
        this.extract(new FileMapper(outputDir));
    }

    @Override
    public void extract(File outputDir, FileFilter filter) throws Exception {
        this.extract(new FileMapper(outputDir), filter);
    }

    public void extract(ExtractOutProvider outputMapper) throws SevenZipException {
        this.inArchive.extract(null, false, new ExtractCallback(this.inArchive, outputMapper));
    }

    public void extract(ExtractOutProvider outputMapper, FileFilter filter) throws SevenZipException {
        ArrayList<Integer> selection = new ArrayList<Integer>();
        for (int i = 0; i < this.inArchive.getNumberOfItems(); ++i) {
            String path;
            boolean isFolder = (Boolean)this.inArchive.getProperty(i, PropID.IS_FOLDER);
            if (isFolder || (path = (String)this.inArchive.getProperty(i, PropID.PATH)) == null || !filter.accept(new File(path))) continue;
            selection.add(i);
        }
        int[] indices = new int[selection.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)selection.get(i);
        }
        this.inArchive.extract(indices, false, new ExtractCallback(this.inArchive, outputMapper));
    }

    @Override
    public void close() throws IOException {
        try {
            this.inArchive.close();
        }
        catch (SevenZipException e) {
            throw new IOException(e);
        }
        finally {
            this.openVolume.close();
        }
    }
}

