/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.script.SimpleBindings;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.cli.ArgumentBean;
import net.filebot.cli.CmdlineException;
import net.filebot.cli.CmdlineInterface;
import net.filebot.cli.CmdlineOperations;
import net.filebot.cli.CmdlineOperationsTextUI;
import net.filebot.cli.ExecCommand;
import net.filebot.cli.ScriptDeath;
import net.filebot.cli.ScriptShell;
import net.filebot.cli.ScriptSource;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;

public class ArgumentProcessor {
    public int run(ArgumentBean args) {
        try {
            CmdlineOperations cli;
            CmdlineOperations cmdlineOperations = cli = args.isInteractive() ? new CmdlineOperationsTextUI() : new CmdlineOperations();
            if (args.script == null) {
                return this.runCommand(cli, args);
            }
            this.runScript(cli, args);
            Logging.log.finest("Done \u30fe(\uff20\u2312\u30fc\u2312\uff20)\u30ce");
            return 0;
        }
        catch (Throwable e) {
            if (ExceptionUtilities.findCause(e, CmdlineException.class) != null) {
                Logging.log.log(Level.WARNING, ExceptionUtilities.findCause(e, CmdlineException.class).getMessage());
            } else if (ExceptionUtilities.findCause(e, ScriptDeath.class) != null) {
                Logging.log.log(Level.WARNING, ExceptionUtilities.findCause(e, ScriptDeath.class).getMessage());
            } else {
                Logging.log.log(Level.SEVERE, e.getMessage(), e);
            }
            Logging.log.finest("Failure (\u00b0_\u00b0)");
            return 1;
        }
    }

    public int runCommand(CmdlineInterface cli, ArgumentBean args) throws Exception {
        if (args.getSubtitles && args.recursive) {
            throw new CmdlineException("`filebot -get-subtitles -r` has been disabled due to abuse. Please see http://bit.ly/suball for details.");
        }
        if (args.list) {
            if (args.rename) {
                return cli.rename(args.getEpisodeListProvider(), args.getSearchQuery(), args.getExpressionFileFormat(), args.getExpressionFilter(), args.getSortOrder(), args.getLanguage().getLocale(), args.isStrict(), args.getFiles(true), args.getRenameAction(), args.getConflictAction(), args.getOutputPath(), args.getExecCommand()).isEmpty() ? 1 : 0;
            }
            return this.print(cli.fetchEpisodeList(args.getEpisodeListProvider(), args.getSearchQuery(), args.getExpressionFormat(), args.getExpressionFilter(), args.getSortOrder(), args.getLanguage().getLocale(), args.isStrict()));
        }
        if (args.mediaInfo) {
            ExecCommand exec = args.getExecCommand();
            if (exec != null) {
                return cli.execute(args.getFiles(true), args.getFileFilter(), exec) ? 0 : 1;
            }
            return this.print(cli.getMediaInfo(args.getFiles(true), args.getFileFilter(), args.getExpressionFormat()));
        }
        if (args.revert) {
            return cli.revert(args.getFiles(false), args.getFileFilter(), args.getRenameAction()).isEmpty() ? 1 : 0;
        }
        LinkedHashSet<File> files = new LinkedHashSet<File>(args.getFiles(true));
        if (args.extract) {
            files.addAll(cli.extract(files, args.getOutputPath(), args.getConflictAction(), null, args.isStrict()));
        }
        if (args.getSubtitles) {
            files.addAll(cli.getMissingSubtitles(files, args.getSearchQuery(), args.getLanguage(), args.getSubtitleOutputFormat(), args.getEncoding(), args.getSubtitleNamingFormat(), args.isStrict()));
        }
        if (args.rename) {
            cli.rename(files, args.getRenameAction(), args.getConflictAction(), args.getAbsoluteOutputFolder(), args.getExpressionFileFormat(), args.getDatasource(), args.getSearchQuery(), args.getSortOrder(), args.getExpressionFilter(), args.getLanguage().getLocale(), args.isStrict(), args.getExecCommand());
        }
        if (args.check) {
            if (FileUtilities.containsOnly(files, MediaTypes.VERIFICATION_FILES)) {
                if (!cli.check(files)) {
                    throw new Exception("Data corruption detected");
                }
            } else {
                cli.compute(files, args.getOutputPath(), args.getOutputHashType(), args.getEncoding());
            }
        }
        return 0;
    }

    private int print(Stream<?> values) {
        return values.mapToInt(v -> {
            System.out.println(v);
            return 1;
        }).sum() == 0 ? 1 : 0;
    }

    public void runScript(CmdlineInterface cli, ArgumentBean args) throws Throwable {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("__args", (Object)args);
        bindings.put("args", (Object)args.getFiles(false));
        ScriptSource source = ScriptSource.findScriptProvider(args.script);
        ScriptShell shell = new ScriptShell(source.getScriptProvider(args.script), cli, args.defines);
        shell.runScript(source.accept(args.script), bindings);
    }
}

