/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import net.filebot.Logging;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.MediaBindingBean;

public class ExecCommand {
    private List<ExpressionFormat> template;
    private boolean parallel;
    private File directory;

    public ExecCommand(List<ExpressionFormat> template, boolean parallel, File directory) {
        this.template = template;
        this.parallel = parallel;
        this.directory = directory;
    }

    public void execute(MediaBindingBean ... group) throws IOException, InterruptedException {
        if (this.parallel) {
            this.executeParallel(group);
        } else {
            this.executeSequence(group);
        }
    }

    private void executeSequence(MediaBindingBean ... group) throws IOException, InterruptedException {
        List commands = Stream.of(group).map(v -> this.template.stream().map(t -> this.getArgumentValue((ExpressionFormat)t, (MediaBindingBean)v)).filter(Objects::nonNull).collect(Collectors.toList())).distinct().collect(Collectors.toList());
        for (List command : commands) {
            this.execute(command);
        }
    }

    private void executeParallel(MediaBindingBean ... group) throws IOException, InterruptedException {
        List<String> command = this.template.stream().flatMap(t -> Stream.of(group).map(v -> this.getArgumentValue((ExpressionFormat)t, (MediaBindingBean)v)).filter(Objects::nonNull).distinct()).collect(Collectors.toList());
        this.execute(command);
    }

    private String getArgumentValue(ExpressionFormat template, MediaBindingBean variables) {
        try {
            return template.format(variables);
        }
        catch (Exception e) {
            Logging.debug.warning(Logging.cause(template.getExpression(), e));
            return null;
        }
    }

    private void execute(List<String> command) throws IOException, InterruptedException {
        ProcessBuilder process = new ProcessBuilder(command);
        process.directory(this.directory);
        process.inheritIO();
        Logging.debug.finest(Logging.format("Execute %s", command));
        int exitCode = process.start().waitFor();
        if (exitCode != 0) {
            throw new IOException(String.format("%s failed with exit code %d", command, exitCode));
        }
    }

    public static ExecCommand parse(List<String> args, File directory) throws ScriptException {
        boolean parallel;
        boolean bl = parallel = args.lastIndexOf("+") == args.size() - 1;
        if (parallel) {
            args = args.subList(0, args.size() - 1);
        }
        ArrayList<ExpressionFormat> template = new ArrayList<ExpressionFormat>();
        for (String argument : args) {
            template.add(new ExpressionFormat(argument));
        }
        return new ExecCommand(template, parallel, directory);
    }
}

