/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.filebot.Logging;
import net.filebot.util.DefaultThreadFactory;
import net.filebot.util.FileUtilities;
import net.filebot.util.Timer;

public abstract class FolderWatchService
implements Closeable {
    private final Collection<File> commitSet = new HashSet<File>();
    private final ExecutorService processor = Executors.newSingleThreadExecutor();
    private final ExecutorService watchers = Executors.newCachedThreadPool(new DefaultThreadFactory("FolderWatchService"));
    private long commitDelay = 500L;
    private boolean commitPerFolder = true;
    private final Timer commitTimer = new Timer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutorService executorService = FolderWatchService.this.processor;
            synchronized (executorService) {
                FolderWatchService.this.commit();
            }
        }
    };
    private final boolean watchTree;

    public FolderWatchService(boolean watchTree) {
        this.watchTree = watchTree;
    }

    public synchronized void setCommitPerFolder(boolean enabled) {
        this.commitPerFolder = enabled;
    }

    public synchronized void setCommitDelay(long commitDelay) {
        if (commitDelay < 0L) {
            throw new IllegalArgumentException("Delay must not be negativ");
        }
        this.commitDelay = commitDelay;
        this.resetCommitTimer();
    }

    public synchronized void resetCommitTimer() {
        this.commitTimer.set(this.commitDelay, TimeUnit.MILLISECONDS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        TreeSet<File> files = new TreeSet<File>();
        Collection<File> collection = this.commitSet;
        synchronized (collection) {
            for (File it : this.commitSet) {
                if (!it.isFile()) continue;
                files.add(it);
            }
            this.commitSet.clear();
        }
        if (files.isEmpty()) {
            return;
        }
        final SortedMap<File, List<File>> commitBatches = this.commitPerFolder ? FileUtilities.mapByFolder(files) : Collections.singletonMap(null, files);
        this.processor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ExecutorService executorService = FolderWatchService.this.processor;
                synchronized (executorService) {
                    for (Map.Entry it : commitBatches.entrySet()) {
                        FolderWatchService.this.processCommitSet(((Collection)it.getValue()).toArray(new File[0]), (File)it.getKey());
                    }
                }
            }
        });
    }

    public abstract void processCommitSet(File[] var1, File var2);

    public synchronized void watchFolder(File folder) throws IOException {
        if (!this.watchTree) {
            this.startWatch(folder);
            return;
        }
        this.watchFolderTree(folder);
    }

    private void watchFolderTree(File root) throws IOException {
        for (File it : FileUtilities.getChildren(root, FileUtilities.FOLDERS)) {
            this.watchFolderTree(it);
        }
        this.startWatch(root);
    }

    private synchronized void startWatch(File node) throws IOException {
        if (!node.isDirectory()) {
            throw new IllegalArgumentException("Must be a folder: " + node);
        }
        this.watchers.submit(new FolderWatcher(node){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void processEvents(List<WatchEvent<?>> events) {
                Collection collection = FolderWatchService.this.commitSet;
                synchronized (collection) {
                    FolderWatchService.this.resetCommitTimer();
                    super.processEvents(events);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void created(File file) {
                Collection collection = FolderWatchService.this.commitSet;
                synchronized (collection) {
                    if (!file.isDirectory()) {
                        FolderWatchService.this.commitSet.add(file);
                        return;
                    }
                    if (FolderWatchService.this.watchTree) {
                        try {
                            FolderWatchService.this.commitSet.addAll(FileUtilities.listFiles(file, FileUtilities.FILES));
                            FolderWatchService.this.watchFolder(file);
                        }
                        catch (IOException e) {
                            Logging.debug.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void modified(File file) {
                Collection collection = FolderWatchService.this.commitSet;
                synchronized (collection) {
                    if (!file.isDirectory()) {
                        FolderWatchService.this.commitSet.add(file);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void deleted(File file) {
                Collection collection = FolderWatchService.this.commitSet;
                synchronized (collection) {
                    FolderWatchService.this.commitSet.remove(file);
                }
            }
        });
    }

    @Override
    public synchronized void close() throws IOException {
        this.commitTimer.cancel();
        this.processor.shutdownNow();
        this.watchers.shutdownNow();
    }

    private static abstract class FolderWatcher
    implements Runnable,
    Closeable {
        private final Path node;
        private final WatchService watchService;

        public FolderWatcher(File node) throws IOException {
            this.node = node.toPath();
            this.watchService = this.node.getFileSystem().newWatchService();
            this.node.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        }

        @Override
        public void run() {
            try {
                this.watch();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
        }

        public void watch() throws IOException, InterruptedException {
            try {
                boolean valid = true;
                while (valid) {
                    WatchKey key = this.watchService.take();
                    this.processEvents(key.pollEvents());
                    valid = key.reset();
                }
            }
            finally {
                this.close();
            }
        }

        public File getAbsoluteFile(WatchEvent event) {
            return this.node.resolve(event.context().toString()).toFile();
        }

        protected void processEvents(List<WatchEvent<?>> list) {
            for (WatchEvent<?> event : list) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    this.created(this.getAbsoluteFile(event));
                    continue;
                }
                if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                    this.modified(this.getAbsoluteFile(event));
                    continue;
                }
                if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                this.deleted(this.getAbsoluteFile(event));
            }
        }

        protected abstract void created(File var1);

        protected abstract void modified(File var1);

        protected abstract void deleted(File var1);

        @Override
        public void close() throws IOException {
            this.watchService.close();
        }
    }
}

