/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.cli;

import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.cli.CmdlineException;
import net.filebot.cli.ScriptBundle;
import net.filebot.cli.ScriptProvider;
import net.filebot.util.FileUtilities;
import org.tukaani.xz.XZInputStream;

public enum ScriptSource {
    GITHUB_STABLE{

        @Override
        public String accept(String input) {
            return input.startsWith("fn:") ? input.substring(3) : null;
        }

        @Override
        public ScriptProvider getScriptProvider(String input) throws Exception {
            URI resource = new URI(Settings.getApplicationProperty("github.stable"));
            CachedResource<URI, byte[]> bundle = this.getCache().bytes(resource, URI::toURL, XZInputStream::new).expire(Cache.ONE_WEEK);
            return new ScriptBundle(bundle, ((Object)((Object)this)).getClass().getResourceAsStream("repository.cer"));
        }
    }
    ,
    GITHUB_MASTER{

        @Override
        public String accept(String input) {
            return input.startsWith("dev:") ? input.substring(4) : null;
        }

        @Override
        public ScriptProvider getScriptProvider(String input) throws Exception {
            URI parent = new URI(Settings.getApplicationProperty("github.master"));
            return n -> this.getCache().text(n, s -> parent.resolve(s + ".groovy").toURL()).fetch(CachedResource.fetchIfNoneMatch(url -> n, this.getCache())).expire(Cache.ONE_DAY).get();
        }
    }
    ,
    INLINE_GROOVY{

        @Override
        public String accept(String input) {
            return input.startsWith("g:") ? input.substring(2) : null;
        }

        @Override
        public ScriptProvider getScriptProvider(String input) throws Exception {
            return g -> g;
        }
    }
    ,
    REMOTE_URL{

        @Override
        public String accept(String input) {
            if (input.length() < 2 || input.charAt(1) == ':') {
                return null;
            }
            try {
                URI uri = new URI(input);
                if (uri.isAbsolute()) {
                    return FileUtilities.getName(new File(uri.getPath()));
                }
            }
            catch (Exception e) {
                Logging.debug.finest(e::toString);
            }
            return null;
        }

        @Override
        public ScriptProvider getScriptProvider(String input) throws Exception {
            URI parent = new URI(input).resolve(".");
            return n -> this.getCache().text(n, s -> parent.resolve(s + ".groovy").toURL()).expire(Duration.ZERO).get();
        }
    }
    ,
    LOCAL_FILE{

        @Override
        public String accept(String input) {
            try {
                File f = new File(input).getCanonicalFile();
                if (f.isFile()) {
                    return FileUtilities.getName(f);
                }
            }
            catch (Exception e) {
                Logging.debug.finest(e::toString);
            }
            return null;
        }

        @Override
        public ScriptProvider getScriptProvider(String input) throws Exception {
            File base = new File(input).getCanonicalFile().getParentFile();
            return f -> FileUtilities.readTextFile(new File(base, f + ".groovy"));
        }
    };


    public abstract String accept(String var1);

    public abstract ScriptProvider getScriptProvider(String var1) throws Exception;

    public Cache getCache() {
        return Cache.getCache(this.name(), CacheType.Persistent);
    }

    public static ScriptSource findScriptProvider(String input) throws Exception {
        return Arrays.stream(ScriptSource.values()).filter(s -> s.accept(input) != null).findFirst().orElseThrow(() -> new CmdlineException("Bad script source: " + input));
    }
}

