/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.format;

import java.security.AccessController;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.filebot.format.ExpressionBindings;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.PrivilegedInvocation;
import net.filebot.format.SecureCompiledScript;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ExpressionFilter {
    private final String expression;
    private final CompiledScript compiledExpression;
    private Throwable lastException;

    public ExpressionFilter(String expression) throws ScriptException {
        this.expression = expression;
        this.compiledExpression = new SecureCompiledScript(ExpressionFormat.compileScriptlet(expression));
    }

    public String getExpression() {
        return this.expression;
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public boolean matches(Object value) {
        return this.matches(new ExpressionBindings(value));
    }

    public boolean matches(Bindings bindings) {
        this.lastException = null;
        Bindings priviledgedBindings = PrivilegedInvocation.newProxy(Bindings.class, bindings, AccessController.getContext());
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(priviledgedBindings, 200);
        try {
            Object value = this.compiledExpression.eval(context);
            return DefaultTypeTransformation.castToBoolean(value);
        }
        catch (Throwable e) {
            this.lastException = e;
            return false;
        }
    }
}

