/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.filebot.hash.Hash;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationFileReader;
import net.filebot.util.FileUtilities;

public final class VerificationUtilities {
    public static final Pattern EMBEDDED_CHECKSUM = Pattern.compile("(?<=\\[|\\()(\\p{XDigit}{8})(?=\\]|\\))");

    public static String getEmbeddedChecksum(CharSequence string) {
        Matcher matcher = EMBEDDED_CHECKSUM.matcher(string);
        String embeddedChecksum = null;
        while (matcher.find()) {
            embeddedChecksum = matcher.group();
        }
        return embeddedChecksum;
    }

    public static String getHashFromVerificationFile(File file, HashType type, int maxDepth) throws IOException {
        return VerificationUtilities.getHashFromVerificationFile(file.getParentFile(), file, type, 0, maxDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHashFromVerificationFile(File folder, File target, HashType type, int depth, int maxDepth) throws IOException {
        if (folder == null || depth > maxDepth) {
            return null;
        }
        for (File verificationFile : FileUtilities.getChildren(folder, type.getFilter())) {
            try (VerificationFileReader parser = new VerificationFileReader(FileUtilities.createTextReader(verificationFile), type.getFormat());){
                while (parser.hasNext()) {
                    Object entry = parser.next();
                    File file = new File(folder, ((File)entry.getKey()).getPath());
                    if (!target.equals(file)) continue;
                    String string = (String)entry.getValue();
                    return string;
                }
            }
        }
        return VerificationUtilities.getHashFromVerificationFile(folder.getParentFile(), target, type, depth + 1, maxDepth);
    }

    public static HashType getHashType(File verificationFile) {
        for (HashType hashType : HashType.values()) {
            if (!hashType.getFilter().accept(verificationFile)) continue;
            return hashType;
        }
        return null;
    }

    public static HashType getHashTypeByExtension(String extension) {
        for (HashType hashType : HashType.values()) {
            if (!hashType.getFilter().acceptExtension(extension)) continue;
            return hashType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeHash(File file, HashType type) throws IOException, InterruptedException {
        Hash hash = type.newHash();
        try (FileInputStream in = new FileInputStream(file);){
            byte[] buffer = new byte[65536];
            int len = 0;
            while ((len = ((InputStream)in).read(buffer)) >= 0) {
                hash.update(buffer, 0, len);
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
        }
        return hash.digest();
    }

    public static String crc32(File file) throws IOException, InterruptedException {
        return VerificationUtilities.computeHash(file, HashType.SFV);
    }

    public static String sha256(File file) throws IOException, InterruptedException {
        return VerificationUtilities.computeHash(file, HashType.SHA256);
    }

    private VerificationUtilities() {
        throw new UnsupportedOperationException();
    }
}

