/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.media;

import java.io.File;
import java.util.Comparator;
import java.util.regex.Pattern;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.MediaDetection;
import net.filebot.util.StringUtilities;

public class VideoQuality
implements Comparator<File> {
    public static final Comparator<File> DESCENDING_ORDER = new VideoQuality().reversed();
    private final Comparator<File> chain = Comparator.comparing(f -> new MediaBindingBean(f, (File)f), Comparator.comparingInt(this::getRepack).thenComparingInt(this::getResolution).thenComparingLong(MediaBindingBean::getFileSize));
    private final Pattern repack = MediaDetection.releaseInfo.getRepackPattern();

    public static boolean isBetter(File f1, File f2) {
        return DESCENDING_ORDER.compare(f1, f2) < 0;
    }

    @Override
    public int compare(File f1, File f2) {
        return this.chain.compare(f1, f2);
    }

    private int getRepack(MediaBindingBean m) {
        return StringUtilities.find(m.getFileName(), this.repack) || StringUtilities.find(m.getOriginalFileName(), this.repack) ? 1 : 0;
    }

    private int getResolution(MediaBindingBean m) {
        File mediaFile = m.getInferredMediaFile();
        if (MediaTypes.VIDEO_FILES.accept(mediaFile)) {
            try {
                return m.getDimension().stream().mapToInt(Number::intValue).reduce((a, b) -> a * b).orElse(0);
            }
            catch (Exception e) {
                Logging.debug.warning("Failed to read media info: " + e);
            }
        }
        return 0;
    }
}

