/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import com.ibm.icu.text.Transliterator;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.SimilarityMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserQGram3;

public class NameSimilarityMetric
implements SimilarityMetric {
    private final AbstractStringMetric metric;
    private final Transliterator transliterator;

    public NameSimilarityMetric() {
        this(new QGramsDistance(new TokeniserQGram3()), Transliterator.getInstance("Any-Latin;Latin-ASCII;[:Diacritic:]remove"));
    }

    public NameSimilarityMetric(AbstractStringMetric metric, Transliterator transliterator) {
        this.metric = metric;
        this.transliterator = transliterator;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        return this.metric.getSimilarity(this.normalize(o1), this.normalize(o2));
    }

    protected String normalize(Object object) {
        String name = object.toString();
        if (this.transliterator != null) {
            name = this.transliterator.transform(name);
        }
        name = Normalization.normalizePunctuation(name);
        return name.toLowerCase();
    }
}

