/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.io.Closeable;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Formatter;
import java.util.Locale;
import java.util.TimeZone;
import net.filebot.subtitle.SubtitleElement;

public class SubRipWriter
implements Closeable {
    private final DateFormat timeFormat;
    private final Formatter out;
    private int lineNumber = 0;

    public SubRipWriter(Appendable out) {
        this.out = new Formatter(out, Locale.ROOT);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss,SSS", Locale.ROOT);
        this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void write(SubtitleElement element) {
        this.out.format("%d%n", ++this.lineNumber);
        this.out.format("%s --> %s%n", this.timeFormat.format(element.getStart()), this.timeFormat.format(element.getEnd()));
        this.out.format("%s%n%n", element.getText());
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

