/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.torrent;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class BDecoder {
    BDecoder() {
    }

    public static Map<?, ?> decode(InputStream is) throws IOException {
        return new BDecoder().decodeStream(is);
    }

    public Map<?, ?> decodeStream(InputStream data) throws IOException {
        Object res = this.decodeInputStream(data, 0);
        if (res == null) {
            throw new IOException("BDecoder: zero length file");
        }
        if (!(res instanceof Map)) {
            throw new IOException("BDecoder: top level isn't a Map");
        }
        return (Map)res;
    }

    private Object decodeInputStream(InputStream bais, int nesting) throws IOException {
        if (!bais.markSupported()) {
            throw new IOException("InputStream must support the mark() method");
        }
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        switch (tempByte) {
            case 100: {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                byte[] tempByteArray = null;
                while ((tempByteArray = (byte[])this.decodeInputStream(bais, nesting + 1)) != null) {
                    Object value = this.decodeInputStream(bais, nesting + 1);
                    CharBuffer cb = StandardCharsets.ISO_8859_1.decode(ByteBuffer.wrap(tempByteArray));
                    String key = new String(cb.array(), 0, cb.limit());
                    tempMap.put(key, value);
                }
                if (bais.available() < nesting) {
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of dictionary");
                }
                return tempMap;
            }
            case 108: {
                ArrayList<Object> tempList = new ArrayList<Object>();
                Object tempElement = null;
                while ((tempElement = this.decodeInputStream(bais, nesting + 1)) != null) {
                    tempList.add(tempElement);
                }
                if (bais.available() < nesting) {
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of list");
                }
                return tempList;
            }
            case -1: 
            case 101: {
                return null;
            }
            case 105: {
                return this.getNumberFromStream(bais, 'e');
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                bais.reset();
                return this.getByteArrayFromStream(bais);
            }
        }
        int rem_len = bais.available();
        if (rem_len > 256) {
            rem_len = 256;
        }
        byte[] rem_data = new byte[rem_len];
        bais.read(rem_data);
        throw new IOException("BDecoder: unknown command '" + tempByte + ", remainder = " + new String(rem_data));
    }

    private long getNumberFromStream(InputStream bais, char parseChar) throws IOException {
        int length = 0;
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        while (tempByte != parseChar && tempByte >= 0) {
            tempByte = bais.read();
            ++length;
        }
        if (tempByte < 0) {
            return -1L;
        }
        bais.reset();
        byte[] tempArray = new byte[length];
        int len = 0;
        for (int count = 0; count != length && (len = bais.read(tempArray, count, length - count)) > 0; count += len) {
        }
        bais.skip(1L);
        CharBuffer cb = StandardCharsets.ISO_8859_1.decode(ByteBuffer.wrap(tempArray));
        String str_value = new String(cb.array(), 0, cb.limit());
        return Long.parseLong(str_value);
    }

    private byte[] getByteArrayFromStream(InputStream bais) throws IOException {
        int count;
        int length = (int)this.getNumberFromStream(bais, ':');
        if (length < 0) {
            return null;
        }
        if (length > 0x800000) {
            throw new IOException("Byte array length too large (" + length + ")");
        }
        byte[] tempArray = new byte[length];
        int len = 0;
        for (count = 0; count != length && (len = bais.read(tempArray, count, length - count)) > 0; count += len) {
        }
        if (count != tempArray.length) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
        return tempArray;
    }
}

