/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.ui.transfer.TextFileExportHandler;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.SwingUI;

public class FileBotList<E>
extends JComponent {
    protected EventList<E> model = new BasicEventList();
    protected JList<E> list = new JList<E>(new DefaultEventListModel<E>(this.model));
    protected JScrollPane listScrollPane = new JScrollPane(this.list);
    private final AbstractAction defaultRemoveAction = new AbstractAction("Remove"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = FileBotList.this.list.getSelectedIndex();
            for (Object value : FileBotList.this.list.getSelectedValuesList()) {
                FileBotList.this.getModel().remove(value);
            }
            int maxIndex = FileBotList.this.list.getModel().getSize() - 1;
            if (index > maxIndex) {
                index = maxIndex;
            }
            FileBotList.this.list.setSelectedIndex(index);
        }
    };
    private Action removeAction = this.defaultRemoveAction;
    private final AbstractAction removeHook = new AbstractAction("Remove"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileBotList.this.getRemoveAction() != null && FileBotList.this.getRemoveAction().isEnabled()) {
                FileBotList.this.getRemoveAction().actionPerformed(e);
            }
        }
    };

    public FileBotList() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(this.getTitle()));
        this.list.setCellRenderer(new DefaultFancyListCellRenderer());
        this.list.setSelectionMode(2);
        this.list.setTransferHandler(new DefaultTransferHandler(null, null));
        this.list.setDragEnabled(false);
        this.add((Component)this.listScrollPane, "Center");
        this.getRemoveAction().setEnabled(false);
        SwingUI.installAction(this, KeyStroke.getKeyStroke(127, 0), this.removeHook);
        SwingUI.installAction(this, KeyStroke.getKeyStroke(127, 512), this.removeHook);
    }

    public EventList<E> getModel() {
        return this.model;
    }

    public void setModel(EventList<E> model) {
        this.model = model;
        this.list.setModel(new DefaultEventListModel<E>(model));
    }

    public JList<E> getListComponent() {
        return this.list;
    }

    public JScrollPane getListScrollPane() {
        return this.listScrollPane;
    }

    @Override
    public DefaultTransferHandler getTransferHandler() {
        return (DefaultTransferHandler)this.list.getTransferHandler();
    }

    public void setTransferablePolicy(TransferablePolicy transferablePolicy) {
        this.getTransferHandler().setTransferablePolicy(transferablePolicy);
    }

    public TransferablePolicy getTransferablePolicy() {
        return this.getTransferHandler().getTransferablePolicy();
    }

    public void setExportHandler(TextFileExportHandler exportHandler) {
        this.getTransferHandler().setExportHandler(exportHandler);
        this.list.setDragEnabled(exportHandler != null);
    }

    public TextFileExportHandler getExportHandler() {
        return (TextFileExportHandler)this.getTransferHandler().getExportHandler();
    }

    public String getTitle() {
        return (String)this.getClientProperty("title");
    }

    public void setTitle(String title) {
        this.putClientProperty("title", title);
        if (this.getBorder() instanceof TitledBorder) {
            TitledBorder border = (TitledBorder)this.getBorder();
            border.setTitle(title);
            this.repaint();
        }
    }

    public Action getRemoveAction() {
        return this.removeAction;
    }

    public void setRemoveAction(Action action) {
        this.removeAction = action;
    }
}

