/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.filebot.Language;

public class LanguageComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    public static final Language ALL_LANGUAGES = new Language("undefined", "und", "und", "und", new String[]{"All Languages"});
    private Language defaultLanguage;
    private Language selection;
    private List<Language> favorites = new Favorites(2);
    private List<Language> values = Language.availableLanguages();

    public LanguageComboBoxModel(Language defaultLanguage, Language initialSelection) {
        this.defaultLanguage = defaultLanguage;
        this.selection = initialSelection;
    }

    @Override
    public Language getElementAt(int index) {
        if (index == 0) {
            return this.defaultLanguage;
        }
        if (--index < this.favorites.size()) {
            return this.favorites.get(index);
        }
        return this.values.get(index -= this.favorites.size());
    }

    @Override
    public int getSize() {
        return 1 + this.favorites.size() + this.values.size();
    }

    public List<Language> favorites() {
        return this.favorites;
    }

    @Override
    public Language getSelectedItem() {
        return this.selection;
    }

    @Override
    public void setSelectedItem(Object value) {
        if (value instanceof Language) {
            Language language = (Language)value;
            this.selection = ALL_LANGUAGES.getCode().equals(language.getCode()) ? ALL_LANGUAGES : language;
        }
    }

    protected int convertFavoriteIndexToModel(int favoriteIndex) {
        return 1 + favoriteIndex;
    }

    protected void fireFavoritesAdded(int from, int to) {
        this.fireIntervalAdded(this, this.convertFavoriteIndexToModel(from), this.convertFavoriteIndexToModel(to));
    }

    protected void fireFavoritesRemoved(int from, int to) {
        this.fireIntervalRemoved(this, this.convertFavoriteIndexToModel(from), this.convertFavoriteIndexToModel(to));
    }

    private class Favorites
    extends AbstractList<Language> {
        private final List<Language> data;
        private final int capacity;

        public Favorites(int capacity) {
            this.data = new ArrayList<Language>(capacity);
            this.capacity = capacity;
        }

        @Override
        public Language get(int index) {
            return this.data.get(index);
        }

        @Override
        public boolean add(Language element) {
            return this.addIfAbsent(0, element);
        }

        @Override
        public void add(int index, Language element) {
            this.addIfAbsent(index, element);
        }

        public boolean addIfAbsent(int index, Language element) {
            if (element == null || element == ALL_LANGUAGES || element.getCode().equals(LanguageComboBoxModel.this.defaultLanguage.getCode()) || this.contains(element) || index >= this.capacity) {
                return false;
            }
            if (this.data.size() >= this.capacity) {
                this.remove(this.data.size() - 1);
            }
            this.data.add(index, element.clone());
            LanguageComboBoxModel.this.fireFavoritesAdded(index, index);
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Language) {
                Language language = (Language)obj;
                for (Language element : this.data) {
                    if (!language.getCode().equals(element.getCode())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Language remove(int index) {
            Language old = this.data.remove(index);
            LanguageComboBoxModel.this.fireFavoritesRemoved(index, index);
            return old;
        }

        @Override
        public int size() {
            return this.data.size();
        }
    }
}

