/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import net.filebot.HistorySpooler;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.util.PreferencesMap;
import net.filebot.util.StringUtilities;
import net.filebot.util.ui.SwingUI;

public enum SupportDialog {
    Donation{

        @Override
        String getMessage(int renameCount) {
            return String.format("<html><p style='font-size:16pt; font-weight:bold'>Thank you for using FileBot!</p><br><p>It has taken thousands of hours to develop this application. If you enjoy using it,<br>please consider making a donation. It'll help make FileBot even better!<p><p style='font-size:14pt; font-weight:bold'>You've renamed %,d files.</p><br><html>", renameCount);
        }

        @Override
        String[] getActions(boolean first) {
            if (first) {
                return new String[]{"Donate! :)", "Nope! Maybe next time."};
            }
            return new String[]{"Donate again! :)", "Nope! Not this time."};
        }

        @Override
        Icon getIcon() {
            return ResourceManager.getIcon("message.donate");
        }

        @Override
        String getTitle() {
            return "Please Donate";
        }

        @Override
        public boolean feelingLucky(int sessionRenameCount, int totalRenameCount, int currentRevision, int lastSupportRevision, int supportRevisionCount) {
            if (sessionRenameCount > 0 && Stream.of("Mac OS X", "Windows 10").anyMatch(Predicate.isEqual(System.getProperty("os.name")))) {
                return true;
            }
            return super.feelingLucky(sessionRenameCount, totalRenameCount, currentRevision, lastSupportRevision, supportRevisionCount);
        }

        @Override
        String getURI() {
            return Settings.getDonateURL();
        }
    }
    ,
    AppStoreReview{

        @Override
        String getMessage(int renameCount) {
            return String.format("<html><p style='font-size:16pt; font-weight:bold'>Thank you for using FileBot!</p><br><p>It has taken thousands of hours to develop this application. If you enjoy using it,<br>please consider writing a nice review on the %s.<p><p style='font-size:14pt; font-weight:bold'>You've renamed %,d files.</p><br><html>", Settings.getAppStoreName(), renameCount);
        }

        @Override
        String[] getActions(boolean first) {
            if (first) {
                return new String[]{"Write a Review! :)", "Nope! Maybe next time."};
            }
            return new String[]{"Update my Review! :)", "Nope! Not this time."};
        }

        @Override
        Icon getIcon() {
            return ResourceManager.getIcon("window.icon.large");
        }

        @Override
        String getTitle() {
            return "Please write a Review";
        }

        @Override
        public boolean feelingLucky(int sessionRenameCount, int totalRenameCount, int currentRevision, int lastSupportRevision, int supportRevisionCount) {
            if (currentRevision <= lastSupportRevision) {
                return false;
            }
            if (sessionRenameCount < 5 || totalRenameCount < 5000) {
                return false;
            }
            if (Math.random() <= 0.777) {
                return false;
            }
            return super.feelingLucky(sessionRenameCount, totalRenameCount, currentRevision, lastSupportRevision, supportRevisionCount);
        }

        @Override
        String getURI() {
            return Settings.getAppStoreLink();
        }
    };


    public boolean feelingLucky(int sessionRenameCount, int totalRenameCount, int currentRevision, int lastSupportRevision, int supportRevisionCount) {
        if ((double)sessionRenameCount >= 2000.0 * Math.pow(2.0, supportRevisionCount)) {
            return true;
        }
        return (double)totalRenameCount >= 2000.0 * Math.pow(5.0, supportRevisionCount);
    }

    public boolean show(int totalRenameCount, boolean first) {
        String message = this.getMessage(totalRenameCount);
        Object[] actions = this.getActions(first);
        JOptionPane pane = new JOptionPane(message, 1, 0, this.getIcon(), actions, actions[0]);
        pane.createDialog(null, this.getTitle()).setVisible(true);
        if (pane.getValue() == actions[0]) {
            SwingUI.openURI(this.getURI());
        }
        return true;
    }

    abstract String getMessage(int var1);

    abstract String[] getActions(boolean var1);

    abstract Icon getIcon();

    abstract String getTitle();

    abstract String getURI();

    public static void maybeShow() {
        try {
            SupportDialog dialog;
            PreferencesMap.PreferencesEntry<String> persistentSupportRevision = Settings.forPackage(SupportDialog.class).entry("support.revision");
            List<Integer> supportRevision = StringUtilities.matchIntegers(persistentSupportRevision.getValue());
            int lastSupportRevision = supportRevision.stream().max(Integer::compare).orElse(0);
            int currentRevision = Settings.getApplicationRevisionNumber();
            int sessionRenameCount = HistorySpooler.getInstance().getSessionHistoryTotalSize();
            int totalRenameCount = HistorySpooler.getInstance().getPersistentHistoryTotalSize();
            SupportDialog supportDialog = dialog = Settings.isAppStore() ? AppStoreReview : Donation;
            if (dialog.feelingLucky(sessionRenameCount, totalRenameCount, currentRevision, lastSupportRevision, supportRevision.size()) && dialog.show(totalRenameCount, supportRevision.isEmpty())) {
                supportRevision = Stream.concat(supportRevision.stream(), Stream.of(Integer.valueOf(currentRevision))).sorted().distinct().collect(Collectors.toList());
                persistentSupportRevision.setValue(supportRevision.toString());
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e, e::toString);
        }
    }
}

