/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.episodelist;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import net.filebot.ui.FileBotList;
import net.filebot.ui.FileBotListExportHandler;
import net.filebot.ui.transfer.ArrayTransferable;
import net.filebot.ui.transfer.ClipboardHandler;
import net.filebot.ui.transfer.CompositeTranserable;
import net.filebot.util.StringUtilities;
import net.filebot.web.Episode;

class EpisodeListExportHandler
extends FileBotListExportHandler<Episode>
implements ClipboardHandler {
    public EpisodeListExportHandler(FileBotList<Episode> list) {
        super(list);
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        ArrayTransferable<Episode> episodeArray = this.export(this.list, true);
        Transferable textFile = super.createTransferable(c);
        return new CompositeTranserable(episodeArray, textFile);
    }

    @Override
    public void exportToClipboard(JComponent c, Clipboard clipboard, int action) throws IllegalStateException {
        ArrayTransferable<Episode> episodeData = this.export(this.list, false);
        StringSelection stringSelection = new StringSelection(StringUtilities.join(episodeData.getArray(), (CharSequence)System.lineSeparator()));
        clipboard.setContents(new CompositeTranserable(episodeData, stringSelection), null);
    }

    public ArrayTransferable<Episode> export(FileBotList<?> list, boolean forceAll) {
        Episode[] selection;
        block3: {
            block2: {
                selection = (Episode[])list.getListComponent().getSelectedValuesList().stream().map(Episode.class::cast).toArray(Episode[]::new);
                if (forceAll) break block2;
                if (selection.length != 0) break block3;
            }
            selection = (Episode[])list.getModel().stream().map(Episode.class::cast).toArray(Episode[]::new);
        }
        return new ArrayTransferable<Episode>(selection);
    }
}

