/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.episodelist;

import java.awt.Color;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JSpinner;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

class SeasonSpinnerEditor
extends JSpinner.DefaultEditor {
    public SeasonSpinnerEditor(JSpinner spinner) {
        super(spinner);
        this.getTextField().setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter(){

            @Override
            public Object stringToValue(String string) throws ParseException {
                if ("All Seasons".equals(string)) {
                    return 0;
                }
                Matcher matcher = Pattern.compile("Season (\\d+)").matcher(string);
                if (matcher.matches()) {
                    return Integer.valueOf(matcher.group(1));
                }
                throw new ParseException("Illegal season number", 0);
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                int season = ((Number)value).intValue();
                if (season == 0) {
                    return "All Seasons";
                }
                if (season >= 1) {
                    return String.format("Season %d", season);
                }
                throw new ParseException("Illegal season number", 0);
            }
        }));
        this.getTextField().setHorizontalAlignment(4);
        this.getTextField().setBackground(Color.white);
    }
}

