/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.filebot.ui.filter.FileTree;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.TransferableExportHandler;

class FileTreeExportHandler
implements TransferableExportHandler {
    FileTreeExportHandler() {
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        FileTree tree = (FileTree)c;
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (TreePath path : tree.getSelectionPaths()) {
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node instanceof FileTree.FileNode) {
                files.add(((FileTree.FileNode)node).getFile());
                continue;
            }
            if (!(node instanceof FileTree.FolderNode)) continue;
            Iterator<File> iterator = ((FileTree.FolderNode)node).fileIterator();
            while (iterator.hasNext()) {
                files.add(iterator.next());
            }
        }
        if (files.isEmpty()) {
            return null;
        }
        return new FileTransferable(files);
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

