/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.filebot.MediaTypes;
import net.filebot.media.MediaDetection;
import net.filebot.ui.filter.FileTree;
import net.filebot.ui.filter.FileTreeExportHandler;
import net.filebot.ui.filter.Tool;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.LoadingOverlayPane;
import net.miginfocom.swing.MigLayout;

class TypeTool
extends Tool<TreeModel> {
    private FileTree tree = new FileTree();

    public TypeTool() {
        super("Types");
        this.setLayout(new MigLayout("insets 0, fill"));
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)new LoadingOverlayPane(treeScrollPane, this), "grow");
        this.tree.setTransferHandler(new DefaultTransferHandler(null, new FileTreeExportHandler()));
        this.tree.setDragEnabled(true);
    }

    @Override
    protected TreeModel createModelInBackground(List<File> root) {
        if (root.isEmpty()) {
            return new DefaultTreeModel(new FileTree.FolderNode("Types", Collections.emptyList()));
        }
        List<File> filesAndFolders = FileUtilities.listFiles(root, FileUtilities.NOT_HIDDEN, FileUtilities.HUMAN_NAME_ORDER);
        ArrayList<TreeNode> groups = new ArrayList<TreeNode>();
        for (Map.Entry<String, FileFilter> it : this.getMetaTypes().entrySet()) {
            List<File> selection = FileUtilities.filter(filesAndFolders, it.getValue());
            if (selection.size() > 0) {
                groups.add(this.createStatisticsNode(it.getKey(), selection));
            }
            if (!Thread.interrupted()) continue;
            throw new CancellationException();
        }
        TreeMap<String, FileTree.FolderNode> extensionGroups = new TreeMap<String, FileTree.FolderNode>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, List<File>> it : FileUtilities.mapByExtension(FileUtilities.filter(filesAndFolders, FileUtilities.FILES)).entrySet()) {
            if (it.getKey() != null) {
                extensionGroups.put(it.getKey(), this.createStatisticsNode(it.getKey(), it.getValue()));
            }
            if (!Thread.interrupted()) continue;
            throw new CancellationException();
        }
        groups.addAll(extensionGroups.values());
        return new DefaultTreeModel(new FileTree.FolderNode("Types", groups));
    }

    public Map<String, FileFilter> getMetaTypes() {
        LinkedHashMap<String, FileFilter> types = new LinkedHashMap<String, FileFilter>();
        types.put("Movie", f -> MediaDetection.isMovie(f, true));
        types.put("Episode", f -> MediaDetection.isEpisode(f, true));
        types.put("Video", MediaTypes.VIDEO_FILES);
        types.put("Subtitle", MediaTypes.SUBTITLE_FILES);
        types.put("Audio", MediaTypes.AUDIO_FILES);
        types.put("Archive", MediaTypes.ARCHIVE_FILES);
        types.put("Verification", MediaTypes.VERIFICATION_FILES);
        types.put("Clutter", MediaDetection.getClutterFileFilter());
        types.put("Disk Folder", MediaDetection.getDiskFolderFilter());
        return types;
    }

    @Override
    protected void setModel(TreeModel model) {
        this.tree.setModel(model);
    }
}

