/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.list;

import net.filebot.format.ExpressionFormat;
import net.filebot.ui.list.IndexedBindingBean;

public class ListItem {
    private IndexedBindingBean bindings;
    private ExpressionFormat format;
    private Object value;

    public ListItem(IndexedBindingBean bindings, ExpressionFormat format) {
        this.bindings = bindings;
        this.format = format;
        this.value = format != null ? null : bindings.getInfoObject().toString();
    }

    public IndexedBindingBean getBindings() {
        return this.bindings;
    }

    public Object getObject() {
        return this.bindings.getInfoObject();
    }

    public Object getFormattedValue() {
        if (this.value == null) {
            try {
                this.value = this.format.format(this.bindings);
            }
            catch (Exception e) {
                this.value = e;
            }
        }
        return this.value;
    }

    public String toString() {
        return this.getObject().toString();
    }
}

