/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.list;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.script.ScriptException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.filebot.ResourceManager;
import net.filebot.format.ExpressionFormat;
import net.filebot.ui.FileBotList;
import net.filebot.ui.FileBotListExportHandler;
import net.filebot.ui.PanelBuilder;
import net.filebot.ui.list.FileListTransferablePolicy;
import net.filebot.ui.list.IndexedBindingBean;
import net.filebot.ui.list.ListItem;
import net.filebot.ui.transfer.LoadAction;
import net.filebot.ui.transfer.SaveAction;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.LazyDocumentListener;
import net.filebot.util.ui.PrototypeCellValueUpdater;
import net.filebot.util.ui.SwingEventBus;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class ListPanel
extends JComponent {
    public static final String DEFAULT_SEQUENCE_FORMAT = "Sequence - {i.pad(2)}";
    public static final String DEFAULT_FILE_FORMAT = "{fn}";
    public static final String DEFAULT_EPISODE_FORMAT = "{n} - {s00e00} - [{absolute}] - [{airdate}] - {t}";
    private RSyntaxTextArea editor = this.createEditor();
    private SpinnerNumberModel fromSpinnerModel = new SpinnerNumberModel(1, 0, Integer.MAX_VALUE, 1);
    private SpinnerNumberModel toSpinnerModel = new SpinnerNumberModel(20, 0, Integer.MAX_VALUE, 1);
    private FileBotList<ListItem> list = new FileBotList();
    private ExpressionFormat format;
    private String template;

    public ListPanel() {
        this.list.setTitle("Title");
        this.list.getListComponent().setFixedCellHeight(28);
        this.list.getListComponent().getModel().addListDataListener(new PrototypeCellValueUpdater<String>(this.list.getListComponent(), ""));
        this.list.getRemoveAction().setEnabled(true);
        this.list.setTransferablePolicy(new FileListTransferablePolicy(this.list::setTitle, this::setFormatTemplate, this::createItemSequence));
        FileBotListExportHandler<ListItem> exportHandler = new FileBotListExportHandler<ListItem>(this.list, (item, out) -> out.println(item.getFormattedValue()));
        this.list.setExportHandler(exportHandler);
        this.list.getTransferHandler().setClipboardHandler(exportHandler);
        JPopupMenu popup = new JPopupMenu("List");
        JMenu menu = new JMenu("Send to");
        for (PanelBuilder panel : PanelBuilder.textHandlerSequence()) {
            menu.add(SwingUI.newAction(panel.getName(), panel.getIcon(), evt -> {
                String text = this.list.getExportHandler().export();
                SwingEventBus.getInstance().post(panel);
                SwingUI.invokeLater(200, () -> SwingEventBus.getInstance().post(new StringSelection(text)));
            }));
        }
        popup.add(menu);
        popup.addSeparator();
        popup.add(SwingUI.newAction("Copy", ResourceManager.getIcon("rename.action.copy"), evt -> this.list.getTransferHandler().getClipboardHandler().exportToClipboard(this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1)));
        popup.add(new SaveAction(this.list.getExportHandler()));
        this.list.getListComponent().setComponentPopupMenu(popup);
        this.list.getListComponent().setCellRenderer(new DefaultFancyListCellRenderer(){

            @Override
            protected void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ListItem item = (ListItem)value;
                Object object = item.getFormattedValue();
                if (object instanceof Exception) {
                    Exception error = (Exception)object;
                    this.setText(error.getMessage());
                    this.setIcon(ResourceManager.getIcon("status.warning"));
                } else {
                    this.setText(object.toString());
                    this.setIcon(null);
                }
            }
        });
        JSpinner fromSpinner = new JSpinner(this.fromSpinnerModel);
        JSpinner toSpinner = new JSpinner(this.toSpinnerModel);
        fromSpinner.setEditor(new JSpinner.NumberEditor(fromSpinner, "#"));
        toSpinner.setEditor(new JSpinner.NumberEditor(toSpinner, "#"));
        RTextScrollPane editorScrollPane = new RTextScrollPane(this.editor, false);
        editorScrollPane.setLineNumbersEnabled(false);
        editorScrollPane.setFoldIndicatorEnabled(false);
        editorScrollPane.setIconRowHeaderEnabled(false);
        editorScrollPane.setVerticalScrollBarPolicy(21);
        editorScrollPane.setHorizontalScrollBarPolicy(31);
        editorScrollPane.setBackground(this.editor.getBackground());
        editorScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        editorScrollPane.setOpaque(true);
        editorScrollPane.setBorder(new JTextField().getBorder());
        this.setLayout(new MigLayout("nogrid, fill, insets dialog", "align center", "[pref!, center][fill]"));
        JLabel patternLabel = new JLabel("Pattern:");
        this.add((Component)patternLabel, "gapbefore indent");
        this.add((Component)editorScrollPane, "gap related, growx, wmin 2cm, h pref!, sizegroupy editor");
        this.add((Component)new JLabel("From:"), "gap 5mm");
        this.add((Component)fromSpinner, "gap related, wmax 15mm, sizegroup spinner, sizegroupy editor");
        this.add((Component)new JLabel("To:"), "gap 5mm");
        this.add((Component)toSpinner, "gap related, wmax 15mm, sizegroup spinner, sizegroupy editor");
        this.add((Component)SwingUI.newButton("Sequence", ResourceManager.getIcon("action.export"), evt -> this.createItemSequence()), "gap 7mm, gapafter indent, wrap paragraph");
        this.add(this.list, "grow");
        JPanel buttonPanel = new JPanel(new MigLayout("insets 1.2mm, nogrid, fill", "align center"));
        buttonPanel.add(new JButton(new LoadAction(this.list::getTransferablePolicy)));
        buttonPanel.add((Component)new JButton(new SaveAction(this.list.getExportHandler())), "gap related");
        this.list.add((Component)buttonPanel, "South");
        this.createItemSequence();
    }

    private RSyntaxTextArea createEditor() {
        RSyntaxTextArea editor = new RSyntaxTextArea(new RSyntaxDocument("text/groovy"), "", 1, 80);
        editor.setAntiAliasingEnabled(true);
        editor.setAnimateBracketMatching(false);
        editor.setAutoIndentEnabled(false);
        editor.setClearWhitespaceLinesEnabled(false);
        editor.setBracketMatchingEnabled(true);
        editor.setCloseCurlyBraces(false);
        editor.setCodeFoldingEnabled(false);
        editor.setHyperlinksEnabled(false);
        editor.setUseFocusableTips(false);
        editor.setHighlightCurrentLine(false);
        editor.setLineWrap(false);
        editor.setPaintMarkOccurrencesBorder(false);
        editor.setPaintTabLines(false);
        editor.setMarkOccurrences(false);
        editor.setFont(new Font("Monospaced", 0, 14));
        Color defaultForeground = editor.getForeground();
        editor.getDocument().addDocumentListener(new LazyDocumentListener(20, evt -> {
            try {
                String expression = editor.getText().trim();
                this.setFormat(expression.isEmpty() ? null : new ExpressionFormat(expression));
                editor.setForeground(defaultForeground);
            }
            catch (ScriptException e) {
                editor.setForeground(Color.RED);
            }
        }));
        return editor;
    }

    public ListItem createItem(Object object, int i, int from, int to, List<?> context) {
        return new ListItem(new IndexedBindingBean(object, i, from, to, context), this.format);
    }

    public void setFormat(ExpressionFormat format) {
        this.format = format;
        ListIterator<ListItem> itr = this.list.getModel().listIterator();
        while (itr.hasNext()) {
            itr.set(new ListItem(((ListItem)itr.next()).getBindings(), format));
        }
    }

    public void createItemSequence(List<?> objects) {
        List items = IntStream.range(0, objects.size()).mapToObj(i -> this.createItem(objects.get(i), i + 1, 1, objects.size(), objects)).collect(Collectors.toList());
        this.list.getListComponent().clearSelection();
        this.list.getModel().clear();
        this.list.getModel().addAll(items);
    }

    public void createItemSequence() {
        int from = this.fromSpinnerModel.getNumber().intValue();
        int to = this.toSpinnerModel.getNumber().intValue();
        List context = IntStream.rangeClosed(from, to).boxed().collect(Collectors.toList());
        List items = context.stream().map(it -> this.createItem(it, (int)it, from, to, context)).collect(Collectors.toList());
        this.setFormatTemplate(DEFAULT_SEQUENCE_FORMAT);
        this.list.setTitle("Sequence");
        this.list.getListComponent().clearSelection();
        this.list.getModel().clear();
        this.list.getModel().addAll(items);
    }

    public void setFormatTemplate(String format) {
        if (this.template != format) {
            this.template = format;
            this.editor.setText(format);
        }
    }

    @Subscribe
    public void handle(Transferable transferable) throws Exception {
        TransferablePolicy handler = this.list.getTransferablePolicy();
        if (handler != null && handler.accept(transferable)) {
            handler.handleTransferable(transferable, TransferablePolicy.TransferAction.PUT);
        }
    }
}

