/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.Format;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.UserFiles;
import net.filebot.format.BindingException;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.format.SuppressedThrowables;
import net.filebot.media.MetaAttributes;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.rename.BindingDialog;
import net.filebot.ui.rename.FileNameFormat;
import net.filebot.util.DefaultThreadFactory;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.PreferencesList;
import net.filebot.util.PreferencesMap;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LazyDocumentListener;
import net.filebot.util.ui.LinkButton;
import net.filebot.util.ui.ProgressIndicator;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.filebot.web.AudioTrackFormat;
import net.filebot.web.Datasource;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.MovieFormat;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MusicIdentificationService;
import net.miginfocom.swing.MigLayout;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class FormatDialog
extends JDialog {
    private boolean submit = false;
    private ExpressionFileFormat format;
    private Mode mode;
    private boolean locked = false;
    private MediaBindingBean sample = null;
    private ExecutorService executor = this.createExecutor();
    private RunnableFuture<String> currentPreviewFuture;
    private JLabel preview = new JLabel();
    private JLabel status = new JLabel();
    private RSyntaxTextArea editor = this.createEditor();
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private JLabel title = new JLabel();
    private JPanel help = new JPanel(new MigLayout("insets 0, nogrid, novisualpadding, fillx"));
    private static final PreferencesMap.PreferencesEntry<String> persistentSampleFile = Settings.forPackage(FormatDialog.class).entry("format.sample.file");
    protected final Action changeSampleAction = SwingUI.newAction("Change Sample", ResourceManager.getIcon("action.variables"), evt -> {
        BindingDialog dialog = new BindingDialog(SwingUI.getWindow(evt.getSource()), String.format("%s Bindings", new Object[]{this.mode}), this.mode.getFormat(), !this.locked);
        dialog.setSample(this.sample);
        dialog.setLocationRelativeTo((Component)evt.getSource());
        dialog.setVisible(true);
        if (dialog.submit()) {
            Object info = dialog.getInfoObject();
            File file = dialog.getMediaFile();
            this.sample = new MediaBindingBean(info, file);
            try {
                this.mode.persistentSample().setValue(info == null ? "" : MetaAttributes.toJson(info));
                persistentSampleFile.setValue(file == null ? "" : this.sample.getFileObject().getAbsolutePath());
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
            this.fireSampleChanged();
        }
    });
    protected final Action selectFolderAction = SwingUI.newAction("Change Folder", ResourceManager.getIcon("action.load"), evt -> {
        File selectedFolder;
        File templatePath;
        String relativeFormat = this.editor.getText().trim();
        File absoluteFolder = null;
        if (relativeFormat.length() > 0 && (templatePath = new File(relativeFormat)).isAbsolute()) {
            File existingPath = null;
            for (File next : FileUtilities.listPath(templatePath)) {
                if (existingPath != null && !next.exists()) {
                    absoluteFolder = existingPath;
                    relativeFormat = relativeFormat.substring(existingPath.getPath().length() + 1);
                    break;
                }
                existingPath = next;
            }
        }
        if ((selectedFolder = UserFiles.showOpenDialogSelectFolder(absoluteFolder, "Select Folder", evt)) != null) {
            this.editor.setText(FileUtilities.normalizePathSeparators(selectedFolder.getAbsolutePath()) + "/" + relativeFormat);
        }
    });
    protected final Action showRecentAction = SwingUI.newAction("Change Format", ResourceManager.getIcon("action.menu"), evt -> {
        JComponent c = (JComponent)evt.getSource();
        this.editor.getComponentPopupMenu().show(c, 0, c.getHeight() + 3);
    });
    protected final Action cancelAction = SwingUI.newAction("Cancel", ResourceManager.getIcon("dialog.cancel"), evt -> this.finish(false));
    protected final Action switchEditModeAction = SwingUI.newAction("Switch Mode", ResourceManager.getIcon("dialog.switch"), evt -> {
        Mode next = this.mode.next();
        this.setState(next, this.restoreSample(next), false);
    });
    protected final Action approveFormatAction = SwingUI.newAction("Use Format", ResourceManager.getIcon("dialog.continue"), evt -> {
        try {
            this.format = new ExpressionFileFormat(this.editor.getText().trim());
            if (this.format.getExpression().isEmpty()) {
                throw new ScriptException("Expression is empty");
            }
            if (this.format.getExpression().length() > 8192) {
                throw new ScriptException("Expression is limited to 8192 characters");
            }
            LinkedHashSet<String> recent = new LinkedHashSet<String>();
            recent.add(this.format.getExpression());
            recent.addAll(this.mode.persistentFormatHistory());
            this.mode.persistentFormatHistory().set(recent.stream().filter(Objects::nonNull).limit(8L).collect(Collectors.toList()));
            this.finish(true);
        }
        catch (ScriptException e) {
            Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e));
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e.getMessage(), e);
        }
    });

    public FormatDialog(Window owner, Mode initMode, MediaBindingBean bindings, boolean locked) {
        super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        this.progressIndicator.setVisible(false);
        this.title.setFont(this.title.getFont().deriveFont(1));
        JPanel header = new JPanel(new MigLayout("insets dialog, nogrid, novisualpadding"));
        header.setBackground(Color.white);
        header.setBorder(new SeparatorBorder(1, new Color(0xB4B4B4), new Color(0xACACAC), GradientStyle.LEFT_TO_RIGHT, SeparatorBorder.Position.BOTTOM));
        header.add((Component)this.progressIndicator, "pos 1al 0al, hidemode 3");
        header.add((Component)this.title, "wmin 150px, wrap unrel:push");
        header.add((Component)this.preview, "wmin 150px, hmin 16px, gap indent, hidemode 3, wmax 90%");
        header.add((Component)this.status, "wmin 150px, hmin 16px, gap indent, hidemode 3, wmax 90%, newline");
        JPanel content = new JPanel(new MigLayout("insets dialog, nogrid, fill"));
        RTextScrollPane editorScrollPane = new RTextScrollPane(this.editor, false);
        editorScrollPane.setLineNumbersEnabled(false);
        editorScrollPane.setFoldIndicatorEnabled(false);
        editorScrollPane.setIconRowHeaderEnabled(false);
        editorScrollPane.setVerticalScrollBarPolicy(21);
        editorScrollPane.setHorizontalScrollBarPolicy(31);
        editorScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(7, 2, 7, 2));
        editorScrollPane.setOpaque(true);
        editorScrollPane.setBackground(new JTextField().getBackground());
        editorScrollPane.setBorder(new JTextField().getBorder());
        content.add((Component)editorScrollPane, "w 120px:min(pref, 420px), h pref, growx, wrap 4px, id editor");
        content.add((Component)SwingUI.createImageButton(this.changeSampleAction), "sg action, w 25!, h 19!, pos n editor.y2+2 editor.x2 n");
        content.add((Component)SwingUI.createImageButton(this.selectFolderAction), "sg action, w 25!, h 19!, pos n editor.y2+2 editor.x2-(27*1) n");
        content.add((Component)SwingUI.createImageButton(this.showRecentAction), "sg action, w 25!, h 19!, pos n editor.y2+2 editor.x2-(27*2) n");
        content.add((Component)this.help, "growx, wrap 25px:push");
        if (bindings == null) {
            content.add((Component)new JButton(this.switchEditModeAction), "tag left");
        }
        content.add((Component)new JButton(this.approveFormatAction), "tag apply");
        content.add((Component)new JButton(this.cancelAction), "tag cancel");
        JComponent pane = (JComponent)this.getContentPane();
        pane.setLayout(new MigLayout("insets 0, fill"));
        pane.add((Component)header, "h 60px, growx, dock north");
        pane.add((Component)content, "grow");
        this.preview.setCursor(Cursor.getPredefinedCursor(12));
        this.preview.addMouseListener(SwingUI.mouseClicked(evt -> {
            SwingUI.copyToClipboard(this.preview.getText());
            Logging.log.info("Format value has been copied to clipboard");
        }));
        this.status.setCursor(Cursor.getPredefinedCursor(12));
        this.status.addMouseListener(SwingUI.mouseClicked(evt -> {
            SwingUI.copyToClipboard(this.status.getText());
            Logging.log.info("Error message has been copied to clipboard");
        }));
        this.addPropertyChangeListener("sample", evt -> {
            if (Settings.isMacSandbox() && this.sample != null && this.sample.getFileObject() != null && this.sample.getFileObject().exists()) {
                MacAppUtilities.askUnlockFolders(SwingUI.getWindow(evt.getSource()), Collections.singleton(this.sample.getFileObject()));
            }
            this.checkFormatInBackground();
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                SwingUtilities.invokeLater(FormatDialog.this.editor::requestFocusInWindow);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(() -> FormatDialog.this.revalidate());
            }

            @Override
            public void windowClosing(WindowEvent e) {
                SwingUtilities.invokeLater(() -> FormatDialog.this.finish(false));
            }
        });
        this.editor.setComponentPopupMenu(this.createRecentFormatPopup());
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(650, 520));
        if (bindings == null) {
            bindings = this.restoreSample(initMode);
        } else if (bindings.getFileObject() == null && !locked) {
            bindings = new MediaBindingBean(bindings.getInfoObject(), this.restoreSample(initMode).getFileObject());
        }
        this.setState(initMode, bindings, locked);
    }

    public void setState(Mode mode, MediaBindingBean bindings, boolean locked) {
        this.mode = mode;
        this.locked = locked;
        if (locked) {
            this.setTitle(String.format("%s Format", new Object[]{mode}));
            this.title.setText(String.format("%s \u21d4 %s", new Object[]{mode, bindings.getInfoObject(), bindings.getFileObject() == null ? null : bindings.getFileObject().getName()}));
        } else {
            this.setTitle(String.format("%s Format", new Object[]{mode}));
            this.title.setText(String.format("%s Format", new Object[]{mode}));
        }
        this.status.setVisible(false);
        this.switchEditModeAction.putValue("Name", String.format("Switch to %s Format", new Object[]{mode.next()}));
        this.switchEditModeAction.setEnabled(!locked);
        this.updateHelpPanel(mode);
        this.sample = bindings;
        this.setFormatCode(mode.persistentFormatHistory().isEmpty() ? mode.getDefaultFormatExpression() : mode.persistentFormatHistory().get(0));
        this.fireSampleChanged();
    }

    private JComponent updateHelpPanel(Mode mode) {
        this.help.removeAll();
        this.help.add((Component)new JLabel("Syntax"), "gap indent+unrel, wrap 0");
        this.help.add((Component)this.createSyntaxPanel(mode), "gapx indent indent, wrap 8px");
        this.help.add((Component)new JLabel("Examples"), "gap indent+unrel, wrap 0");
        this.help.add((Component)this.createExamplesPanel(mode), "growx, h pref!, gapx indent indent");
        return this.help;
    }

    public void setFormatCode(String text) {
        try {
            this.editor.setText(text);
            if (text != null && text.length() > 0) {
                this.editor.scrollRectToVisible(new Rectangle(0, 0));
                this.editor.setCaretPosition(this.editor.getText().length());
                this.editor.requestFocusInWindow();
            }
        }
        catch (Exception e) {
            Logging.debug.warning(e::toString);
        }
    }

    private RSyntaxTextArea createEditor() {
        RSyntaxTextArea editor = new RSyntaxTextArea(new RSyntaxDocument("text/groovy"), "", 1, 80);
        editor.setAntiAliasingEnabled(true);
        editor.setAnimateBracketMatching(false);
        editor.setAutoIndentEnabled(false);
        editor.setClearWhitespaceLinesEnabled(false);
        editor.setBracketMatchingEnabled(true);
        editor.setCloseCurlyBraces(false);
        editor.setCodeFoldingEnabled(false);
        editor.setHyperlinksEnabled(false);
        editor.setUseFocusableTips(false);
        editor.setHighlightCurrentLine(false);
        editor.setLineWrap(false);
        editor.setPaintMarkOccurrencesBorder(false);
        editor.setPaintTabLines(false);
        editor.setMarkOccurrences(false);
        editor.setFont(new Font("Monospaced", 0, 14));
        editor.getDocument().addDocumentListener(new LazyDocumentListener(evt -> this.checkFormatInBackground()));
        editor.getDocument().addDocumentListener(new LazyDocumentListener(0, evt -> {
            int r2;
            int r1 = editor.getRows();
            if (r1 != (r2 = (int)editor.getText().chars().filter(c -> c == 10).count() + 1)) {
                editor.setRows(r2);
                SwingUI.getWindow(editor).revalidate();
            }
        }));
        return editor;
    }

    private JComponent createSyntaxPanel(Mode mode) {
        JPanel panel = new JPanel(new MigLayout("fill, nogrid, novisualpadding", "[pref]", "[fill, min]"));
        panel.setBorder(BorderFactory.createLineBorder(new Color(11315353)));
        panel.setBackground(new Color(0xFFFFE1));
        panel.setOpaque(true);
        panel.add((Component)new LinkButton(SwingUI.newAction(ResourceBundle.getBundle(FormatDialog.class.getName()).getString(mode.key() + ".syntax"), evt -> SwingUI.openURI(ResourceBundle.getBundle(FormatDialog.class.getName()).getString("help.url")))), "h min!");
        return panel;
    }

    private JComponent createExamplesPanel(Mode mode) {
        JPanel panel = new JPanel(new MigLayout("fill, wrap 3"));
        panel.setBorder(BorderFactory.createLineBorder(new Color(11315353)));
        panel.setBackground(new Color(0xFFFFE1));
        for (String format : mode.getSampleExpressions()) {
            LinkButton formatLink = new LinkButton(SwingUI.newAction(format, e -> this.setFormatCode(format)));
            formatLink.setFont(new Font("Monospaced", 0, 11));
            JLabel formatExample = new JLabel("[evaluate]");
            this.addPropertyChangeListener("sample", evt -> SwingUI.newSwingWorker(() -> new ExpressionFileFormat(format).format(this.sample), s -> formatExample.setText((String)s)).execute());
            panel.add(formatLink);
            panel.add(new JLabel("\u2026"));
            panel.add((Component)formatExample, "wmin 150px");
        }
        return panel;
    }

    protected MediaBindingBean restoreSample(Mode mode) {
        String path;
        Object info = null;
        File media = null;
        Map<File, Object> context = null;
        try {
            info = MetaAttributes.toObject(mode.persistentSample().getValue());
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
        }
        if (info == null) {
            info = mode.getDefaultSampleObject();
        }
        if ((path = persistentSampleFile.getValue()) != null && !path.isEmpty()) {
            media = new File(path);
            context = Collections.singletonMap(media, info);
        }
        return new MediaBindingBean(info, media, context);
    }

    private ExecutorService createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new DefaultThreadFactory("PreviewFormatter"));
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        return executor;
    }

    private void checkFormatInBackground() {
        try {
            final ExpressionFileFormat format = new ExpressionFileFormat(this.editor.getText().trim());
            final Timer progressIndicatorTimer = SwingUI.invokeLater(400, () -> this.progressIndicator.setVisible(true));
            RunnableFuture<String> obsoletePreviewFuture = this.currentPreviewFuture;
            this.currentPreviewFuture = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() throws Exception {
                    return format.format(FormatDialog.this.sample);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        FormatDialog.this.preview.setText((String)this.get());
                        if (format.suppressed() != null) {
                            throw format.suppressed();
                        }
                        FormatDialog.this.status.setText(null);
                        FormatDialog.this.status.setVisible(false);
                    }
                    catch (CancellationException cancellationException) {
                        FormatDialog.this.preview.setVisible(FormatDialog.this.preview.getText().trim().length() > 0);
                        FormatDialog.this.editor.setForeground(FormatDialog.this.preview.getForeground());
                        progressIndicatorTimer.stop();
                        if (this == FormatDialog.this.currentPreviewFuture) {
                            FormatDialog.this.progressIndicator.setVisible(false);
                        }
                    }
                    catch (Exception execution) {
                        try {
                            SuppressedThrowables suppressed = ExceptionUtilities.findCause(execution, SuppressedThrowables.class);
                            if (suppressed != null) {
                                BindingException bindingIssue = ExceptionUtilities.findCause(suppressed, BindingException.class);
                                if (bindingIssue != null && ExceptionUtilities.getMessage(bindingIssue).contains("Sample file has not been set. Click \"Change Sample\" to select a sample file.")) {
                                    FormatDialog.this.status.setText(ExceptionUtilities.getMessage(bindingIssue));
                                    FormatDialog.this.status.setIcon(ResourceManager.getIcon("action.variables"));
                                } else if (bindingIssue != null) {
                                    FormatDialog.this.status.setText(ExceptionUtilities.getMessage(bindingIssue));
                                    FormatDialog.this.status.setIcon(ResourceManager.getIcon("status.info"));
                                } else if (suppressed.getCause() != null && suppressed.getCause().getClass() == Exception.class) {
                                    FormatDialog.this.status.setText(execution.getCause().getMessage());
                                    FormatDialog.this.status.setIcon(ResourceManager.getIcon("status.info"));
                                } else {
                                    FormatDialog.this.status.setText(suppressed.getMessage());
                                    FormatDialog.this.status.setIcon(ResourceManager.getIcon("status.warning"));
                                }
                            } else {
                                FormatDialog.this.status.setText(execution.toString());
                                FormatDialog.this.status.setIcon(ResourceManager.getIcon("status.warning"));
                            }
                            FormatDialog.this.status.setVisible(true);
                        }
                        catch (Throwable throwable) {
                            FormatDialog.this.preview.setVisible(FormatDialog.this.preview.getText().trim().length() > 0);
                            FormatDialog.this.editor.setForeground(FormatDialog.this.preview.getForeground());
                            progressIndicatorTimer.stop();
                            if (this == FormatDialog.this.currentPreviewFuture) {
                                FormatDialog.this.progressIndicator.setVisible(false);
                            }
                            throw throwable;
                        }
                        FormatDialog.this.preview.setVisible(FormatDialog.this.preview.getText().trim().length() > 0);
                        FormatDialog.this.editor.setForeground(FormatDialog.this.preview.getForeground());
                        progressIndicatorTimer.stop();
                        if (this == FormatDialog.this.currentPreviewFuture) {
                            FormatDialog.this.progressIndicator.setVisible(false);
                        }
                    }
                    FormatDialog.this.preview.setVisible(FormatDialog.this.preview.getText().trim().length() > 0);
                    FormatDialog.this.editor.setForeground(FormatDialog.this.preview.getForeground());
                    progressIndicatorTimer.stop();
                    if (this == FormatDialog.this.currentPreviewFuture) {
                        FormatDialog.this.progressIndicator.setVisible(false);
                    }
                }
            };
            if (obsoletePreviewFuture != null) {
                obsoletePreviewFuture.cancel(true);
            }
            this.executor.execute(this.currentPreviewFuture);
        }
        catch (ScriptException e) {
            this.status.setText(ExceptionUtilities.getRootCauseMessage(e));
            this.status.setIcon(ResourceManager.getIcon("status.error"));
            this.status.setVisible(true);
            this.preview.setVisible(false);
            this.editor.setForeground(Color.red);
        }
    }

    public boolean submit() {
        return this.submit;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ExpressionFormat getFormat() {
        return this.format;
    }

    private void finish(boolean submit) {
        this.submit = submit;
        this.executor.shutdownNow();
        this.setVisible(false);
        this.dispose();
    }

    private JPopupMenu createRecentFormatPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                this.popupMenuWillBecomeInvisible(evt);
                JPopupMenu popup = (JPopupMenu)evt.getSource();
                for (String expression : FormatDialog.this.mode.persistentFormatHistory()) {
                    JMenuItem item = popup.add(SwingUI.newAction(expression, e -> FormatDialog.this.setFormatCode(expression)));
                    item.setFont(new Font("Monospaced", 0, 11));
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                JPopupMenu popup = (JPopupMenu)evt.getSource();
                popup.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                this.popupMenuWillBecomeInvisible(evt);
            }
        });
        return popup;
    }

    protected void fireSampleChanged() {
        this.firePropertyChange("sample", null, this.sample);
    }

    public static enum Mode {
        Episode,
        Movie,
        Music,
        File;


        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % File.ordinal()];
        }

        public String key() {
            return this.name().toLowerCase();
        }

        public Format getFormat() {
            switch (this) {
                case Episode: {
                    return new EpisodeFormat();
                }
                case Movie: {
                    return new MovieFormat(true, true, false);
                }
                case Music: {
                    return new AudioTrackFormat();
                }
            }
            return new FileNameFormat();
        }

        public PreferencesMap.PreferencesEntry<String> persistentSample() {
            return Settings.forPackage(FormatDialog.class).entry("format.sample." + this.key());
        }

        public PreferencesList<String> persistentFormatHistory() {
            return Settings.forPackage(FormatDialog.class).node("format.recent." + this.key()).asList();
        }

        public Object getDefaultSampleObject() {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(FormatDialog.class.getName());
                String json = bundle.getString(this.key() + ".sample");
                return MetaAttributes.toObject(json);
            }
            catch (MissingResourceException bundle) {
            }
            catch (Exception e) {
                Logging.debug.log(Level.SEVERE, "Illegal Sample", e);
            }
            return null;
        }

        public String getDefaultFormatExpression() {
            return this.getSampleExpressions().iterator().next();
        }

        public Iterable<String> getSampleExpressions() {
            ResourceBundle bundle = ResourceBundle.getBundle(FormatDialog.class.getName());
            TreeMap<String, String> examples = new TreeMap<String, String>();
            String prefix = this.key() + ".example";
            for (String key : bundle.keySet()) {
                if (!key.startsWith(prefix)) continue;
                examples.put(key, bundle.getString(key));
            }
            return examples.values();
        }

        public static Mode getMode(Datasource datasource) {
            if (datasource instanceof MovieIdentificationService) {
                return Movie;
            }
            if (datasource instanceof EpisodeListProvider) {
                return Episode;
            }
            if (datasource instanceof MusicIdentificationService) {
                return Music;
            }
            return File;
        }
    }
}

