/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.filebot.History;
import net.filebot.HistorySpooler;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.UserFiles;
import net.filebot.media.XattrMetaInfo;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.transfer.FileExportHandler;
import net.filebot.ui.transfer.FileTransferablePolicy;
import net.filebot.ui.transfer.LoadAction;
import net.filebot.ui.transfer.SaveAction;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LazyDocumentListener;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.miginfocom.swing.MigLayout;

class HistoryDialog
extends JDialog {
    private final JLabel infoLabel = new JLabel();
    private final JTextField filterEditor = new JTextField();
    private final SequenceTableModel sequenceModel = new SequenceTableModel();
    private final ElementTableModel elementModel = new ElementTableModel();
    private final JTable sequenceTable = this.createTable(this.sequenceModel);
    private final JTable elementTable = this.createTable(this.elementModel);
    private final Action closeAction = new AbstractAction("Close", ResourceManager.getIcon("dialog.continue")){

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryDialog.this.setVisible(false);
            HistoryDialog.this.dispose();
        }
    };
    private final Action clearFilterAction = new AbstractAction("Clear Filter", ResourceManager.getIcon("edit.clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryDialog.this.filterEditor.setText("");
        }
    };
    private final MouseListener contextMenuProvider = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable table = (JTable)e.getSource();
                int clickedRow = table.rowAtPoint(e.getPoint());
                if (clickedRow < 0) {
                    return;
                }
                if (!table.getSelectionModel().isSelectedIndex(clickedRow)) {
                    table.getSelectionModel().setSelectionInterval(clickedRow, clickedRow);
                }
                ArrayList<History.Element> selection = new ArrayList<History.Element>();
                for (int i : table.getSelectedRows()) {
                    int index = table.convertRowIndexToModel(i);
                    if (HistoryDialog.this.sequenceModel == table.getModel()) {
                        selection.addAll(HistoryDialog.this.sequenceModel.getRow(index).elements());
                        continue;
                    }
                    if (HistoryDialog.this.elementModel != table.getModel()) continue;
                    selection.add(HistoryDialog.this.elementModel.getRow(index));
                }
                if (selection.size() > 0) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new RevertSelectionAction(selection));
                    menu.show(table, e.getX(), e.getY());
                }
            }
        }
    };
    private final FileTransferablePolicy importHandler = new FileTransferablePolicy(){

        @Override
        protected boolean accept(List<File> files) {
            return FileUtilities.containsOnly(files, new FileUtilities.ExtensionFileFilter("xml"));
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void load(List<File> files, TransferablePolicy.TransferAction action) throws IOException {
            for (File file : files) {
                try {
                    HistorySpooler.getInstance().append(History.importHistory(new FileInputStream(file)));
                }
                catch (Exception e) {
                    Logging.log.log(Level.SEVERE, "Failed to import history: " + file, e);
                }
            }
            HistoryDialog.this.setModel(HistorySpooler.getInstance().getCompleteHistory());
        }

        @Override
        public String getFileFilterDescription() {
            return "History Files (.xml)";
        }

        @Override
        public List<String> getFileFilterExtensions() {
            return Arrays.asList("xml");
        }
    };
    private final FileExportHandler exportHandler = new FileExportHandler(){

        @Override
        public boolean canExport() {
            return true;
        }

        @Override
        public void export(File file) throws IOException {
            History.exportHistory(HistoryDialog.this.getModel(), new FileOutputStream(file));
        }

        @Override
        public String getDefaultFileName() {
            return "history.xml";
        }
    };

    public HistoryDialog(Window owner) {
        super(owner, "History", Dialog.ModalityType.DOCUMENT_MODAL);
        JLabel title = new JLabel(this.getTitle());
        title.setFont(title.getFont().deriveFont(1));
        JPanel header = new JPanel(new MigLayout("insets dialog, nogrid, fillx"));
        header.setBackground(Color.white);
        header.setBorder(new SeparatorBorder(1, new Color(0xB4B4B4), new Color(0xACACAC), GradientStyle.LEFT_TO_RIGHT, SeparatorBorder.Position.BOTTOM));
        header.add((Component)title, "wrap");
        header.add((Component)this.infoLabel, "gap indent*2, wrap");
        JPanel content = new JPanel(new MigLayout("fill, insets dialog, nogrid, novisualpadding", "", "[pref!][150px:pref:200px][200px:pref:max, grow][pref!]"));
        content.add((Component)new JLabel("Filter:"), "gap indent:push");
        content.add((Component)this.filterEditor, "wmin 120px, gap rel");
        content.add((Component)SwingUI.createImageButton(this.clearFilterAction), "w pref!, h pref!, gap right indent, wrap");
        content.add((Component)this.createScrollPaneGroup("Sequences", this.sequenceTable), "growx, wrap paragraph");
        content.add((Component)this.createScrollPaneGroup("Elements", this.elementTable), "growx, wrap paragraph");
        LoadAction importAction = new LoadAction("Import", ResourceManager.getIcon("action.load"), this::getTransferablePolicy);
        content.add((Component)new JButton(importAction), "wmin button, hmin 25px, gap indent, sg button");
        content.add((Component)new JButton(new SaveAction("Export", ResourceManager.getIcon("action.save"), this.exportHandler)), "gap rel, sg button");
        content.add((Component)new JButton(new RevertCurrentSelectionAction()), "gap left unrel:push, sgy button");
        content.add((Component)new JButton(this.closeAction), "gap left unrel, gap right indent, sg button");
        JComponent pane = (JComponent)this.getContentPane();
        pane.setLayout(new MigLayout("fill, insets 0, nogrid"));
        pane.add((Component)header, "h min!, growx, dock north");
        pane.add((Component)content, "grow");
        this.sequenceTable.setSelectionMode(2);
        this.elementTable.setSelectionMode(2);
        this.sequenceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (HistoryDialog.this.sequenceTable.getSelectedRow() >= 0) {
                    ArrayList<History.Element> elements = new ArrayList<History.Element>();
                    for (int row : HistoryDialog.this.sequenceTable.getSelectedRows()) {
                        elements.addAll(HistoryDialog.this.sequenceModel.getRow(HistoryDialog.this.sequenceTable.convertRowIndexToModel(row)).elements());
                    }
                    HistoryDialog.this.elementModel.setData(elements);
                }
            }
        });
        this.elementTable.getSelectionModel().addListSelectionListener(evt -> {
            if (this.elementTable.getSelectedRow() >= 0) {
                this.sequenceTable.getSelectionModel().clearSelection();
            }
        });
        this.sequenceTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        this.sequenceTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private final DateFormat format = DateFormat.getDateTimeInstance(2, 3);

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, this.format.format(value), isSelected, hasFocus, row, column);
            }
        });
        this.elementTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(null);
                if (column == 1) {
                    if (HistoryDialog.this.elementModel.isBroken(table.convertRowIndexToModel(row))) {
                        this.setIcon(ResourceManager.getIcon("status.link.broken"));
                    } else {
                        this.setIcon(ResourceManager.getIcon("status.link.ok"));
                    }
                }
                return this;
            }
        });
        this.filterEditor.getDocument().addDocumentListener(new LazyDocumentListener(evt -> {
            ArrayList<HistoryFilter> filterList = new ArrayList<HistoryFilter>();
            for (String word : RegularExpressions.SPACE.split(this.filterEditor.getText())) {
                filterList.add(new HistoryFilter(word));
            }
            for (JTable table : Arrays.asList(this.sequenceTable, this.elementTable)) {
                TableRowSorter sorter = (TableRowSorter)table.getRowSorter();
                sorter.setRowFilter(RowFilter.andFilter(filterList));
            }
            if (this.sequenceTable.getSelectedRow() < 0 && this.sequenceTable.getRowCount() > 0) {
                this.sequenceTable.getSelectionModel().addSelectionInterval(0, 0);
            }
        }));
        this.sequenceTable.addMouseListener(this.contextMenuProvider);
        this.elementTable.addMouseListener(this.contextMenuProvider);
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setResizable(true);
        this.setSize(580, 640);
    }

    public void setModel(History history) {
        this.sequenceModel.setData(history.sequences());
        if (this.sequenceTable.getRowCount() > 0) {
            this.sequenceTable.getSelectionModel().addSelectionInterval(0, 0);
        } else {
            this.elementModel.setData(new ArrayList<History.Element>(0));
        }
        this.initializeInfoLabel();
    }

    public History getModel() {
        return new History(this.sequenceModel.getData());
    }

    public JLabel getInfoLabel() {
        return this.infoLabel;
    }

    private void initializeInfoLabel() {
        int count = 0;
        Date since = new Date();
        for (History.Sequence sequence : this.sequenceModel.getData()) {
            count += sequence.elements().size();
            if (!sequence.date().before(since)) continue;
            since = sequence.date();
        }
        this.infoLabel.setText(String.format("A total of %,d files have been renamed since %s.", count, DateFormat.getDateInstance().format(since)));
    }

    private JScrollPane createScrollPaneGroup(String title, JComponent component) {
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setBorder(new CompoundBorder(new TitledBorder(title), scrollPane.getBorder()));
        if (Settings.isMacApp()) {
            scrollPane.setOpaque(false);
        }
        return scrollPane;
    }

    private JTable createTable(TableModel model) {
        JTable table = new JTable(model);
        table.setBackground(Color.white);
        table.setAutoCreateRowSorter(true);
        table.setFillsViewportHeight(true);
        table.setShowGrid(false);
        table.setIntercellSpacing(new Dimension(0, 0));
        DefaultTableColumnModel m = (DefaultTableColumnModel)table.getColumnModel();
        m.getColumn(0).setMaxWidth(50);
        return table;
    }

    public TransferablePolicy getTransferablePolicy() {
        return this.importHandler;
    }

    private static class ElementTableModel
    extends AbstractTableModel {
        private List<History.Element> data = Collections.emptyList();

        private ElementTableModel() {
        }

        public void setData(List<History.Element> data) {
            this.data = new ArrayList<History.Element>(data);
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "New Name";
                }
                case 2: {
                    return "Original Name";
                }
                case 3: {
                    return "New Folder";
                }
                case 4: {
                    return "Original Folder";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return File.class;
                }
                case 4: {
                    return File.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return new File(this.data.get(row).to()).getName();
                }
                case 2: {
                    return this.data.get(row).from();
                }
                case 3: {
                    return new File(this.data.get(row).to()).getParentFile();
                }
                case 4: {
                    return this.data.get(row).dir();
                }
            }
            return null;
        }

        public History.Element getRow(int row) {
            return this.data.get(row);
        }

        public boolean isBroken(int row) {
            History.Element element = this.data.get(row);
            File file = new File(element.to());
            if (!file.isAbsolute()) {
                file = new File(element.dir(), file.getPath());
            }
            return !file.exists();
        }
    }

    private static class SequenceTableModel
    extends AbstractTableModel {
        private List<History.Sequence> data = Collections.emptyList();

        private SequenceTableModel() {
        }

        public void setData(List<History.Sequence> data) {
            this.data = new ArrayList<History.Sequence>(data);
            this.fireTableDataChanged();
        }

        public List<History.Sequence> getData() {
            return Collections.unmodifiableList(this.data);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "#";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Date";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Date.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return this.getName(this.data.get(row));
                }
                case 2: {
                    return this.data.get(row).date();
                }
            }
            return null;
        }

        public History.Sequence getRow(int row) {
            return this.data.get(row);
        }

        private String getName(History.Sequence sequence) {
            StringBuilder sb = new StringBuilder();
            for (History.Element element : sequence.elements()) {
                String name = element.dir().getName();
                if (sb.indexOf(name) >= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(name);
            }
            return sb.toString();
        }
    }

    private static class HistoryFilter
    extends RowFilter<Object, Integer> {
        private final Pattern filter;

        public HistoryFilter(String filter) {
            this.filter = Pattern.compile(Pattern.quote(filter), 386);
        }

        @Override
        public boolean include(RowFilter.Entry<?, ? extends Integer> entry) {
            if (entry.getModel() instanceof SequenceTableModel) {
                SequenceTableModel model = (SequenceTableModel)entry.getModel();
                for (History.Element element : model.getRow(entry.getIdentifier()).elements()) {
                    if (!this.include(element)) continue;
                    return true;
                }
                return false;
            }
            if (entry.getModel() instanceof ElementTableModel) {
                ElementTableModel model = (ElementTableModel)entry.getModel();
                return this.include(model.getRow(entry.getIdentifier()));
            }
            throw new IllegalArgumentException("Illegal model: " + entry.getModel());
        }

        private boolean include(History.Element element) {
            return this.include(element.to()) || this.include(element.from()) || this.include(element.dir().getPath());
        }

        private boolean include(String value) {
            return this.filter.matcher(value).find();
        }
    }

    private static abstract class RevertAction
    extends AbstractAction {
        public static final String PARENT = "parent";

        public RevertAction(String name, HistoryDialog parent) {
            this.putValue("Name", name);
            this.putValue("SmallIcon", ResourceManager.getIcon("action.revert"));
            this.putValue(PARENT, parent);
        }

        public abstract List<History.Element> elements();

        public HistoryDialog parent() {
            return (HistoryDialog)this.getValue(PARENT);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            List<History.Element> elements = this.elements();
            if (elements.isEmpty()) {
                return;
            }
            File directory = null;
            Option selectedOption = Option.ChangeDirectory;
            while (selectedOption == Option.ChangeDirectory) {
                EnumSet<Option> options;
                int type;
                Object[] message;
                List<File> missingFiles = this.getMissingFiles(directory);
                if (missingFiles.isEmpty()) {
                    message = String.format("Are you sure you want to revert %d file(s)?", elements.size());
                    type = 3;
                    options = EnumSet.of(Option.Revert, Option.ChangeDirectory, Option.Cancel);
                } else {
                    String text = "Some files are missing. Please select a different directory.";
                    JList missingFilesComponent = new JList(missingFiles.toArray()){

                        @Override
                        public Dimension getPreferredScrollableViewportSize() {
                            return new Dimension(80, 80);
                        }
                    };
                    missingFilesComponent.setCellRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            return super.getListCellRendererComponent((JList<?>)list, ((File)value).getName(), index, isSelected, false);
                        }
                    });
                    message = new Object[]{text, new JScrollPane(missingFilesComponent)};
                    type = -1;
                    options = EnumSet.of(Option.ChangeDirectory, Option.Cancel);
                }
                JOptionPane pane = new JOptionPane(message, type, 1, null, options.toArray(), (Object)Option.Cancel);
                pane.createDialog(this.parent(), "Revert").setVisible(true);
                selectedOption = (Option)((Object)pane.getValue());
                if (selectedOption != Option.ChangeDirectory) continue;
                directory = UserFiles.showOpenDialogSelectFolder(directory, selectedOption.toString(), evt);
            }
            if (selectedOption == Option.Revert) {
                this.revert(directory, elements);
            }
        }

        private void revert(File directory, List<History.Element> elements) {
            Map<File, File> renamePlan = this.getRenameMap(directory);
            if (Settings.isMacSandbox() && !MacAppUtilities.askUnlockFolders(this.parent(), Stream.of(renamePlan.keySet(), renamePlan.values()).flatMap(c -> c.stream()).collect(Collectors.toList()))) {
                return;
            }
            int count = 0;
            try {
                for (Map.Entry<File, File> entry : renamePlan.entrySet()) {
                    File original = StandardRenameAction.revert(entry.getKey(), entry.getValue());
                    ++count;
                    XattrMetaInfo.xattr.clear(original);
                }
            }
            catch (Exception e) {
                Logging.log.log(Level.WARNING, "Failed to revert files: " + e.getMessage(), e);
            }
            JLabel status = this.parent().getInfoLabel();
            if (count == elements.size()) {
                status.setText(String.format("%d file(s) have been reverted.", count));
                status.setIcon(ResourceManager.getIcon("status.ok"));
            } else {
                status.setText(String.format("%d of %d file(s) have been reverted.", count, elements.size()));
                status.setIcon(ResourceManager.getIcon("status.error"));
            }
            this.parent().repaint();
        }

        private Map<File, File> getRenameMap(File directory) {
            LinkedHashMap<File, File> renameMap = new LinkedHashMap<File, File>();
            for (History.Element element : this.elements()) {
                File dir = directory != null ? directory : element.dir();
                File from = new File(element.to());
                File to = new File(element.from());
                if (!from.isAbsolute()) {
                    from = new File(dir, directory == null ? from.getPath() : from.getName());
                }
                if (!to.isAbsolute()) {
                    to = new File(dir, directory == null ? to.getPath() : to.getName());
                }
                renameMap.put(from, to);
            }
            return renameMap;
        }

        private List<File> getMissingFiles(File directory) {
            ArrayList<File> missingFiles = new ArrayList<File>();
            for (File file : this.getRenameMap(directory).keySet()) {
                if (file.exists()) continue;
                missingFiles.add(file);
            }
            return missingFiles;
        }

        private static enum Option {
            Revert,
            ChangeDirectory,
            Cancel;


            public String toString() {
                switch (this) {
                    case Revert: {
                        return "Revert";
                    }
                    case ChangeDirectory: {
                        return "Change Directory";
                    }
                }
                return "Cancel";
            }
        }
    }

    private class RevertSelectionAction
    extends RevertAction {
        public static final String ELEMENTS = "elements";

        public RevertSelectionAction(Collection<History.Element> elements) {
            super("Revert...", HistoryDialog.this);
            this.putValue(ELEMENTS, elements.toArray(new History.Element[0]));
        }

        @Override
        public List<History.Element> elements() {
            return Arrays.asList((History.Element[])this.getValue(ELEMENTS));
        }
    }

    private class RevertCurrentSelectionAction
    extends RevertAction {
        public RevertCurrentSelectionAction() {
            super("Revert Selection", HistoryDialog.this);
        }

        @Override
        public List<History.Element> elements() {
            ArrayList<History.Element> selection;
            block3: {
                block2: {
                    selection = new ArrayList<History.Element>();
                    if (HistoryDialog.this.sequenceTable.getSelectedRow() < 0) break block2;
                    for (int i : HistoryDialog.this.sequenceTable.getSelectedRows()) {
                        int index = HistoryDialog.this.sequenceTable.convertRowIndexToModel(i);
                        selection.addAll(HistoryDialog.this.sequenceModel.getRow(index).elements());
                    }
                    break block3;
                }
                if (HistoryDialog.this.elementTable.getSelectedRow() < 0) break block3;
                for (int i : HistoryDialog.this.elementTable.getSelectedRows()) {
                    int index = HistoryDialog.this.elementTable.convertRowIndexToModel(i);
                    selection.add(HistoryDialog.this.elementModel.getRow(index));
                }
            }
            return selection;
        }
    }
}

