/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.filebot.similarity.Match;

public class MatchModel<Value, Candidate> {
    private final EventList<Match<Value, Candidate>> source = new BasicEventList<Match<Value, Candidate>>();
    private final EventList<Value> values = new MatchView<Value, Candidate>((EventList)this.source){

        @Override
        public Value getElement(Match<Value, Candidate> match) {
            return match.getValue();
        }

        @Override
        public Candidate getComplement(Match<Value, Candidate> match) {
            return match.getCandidate();
        }

        @Override
        public Match<Value, Candidate> createMatch(Value element, Candidate complement) {
            return new Match(element, complement);
        }
    };
    private final EventList<Candidate> candidates = new MatchView<Candidate, Value>((EventList)this.source){

        @Override
        public Candidate getElement(Match<Value, Candidate> match) {
            return match.getCandidate();
        }

        @Override
        public Value getComplement(Match<Value, Candidate> match) {
            return match.getValue();
        }

        @Override
        public Match<Value, Candidate> createMatch(Candidate element, Value complement) {
            return new Match(complement, element);
        }
    };

    public void clear() {
        this.source.clear();
    }

    public int size() {
        return this.source.size();
    }

    public Match<Value, Candidate> getMatch(int index) {
        return (Match)this.source.get(index);
    }

    public boolean hasComplement(int index) {
        if (index >= 0 && index < this.size()) {
            return ((Match)this.source.get(index)).getValue() != null && ((Match)this.source.get(index)).getCandidate() != null;
        }
        return false;
    }

    public EventList<Match<Value, Candidate>> matches() {
        return this.source;
    }

    public EventList<Value> values() {
        return this.values;
    }

    public EventList<Candidate> candidates() {
        return this.candidates;
    }

    public void addAll(Collection<Match<Value, Candidate>> matches) {
        this.source.addAll(matches);
    }

    public void addAll(Collection<Value> values, Collection<Candidate> candidates) {
        if (this.values.size() != this.candidates.size()) {
            throw new IllegalStateException("Existing matches are not balanced");
        }
        Iterator<Value> valueIterator = values.iterator();
        Iterator<Candidate> candidateIterator = candidates.iterator();
        while (valueIterator.hasNext() || candidateIterator.hasNext()) {
            Object value = valueIterator.hasNext() ? (Object)valueIterator.next() : null;
            Object candidate = candidateIterator.hasNext() ? (Object)candidateIterator.next() : null;
            this.source.add(new Match<Object, Object>(value, candidate));
        }
    }

    private abstract class MatchView<Element, Complement>
    extends TransformedList<Match<Value, Candidate>, Element> {
        private int size;

        public MatchView(EventList<Match<Value, Candidate>> source) {
            super(source);
            this.size = 0;
            source.addListEventListener(this);
        }

        public abstract Element getElement(Match<Value, Candidate> var1);

        public abstract Complement getComplement(Match<Value, Candidate> var1);

        public abstract Match<Value, Candidate> createMatch(Element var1, Complement var2);

        @Override
        public Element get(int index) {
            return this.getElement(index);
        }

        public Element getElement(int index) {
            return this.getElement((Match)this.source.get(index));
        }

        public Complement getComplement(int index) {
            return this.getComplement((Match)this.source.get(index));
        }

        @Override
        public boolean addAll(Collection<? extends Element> values) {
            return this.put(this.size(), values);
        }

        @Override
        public boolean add(Element value) {
            return this.put(this.size(), Collections.singleton(value));
        }

        @Override
        public void add(int index, Element value) {
            ArrayList<Object> range = new ArrayList<Object>();
            range.add(value);
            range.addAll(this.subList(index, this.size()));
            this.put(index, range);
        }

        @Override
        public Element remove(int index) {
            Element old = this.getElement(index);
            int lastIndex = this.size() - 1;
            this.put(index, new ArrayList(this.subList(index + 1, lastIndex + 1)));
            if (this.getComplement(lastIndex) == null) {
                this.source.remove(lastIndex);
            } else {
                this.set(lastIndex, (Element)null);
            }
            return old;
        }

        @Override
        public Element set(int index, Element element) {
            Element old = this.getElement(index);
            this.source.set(index, this.createMatch(element, this.getComplement(index)));
            return old;
        }

        @Override
        public void clear() {
            for (int i = this.size() - 1; i >= 0; --i) {
                Complement complement = this.getComplement(i);
                if (complement != null) {
                    this.source.set(i, this.createMatch(null, complement));
                    continue;
                }
                this.source.remove(i);
            }
        }

        private boolean put(int index, Collection<? extends Element> elements) {
            for (Element element : elements) {
                if (index < this.source.size()) {
                    this.set(index, element);
                } else {
                    this.source.add(index, this.createMatch(element, null));
                }
                ++index;
            }
            return true;
        }

        @Override
        protected boolean isWritable() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void listChanged(ListEvent<Match<Value, Candidate>> listChanges) {
            this.updates.beginEvent(true);
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                if (type == 2 || type == 1) {
                    if (index < this.size) {
                        if (index == this.size - 1 && this.getElement(index) == null) {
                            this.updates.elementDeleted(index, null);
                            --this.size;
                            continue;
                        }
                        this.updates.elementUpdated(index, null, this.getElement(index));
                        continue;
                    }
                    if (index != this.size || this.getElement(index) == null) continue;
                    this.updates.elementInserted(index, this.getElement(index));
                    ++this.size;
                    continue;
                }
                if (type != 0 || index >= this.size) continue;
                this.updates.elementDeleted(index, null);
                --this.size;
            }
            this.updates.commitEvent();
        }
    }
}

