/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.MediaTypes;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationFileReader;
import net.filebot.hash.VerificationUtilities;
import net.filebot.torrent.Torrent;
import net.filebot.ui.transfer.ArrayTransferable;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.FileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FastFile;
import net.filebot.util.FileUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.vfs.SimpleFileInfo;
import net.filebot.web.Episode;

class NamesListTransferablePolicy
extends FileTransferablePolicy {
    private static final DataFlavor episodeArrayFlavor = ArrayTransferable.flavor(Episode.class);
    private final List<Object> model;

    public NamesListTransferablePolicy(List<Object> model) {
        this.model = model;
    }

    @Override
    protected void clear() {
        this.model.clear();
    }

    @Override
    public boolean accept(Transferable tr) throws Exception {
        return FileTransferable.hasFileListFlavor(tr) || tr.isDataFlavorSupported(DataFlavor.stringFlavor) || tr.isDataFlavorSupported(episodeArrayFlavor);
    }

    @Override
    protected boolean accept(List<File> files) {
        return true;
    }

    @Override
    public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
        if (action == TransferablePolicy.TransferAction.PUT) {
            this.clear();
        }
        if (tr.isDataFlavorSupported(episodeArrayFlavor)) {
            this.model.addAll(Arrays.asList((Episode[])tr.getTransferData(episodeArrayFlavor)));
        } else if (FileTransferable.hasFileListFlavor(tr)) {
            this.load(FileTransferable.getFilesFromTransferable(tr), action);
        } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.load(tr.getTransferData(DataFlavor.stringFlavor).toString());
        }
    }

    protected void load(String string) {
        List values = RegularExpressions.NEWLINE.splitAsStream(string).map(String::trim).filter(s -> s.length() > 0).map(s -> FileUtilities.normalizePathSeparators(s)).collect(Collectors.toList());
        this.model.addAll(values);
    }

    @Override
    protected void load(List<File> files, TransferablePolicy.TransferAction action) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        if (FileUtilities.containsOnly(files, MediaTypes.LIST_FILES)) {
            this.loadListFiles(files, values);
        } else if (FileUtilities.containsOnly(files, MediaTypes.VERIFICATION_FILES)) {
            this.loadVerificationFiles(files, values);
        } else if (FileUtilities.containsOnly(files, MediaTypes.TORRENT_FILES)) {
            this.loadTorrentFiles(files, values);
        } else {
            FileUtilities.listFiles(files, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER).stream().map(FastFile::new).forEach(values::add);
        }
        this.model.addAll(values);
    }

    protected void loadListFiles(List<File> files, List<Object> values) throws IOException {
        for (File file : files) {
            Scanner scanner = new Scanner(FileUtilities.createTextReader(file));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() <= 0) continue;
                values.add(line);
            }
            scanner.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadVerificationFiles(List<File> files, List<Object> values) throws IOException {
        for (File verificationFile : files) {
            HashType type = VerificationUtilities.getHashType(verificationFile);
            if (type == null) continue;
            try (VerificationFileReader parser = new VerificationFileReader(FileUtilities.createTextReader(verificationFile), type.getFormat());){
                while (parser.hasNext()) {
                    values.add(new SimpleFileInfo(((File)parser.next().getKey()).getName(), -1L));
                }
            }
        }
    }

    protected void loadTorrentFiles(List<File> files, List<Object> values) throws IOException {
        for (File file : files) {
            Torrent torrent = new Torrent(file);
            values.addAll(torrent.getFiles());
        }
    }

    @Override
    public String getFileFilterDescription() {
        return "Text Files, Verification Files, Torrent Files";
    }

    @Override
    public List<String> getFileFilterExtensions() {
        return Stream.of(MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES, MediaTypes.AUDIO_FILES, MediaTypes.LIST_FILES, MediaTypes.TORRENT_FILES, MediaTypes.VERIFICATION_FILES).map(FileUtilities.ExtensionFileFilter::extensions).flatMap(Stream::of).collect(Collectors.toList());
    }
}

