/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.CachedResource;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.WebServices;
import net.filebot.format.ExpressionFileFilter;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.ExpressionFilter;
import net.filebot.format.ExpressionFormat;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.ui.rename.EpisodeListMatcher;
import net.filebot.ui.rename.MovieMatcher;
import net.filebot.ui.rename.MusicMatcher;
import net.filebot.ui.rename.PhotoFileMatcher;
import net.filebot.ui.rename.PlainFileMatcher;
import net.filebot.ui.rename.XattrFileMatcher;
import net.filebot.util.FileUtilities;
import net.filebot.web.Datasource;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.SortOrder;

public class Preset {
    public String name;
    public String path;
    public String includes;
    public String format;
    public String database;
    public String sortOrder;
    public String matchMode;
    public String language;
    public String action;

    public Preset(String name, File path, ExpressionFilter includes, ExpressionFormat format, Datasource database, SortOrder sortOrder, String matchMode, Language language, StandardRenameAction action) {
        this.name = name;
        this.path = path == null ? null : path.getPath();
        this.includes = includes == null ? null : includes.getExpression();
        this.format = format == null ? null : format.getExpression();
        this.database = database == null ? null : database.getIdentifier();
        this.sortOrder = sortOrder == null ? null : sortOrder.name();
        this.matchMode = matchMode == null ? null : matchMode;
        this.language = language == null ? null : language.getCode();
        this.action = action == null ? null : action.name();
    }

    public String getName() {
        return this.name;
    }

    public File getInputFolder() {
        return this.getValue(this.path, File::new);
    }

    public ExpressionFileFilter getIncludeFilter() {
        return this.getInputFolder() == null ? null : this.getValue(this.includes, expression -> new ExpressionFileFilter((String)expression));
    }

    public ExpressionFileFormat getFormat() {
        return this.getValue(this.format, ExpressionFileFormat::new);
    }

    public String getMatchMode() {
        return this.getValue(this.matchMode, mode -> mode);
    }

    public SortOrder getSortOrder() {
        return this.getValue(this.sortOrder, SortOrder::forName);
    }

    public Language getLanguage() {
        return this.getValue(this.language, Language::getLanguage);
    }

    public StandardRenameAction getRenameAction() {
        return this.getValue(this.action, StandardRenameAction::forName);
    }

    public Datasource getDatasource() {
        return this.getValue(this.database, id -> WebServices.getService((String)id, (Datasource[])Preset.getSupportedServices()));
    }

    public Icon getIcon() {
        return this.getValue(this.database, id -> WebServices.getService((String)id, (Datasource[])Preset.getSupportedServices()).getIcon());
    }

    private <T> T getValue(String s, CachedResource.Transform<String, T> t) {
        try {
            return s == null || s.isEmpty() ? null : (T)t.transform(s);
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
            return null;
        }
    }

    public List<File> selectFiles() {
        File folder = this.getInputFolder();
        if (folder == null || !folder.isDirectory()) {
            return Collections.emptyList();
        }
        ExpressionFileFilter filter = this.getIncludeFilter();
        return FileUtilities.listFiles(folder, filter == null ? FileUtilities.FILES : f -> FileUtilities.FILES.accept(f) && filter.accept(f), FileUtilities.HUMAN_NAME_ORDER);
    }

    public AutoCompleteMatcher getAutoCompleteMatcher() {
        Datasource db = this.getDatasource();
        if (db instanceof MovieIdentificationService) {
            return new MovieMatcher((MovieIdentificationService)db);
        }
        if (db instanceof EpisodeListProvider) {
            return new EpisodeListMatcher((EpisodeListProvider)db, db == WebServices.AniDB);
        }
        if (db instanceof MusicIdentificationService) {
            return new MusicMatcher((MusicIdentificationService)db);
        }
        if (db instanceof AutoCompleteMatcher) {
            return (AutoCompleteMatcher)((Object)db);
        }
        throw new IllegalStateException("Illegal datasource: " + db);
    }

    public String toString() {
        return this.name;
    }

    public static Datasource[] getSupportedServices() {
        return (Datasource[])Stream.of(WebServices.getEpisodeListProviders(), WebServices.getMovieIdentificationServices(), WebServices.getMusicIdentificationServices(), Preset.getGenericFileMatcherServices()).flatMap(Stream::of).toArray(Datasource[]::new);
    }

    public static Datasource[] getGenericFileMatcherServices() {
        return new Datasource[]{new PhotoFileMatcher(), new XattrFileMatcher(), new PlainFileMatcher()};
    }

    public static StandardRenameAction[] getSupportedActions() {
        if (Settings.isWindowsApp()) {
            return new StandardRenameAction[]{StandardRenameAction.MOVE, StandardRenameAction.COPY, StandardRenameAction.KEEPLINK, StandardRenameAction.SYMLINK, StandardRenameAction.HARDLINK};
        }
        return new StandardRenameAction[]{StandardRenameAction.MOVE, StandardRenameAction.COPY, StandardRenameAction.KEEPLINK, StandardRenameAction.SYMLINK, StandardRenameAction.HARDLINK, StandardRenameAction.CLONE};
    }

    public static Language[] getSupportedLanguages() {
        return (Language[])Stream.of(Language.preferredLanguages(), Language.availableLanguages()).flatMap(Collection::stream).toArray(Language[]::new);
    }

    public static String[] getSupportedMatchModes() {
        return new String[]{"Opportunistic", "Strict"};
    }
}

