/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.filebot.ResourceManager;
import net.filebot.ui.FileBotList;
import net.filebot.ui.transfer.LoadAction;
import net.filebot.util.ui.ActionPopup;
import net.filebot.util.ui.PrototypeCellValueUpdater;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

class RenameList<E>
extends FileBotList<E> {
    private JPanel buttonPanel;
    private final LoadAction loadAction = new LoadAction(this::getTransferablePolicy);
    private final Action upAction = SwingUI.newAction("Align Up", ResourceManager.getIcon("action.up"), evt -> {
        int index = this.getListComponent().getSelectedIndex();
        if (index > 0) {
            Collections.swap(this.model, index, index - 1);
            this.getListComponent().setSelectedIndex(index - 1);
        }
    });
    private final Action downAction = SwingUI.newAction("Align Down", ResourceManager.getIcon("action.down"), evt -> {
        int index = this.getListComponent().getSelectedIndex();
        if (index < this.model.size() - 1) {
            Collections.swap(this.model, index, index + 1);
            this.getListComponent().setSelectedIndex(index + 1);
        }
    });
    private final MouseAdapter dndReorderMouseAdapter = new MouseAdapter(){
        private int lastIndex = -1;

        @Override
        public void mousePressed(MouseEvent m) {
            this.lastIndex = RenameList.this.getListComponent().getSelectedIndex();
        }

        @Override
        public void mouseDragged(MouseEvent m) {
            int currentIndex = RenameList.this.getListComponent().getSelectedIndex();
            if (currentIndex != this.lastIndex && this.lastIndex >= 0 && currentIndex >= 0) {
                Collections.swap(RenameList.this.model, this.lastIndex, currentIndex);
                this.lastIndex = currentIndex;
            }
        }
    };

    public RenameList(EventList<E> model) {
        this.setModel(model);
        this.list.setSelectionMode(0);
        this.list.setFixedCellHeight(28);
        this.list.getModel().addListDataListener(new PrototypeCellValueUpdater<String>(this.list, ""));
        this.list.addMouseListener(this.dndReorderMouseAdapter);
        this.list.addMouseMotionListener(this.dndReorderMouseAdapter);
        this.getRemoveAction().setEnabled(true);
        this.buttonPanel = new JPanel(new MigLayout("insets 1.2mm, nogrid, novisualpadding, fill", "align center"));
        this.buttonPanel.add((Component)SwingUI.createImageButton(this.downAction), "sgy button");
        this.buttonPanel.add((Component)SwingUI.createImageButton(this.upAction), "gap 0, sgy button");
        this.buttonPanel.add((Component)this.createLoadButton(), "gap 10px, sgy button");
        this.add((Component)this.buttonPanel, "South");
        this.listScrollPane.getViewport().setBackground(this.list.getBackground());
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private JButton createLoadButton() {
        ActionPopup actionPopup = new ActionPopup("Load Files", ResourceManager.getIcon("action.load"));
        actionPopup.add(SwingUI.newAction("Select Folders", ResourceManager.getIcon("tree.closed"), evt -> this.loadAction.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), evt.getActionCommand(), 0))));
        actionPopup.add(SwingUI.newAction("Select Files", ResourceManager.getIcon("file.generic"), evt -> this.loadAction.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), evt.getActionCommand(), 1))));
        JButton button = new JButton(this.loadAction);
        button.setComponentPopupMenu(actionPopup);
        return button;
    }
}

