/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.CallSite;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import net.filebot.ApplicationFolder;
import net.filebot.History;
import net.filebot.HistorySpooler;
import net.filebot.InvalidResponseException;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.StandardRenameAction;
import net.filebot.UserFiles;
import net.filebot.WebServices;
import net.filebot.format.ExpressionFileFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.MediaDetection;
import net.filebot.media.MetaAttributes;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.similarity.Match;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.ui.rename.AutoDetectMatcher;
import net.filebot.ui.rename.EpisodeListMatcher;
import net.filebot.ui.rename.ExpressionFormatter;
import net.filebot.ui.rename.FileNameFormat;
import net.filebot.ui.rename.FileNameFormatter;
import net.filebot.ui.rename.FilesListTransferablePolicy;
import net.filebot.ui.rename.FormatDialog;
import net.filebot.ui.rename.HistoryDialog;
import net.filebot.ui.rename.MatchAction;
import net.filebot.ui.rename.MatchFormatter;
import net.filebot.ui.rename.MovieFormatter;
import net.filebot.ui.rename.MovieMatcher;
import net.filebot.ui.rename.MusicMatcher;
import net.filebot.ui.rename.NamesListTransferablePolicy;
import net.filebot.ui.rename.Preset;
import net.filebot.ui.rename.PresetEditor;
import net.filebot.ui.rename.RenameAction;
import net.filebot.ui.rename.RenameList;
import net.filebot.ui.rename.RenameListCellRenderer;
import net.filebot.ui.rename.RenameModel;
import net.filebot.ui.rename.ScrollPaneSynchronizer;
import net.filebot.ui.transfer.BackgroundFileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.AlphanumComparator;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.PreferencesMap;
import net.filebot.util.ui.ActionPopup;
import net.filebot.util.ui.DefaultFancyListCellRenderer;
import net.filebot.util.ui.LoadingOverlayPane;
import net.filebot.util.ui.SwingUI;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;
import net.filebot.web.AudioTrack;
import net.filebot.web.AudioTrackFormat;
import net.filebot.web.Datasource;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.Movie;
import net.filebot.web.MovieFormat;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.SortOrder;
import net.miginfocom.swing.MigLayout;

public class RenamePanel
extends JComponent {
    public static final String MATCH_MODE_OPPORTUNISTIC = "Opportunistic";
    public static final String MATCH_MODE_STRICT = "Strict";
    protected final RenameModel renameModel = new RenameModel();
    protected final RenameList<RenameModel.FormattedFuture> namesList = new RenameList<RenameModel.FormattedFuture>(this.renameModel.names());
    protected final RenameList<File> filesList = new RenameList<File>(this.renameModel.files());
    protected final MatchAction matchAction = new MatchAction(this.renameModel);
    protected final RenameAction renameAction = new RenameAction(this.renameModel);
    private static final PreferencesMap.PreferencesEntry<String> persistentEpisodeFormat = Settings.forPackage(RenamePanel.class).entry("rename.format.episode");
    private static final PreferencesMap.PreferencesEntry<String> persistentMovieFormat = Settings.forPackage(RenamePanel.class).entry("rename.format.movie");
    private static final PreferencesMap.PreferencesEntry<String> persistentMusicFormat = Settings.forPackage(RenamePanel.class).entry("rename.format.music");
    private static final PreferencesMap.PreferencesEntry<String> persistentFileFormat = Settings.forPackage(RenamePanel.class).entry("rename.format.file");
    private static final PreferencesMap.PreferencesEntry<String> persistentLastFormatState = Settings.forPackage(RenamePanel.class).entry("rename.last.format.state").defaultValue(FormatDialog.Mode.Episode.name());
    private static final PreferencesMap.PreferencesEntry<String> persistentPreferredMatchMode = Settings.forPackage(RenamePanel.class).entry("rename.match.mode").defaultValue("Opportunistic");
    private static final PreferencesMap.PreferencesEntry<String> persistentPreferredLanguage = Settings.forPackage(RenamePanel.class).entry("rename.language").defaultValue("en");
    private static final PreferencesMap.PreferencesEntry<String> persistentPreferredEpisodeOrder = Settings.forPackage(RenamePanel.class).entry("rename.episode.order").defaultValue("Airdate");
    private static final Map<String, Preset> persistentPresets = Settings.forPackage(RenamePanel.class).node("presets").asMap(Preset.class);
    private final Action clearFilesAction = SwingUI.newAction("Clear All", ResourceManager.getIcon("action.clear"), evt -> {
        if (SwingUI.isShiftOrAltDown(evt)) {
            this.renameModel.files().clear();
        } else {
            this.renameModel.clear();
        }
    });
    private final Action openHistoryAction = SwingUI.newAction("Open History", ResourceManager.getIcon("action.report"), evt -> {
        try {
            History model = HistorySpooler.getInstance().getCompleteHistory();
            HistoryDialog dialog = new HistoryDialog(SwingUI.getWindow(this));
            dialog.setLocationRelativeTo(this);
            dialog.setModel(model);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e, Logging.cause(ExceptionUtilities.getRootCause(e)));
        }
    });

    public RenamePanel() {
        this.namesList.setTitle("New Names");
        this.namesList.setTransferablePolicy(new NamesListTransferablePolicy(this.renameModel.values()));
        this.filesList.setTitle("Original Files");
        this.filesList.setTransferablePolicy(new FilesListTransferablePolicy(this.renameModel.files()));
        this.matchAction.setMatchMode(this.isMatchModeStrict());
        try {
            this.renameModel.useFormatter(Episode.class, new ExpressionFormatter(persistentEpisodeFormat.getValue(), (Format)EpisodeFormat.SeasonEpisode, Episode.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.renameModel.useFormatter(Movie.class, new ExpressionFormatter(persistentMovieFormat.getValue(), (Format)MovieFormat.NameYear, Movie.class));
        }
        catch (Exception e) {
            this.renameModel.useFormatter(Movie.class, new MovieFormatter());
        }
        try {
            this.renameModel.useFormatter(AudioTrack.class, new ExpressionFormatter(persistentMusicFormat.getValue(), (Format)new AudioTrackFormat(), AudioTrack.class));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.renameModel.useFormatter(File.class, new ExpressionFormatter(persistentFileFormat.getValue(), (Format)new FileNameFormat(), File.class));
        }
        catch (Exception e) {
            this.renameModel.useFormatter(File.class, new FileNameFormatter());
        }
        finally {
            this.renameModel.useFormatter(FileInfo.class, new FileNameFormatter());
        }
        RenameListCellRenderer cellrenderer = new RenameListCellRenderer(this.renameModel, ApplicationFolder.UserHome.get());
        this.namesList.getListComponent().setCellRenderer(cellrenderer);
        this.filesList.getListComponent().setCellRenderer(cellrenderer);
        DefaultEventSelectionModel selectionModel = new DefaultEventSelectionModel(this.renameModel.matches());
        selectionModel.setSelectionMode(0);
        this.namesList.getListComponent().setSelectionModel(selectionModel);
        this.filesList.getListComponent().setSelectionModel(selectionModel);
        new ScrollPaneSynchronizer(this.namesList, this.filesList);
        Action removeAction = SwingUI.newAction("Exclude Selected Items", ResourceManager.getIcon("dialog.cancel"), evt -> {
            boolean deleteCell;
            RenameList list = null;
            if (evt.getSource() instanceof JButton) {
                list = this.filesList;
                deleteCell = SwingUI.isShiftOrAltDown(evt);
            } else {
                list = (RenameList)evt.getSource();
                deleteCell = SwingUI.isShiftOrAltDown(evt);
            }
            int index = list.getListComponent().getSelectedIndex();
            if (index >= 0) {
                if (deleteCell) {
                    EventList eventList = list.getModel();
                    if (index < eventList.size()) {
                        list.getModel().remove(index);
                    }
                } else {
                    this.renameModel.matches().remove(index);
                }
                int maxIndex = list.getModel().size() - 1;
                if (index > maxIndex) {
                    index = maxIndex;
                }
                if (index >= 0) {
                    list.getListComponent().setSelectedIndex(index);
                }
            }
        });
        this.namesList.setRemoveAction(removeAction);
        this.filesList.setRemoveAction(removeAction);
        JButton matchButton = new JButton(this.matchAction);
        matchButton.setVerticalTextPosition(3);
        matchButton.setHorizontalTextPosition(0);
        JButton renameButton = new JButton(this.renameAction);
        renameButton.setVerticalTextPosition(3);
        renameButton.setHorizontalTextPosition(0);
        ActionPopup fetchPopup = this.createFetchPopup();
        ShowPopupAction fetchPopupAction = new ShowPopupAction("Fetch Data", ResourceManager.getIcon("action.fetch"));
        JButton fetchButton = new JButton(fetchPopupAction);
        this.filesList.getListComponent().setComponentPopupMenu(fetchPopup);
        this.namesList.getListComponent().setComponentPopupMenu(fetchPopup);
        fetchButton.setComponentPopupMenu(fetchPopup);
        matchButton.setComponentPopupMenu(fetchPopup);
        this.namesList.getButtonPanel().add((Component)fetchButton, "gap 0, sgy button");
        this.namesList.getListComponent().setComponentPopupMenu(fetchPopup);
        fetchButton.setComponentPopupMenu(fetchPopup);
        ActionPopup settingsPopup = this.createSettingsPopup();
        ShowPopupAction settingsPopupAction = new ShowPopupAction("Settings", ResourceManager.getIcon("action.settings"));
        JButton settingsButton = SwingUI.createImageButton(settingsPopupAction);
        settingsButton.setComponentPopupMenu(settingsPopup);
        renameButton.setComponentPopupMenu(settingsPopup);
        this.namesList.getButtonPanel().add((Component)settingsButton, "gap indent, sgy button");
        this.filesList.getButtonPanel().add(SwingUI.createImageButton(removeAction), "gap 0, sgy button", 2);
        this.filesList.getButtonPanel().add((Component)SwingUI.createImageButton(this.clearFilesAction), "gap 0, sgy button");
        this.filesList.getButtonPanel().add((Component)SwingUI.createImageButton(this.openHistoryAction), "gap indent, sgy button");
        JButton presetsButton = SwingUI.createImageButton(new ShowPresetsPopupAction());
        this.filesList.getButtonPanel().add((Component)presetsButton, "gap 0, sgy button");
        matchButton.addActionListener(evt -> {
            if (this.renameModel.names().isEmpty()) {
                fetchPopupAction.actionPerformed(evt);
            }
        });
        this.filesList.getListComponent().addMouseListener(SwingUI.mouseClicked(evt -> {
            if (evt.getClickCount() == 2) {
                SwingUI.getWindow(evt.getSource()).setCursor(Cursor.getPredefinedCursor(3));
                try {
                    JList list = (JList)evt.getSource();
                    if (list.getSelectedIndex() >= 0) {
                        UserFiles.revealFiles(list.getSelectedValuesList());
                    }
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e.getMessage(), e);
                }
                finally {
                    SwingUI.getWindow(evt.getSource()).setCursor(Cursor.getDefaultCursor());
                }
            }
        }));
        this.namesList.getListComponent().addMouseListener(SwingUI.mouseClicked(evt -> {
            JList list;
            if (evt.getClickCount() == 2 && (list = (JList)evt.getSource()).getSelectedIndex() >= 0) {
                Match<Object, File> match = this.renameModel.getMatch(list.getSelectedIndex());
                Map<File, Object> context = this.renameModel.getMatchContext(match);
                if (match.getValue() != null) {
                    MediaBindingBean sample = new MediaBindingBean(match.getValue(), match.getCandidate(), context);
                    this.showFormatEditor(sample);
                }
            }
        }));
        this.setLayout(new MigLayout("fill, insets dialog, gapx 10px", "[fill][align center, pref!][fill]", "align 33%"));
        this.add((Component)new LoadingOverlayPane(this.filesList, this.filesList, "37px", "30px"), "grow, sizegroupx list");
        BackgroundFileTransferablePolicy transferablePolicy = (BackgroundFileTransferablePolicy)this.filesList.getTransferablePolicy();
        transferablePolicy.addPropertyChangeListener(evt -> {
            if ("loading".equals(evt.getPropertyName())) {
                this.filesList.firePropertyChange("loading", (Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            }
        });
        matchButton.setMargin(new Insets(3, 14, 2, 14));
        renameButton.setMargin(new Insets(6, 11, 2, 11));
        this.add((Component)matchButton, "split 2, flowy, sizegroupx button");
        this.add((Component)renameButton, "gapy 30px, sizegroupx button");
        this.add((Component)new LoadingOverlayPane(this.namesList, this.namesList, "37px", "30px"), "grow, sizegroupx list");
        SwingUtilities.invokeLater(this::installKeyStrokeActions);
    }

    private void installKeyStrokeActions() {
        SwingUI.installAction(this, 2, KeyStroke.getKeyStroke(113, 0), SwingUI.newAction("Force Name", evt -> SwingUI.withWaitCursor(evt.getSource(), () -> {
            if (this.namesList.getModel().isEmpty()) {
                Map<File, Object> xattr = WebServices.XattrMetaData.match(this.renameModel.files(), false);
                this.renameModel.clear();
                this.renameModel.addAll(xattr.values(), xattr.keySet());
            } else {
                int index = this.namesList.getListComponent().getSelectedIndex();
                if (index >= 0) {
                    File file = (File)this.filesList.getListComponent().getModel().getElementAt(index);
                    Object object = this.namesList.getListComponent().getModel().getElementAt(index);
                    String string = SwingUI.showInputDialog("Enter Name:", object.toString(), "Enter Name", this);
                    if (string != null && string.length() > 0) {
                        this.renameModel.matches().set(index, new Match<CallSite, File>((CallSite)((Object)(string + "." + FileUtilities.getExtension(file))), file));
                    }
                }
            }
        })));
        for (int presetNumber = 1; presetNumber <= 9; ++presetNumber) {
            int index = presetNumber - 1;
            SwingUI.installAction(this, 2, KeyStroke.getKeyStroke((int)Character.forDigit(presetNumber, 10), 0), SwingUI.newAction("Preset " + presetNumber, evt -> {
                try {
                    List<Preset> presets = this.getPresets();
                    if (index < presets.size()) {
                        new ApplyPresetAction(presets.get(index)).actionPerformed((ActionEvent)evt);
                    } else {
                        new ShowPresetsPopupAction().actionPerformed((ActionEvent)evt);
                    }
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e, e::getMessage);
                }
            }));
        }
        SwingUI.installAction(this, 2, KeyStroke.getKeyStroke(118, 0), SwingUI.newAction("Copy Debug Information", evt -> SwingUI.withWaitCursor(evt.getSource(), () -> {
            String text = this.getDebugInfo();
            if (text.length() > 0) {
                SwingUI.copyToClipboard(text);
                Logging.log.info("Match model has been copied to clipboard");
            } else {
                Logging.log.warning("Match model is empty");
            }
        })));
    }

    private boolean isMatchModeStrict() {
        return MATCH_MODE_STRICT.equalsIgnoreCase(persistentPreferredMatchMode.getValue());
    }

    private ActionPopup createPresetsPopup() {
        ActionPopup actionPopup = new ActionPopup("Presets", ResourceManager.getIcon("action.script"));
        List<Preset> presets = this.getPresets();
        if (presets.size() > 0) {
            for (Preset preset : presets) {
                actionPopup.add(new ApplyPresetAction(preset));
            }
            actionPopup.addSeparator();
        }
        actionPopup.add(SwingUI.newAction("Edit Presets", ResourceManager.getIcon("script.add"), evt -> {
            Window window = SwingUI.getWindow(evt.getSource());
            Action newPreset = SwingUI.newAction("New Preset \u2026", ResourceManager.getIcon("script.add"), a -> Optional.ofNullable(JOptionPane.showInputDialog(window, "Preset Name:", a.getActionCommand(), -1, null, null, "My Preset")).map(Object::toString).map(String::trim).filter(s -> s.length() > 0).ifPresent(n -> this.showPresetEditor(new Preset((String)n, null, null, null, null, null, null, null, null), window)));
            ArrayList<Action> options = new ArrayList<Action>(presets);
            options.add(newPreset);
            SelectDialog<Object> selectDialog = new SelectDialog<Object>((Component)window, options){

                @Override
                protected void configureValue(DefaultFancyListCellRenderer render, Object value) {
                    if (value instanceof Preset) {
                        Preset preset = (Preset)value;
                        render.setIcon(preset.getIcon());
                    } else if (value instanceof Action) {
                        Action action = (Action)value;
                        render.setText((String)action.getValue("Name"));
                        render.setIcon((Icon)action.getValue("SmallIcon"));
                    }
                }
            };
            selectDialog.setTitle("Edit Presets");
            selectDialog.setLocation(SwingUI.getOffsetLocation(selectDialog.getOwner()));
            selectDialog.setMinimumSize(new Dimension(250, 250));
            selectDialog.pack();
            selectDialog.setVisible(true);
            Object selection = selectDialog.getSelectedValue();
            if (selection instanceof Preset) {
                Preset preset = (Preset)selection;
                this.showPresetEditor(preset, window);
            } else if (selection instanceof Action) {
                Action action = (Action)selection;
                action.actionPerformed(new ActionEvent(newPreset, 1001, "New Preset \u2026"));
            }
        }));
        return actionPopup;
    }

    private ActionPopup createFetchPopup() {
        ActionPopup actionPopup = new ActionPopup("Fetch & Match Data", ResourceManager.getIcon("action.fetch"));
        actionPopup.addDescription(new JLabel("Episode Mode:"));
        for (EpisodeListProvider episodeListProvider : WebServices.getEpisodeListProviders()) {
            actionPopup.add(new AutoCompleteAction(episodeListProvider.getName(), episodeListProvider.getIcon(), () -> new EpisodeListMatcher(db, db == WebServices.AniDB)));
        }
        actionPopup.addSeparator();
        actionPopup.addDescription(new JLabel("Movie Mode:"));
        for (Datasource datasource : WebServices.getMovieIdentificationServices()) {
            actionPopup.add(new AutoCompleteAction(datasource.getName(), datasource.getIcon(), () -> RenamePanel.lambda$createFetchPopup$15((MovieIdentificationService)datasource)));
        }
        actionPopup.addSeparator();
        actionPopup.addDescription(new JLabel("Music Mode:"));
        for (Datasource datasource : WebServices.getMusicIdentificationServices()) {
            actionPopup.add(new AutoCompleteAction(datasource.getName(), datasource.getIcon(), () -> RenamePanel.lambda$createFetchPopup$16((MusicIdentificationService)datasource)));
        }
        actionPopup.addSeparator();
        actionPopup.addDescription(new JLabel("Smart Mode:"));
        actionPopup.add(new AutoCompleteAction("Autodetect", ResourceManager.getIcon("action.auto"), AutoDetectMatcher::new));
        actionPopup.addSeparator();
        actionPopup.addDescription(new JLabel("Options:"));
        actionPopup.add(SwingUI.newAction("Edit Format", ResourceManager.getIcon("action.format"), evt -> this.showFormatEditor(null)));
        actionPopup.add(SwingUI.newAction("Preferences", ResourceManager.getIcon("action.preferences"), evt -> {
            String[] modes = new String[]{MATCH_MODE_OPPORTUNISTIC, MATCH_MODE_STRICT};
            JComboBox<String> modeCombo = new JComboBox<String>(modes);
            ArrayList<Language> languages = new ArrayList<Language>();
            languages.addAll(Language.preferredLanguages());
            languages.addAll(Language.availableLanguages());
            JComboBox<SortOrder> orderCombo = new JComboBox<SortOrder>(SortOrder.values());
            JList<Object> languageList = new JList<Object>(languages.toArray());
            languageList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value != null) {
                        this.setText(((Language)value).getName());
                        this.setIcon(ResourceManager.getFlagIcon(((Language)value).getCode()));
                    }
                    return this;
                }
            });
            try {
                modeCombo.setSelectedItem(persistentPreferredMatchMode.getValue());
                orderCombo.setSelectedItem((Object)SortOrder.forName(persistentPreferredEpisodeOrder.getValue()));
                String selectedLanguage = persistentPreferredLanguage.getValue();
                languages.stream().filter(l -> l.getCode().equals(selectedLanguage)).findFirst().ifPresent(l -> languageList.setSelectedValue(l, true));
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
            JScrollPane spModeCombo = new JScrollPane(modeCombo, 21, 31);
            spModeCombo.setBorder(new CompoundBorder(new TitledBorder("Match Mode"), spModeCombo.getBorder()));
            JScrollPane spLanguageList = new JScrollPane(languageList);
            spLanguageList.setBorder(new CompoundBorder(new TitledBorder("Language"), spLanguageList.getBorder()));
            JScrollPane spOrderCombo = new JScrollPane(orderCombo, 21, 31);
            spOrderCombo.setBorder(new CompoundBorder(new TitledBorder("Episode Order"), spOrderCombo.getBorder()));
            spModeCombo.setOpaque(false);
            spLanguageList.setOpaque(false);
            spOrderCombo.setOpaque(false);
            JPanel message = new JPanel(new MigLayout("fill, flowy, insets 0"));
            message.add((Component)spModeCombo, "grow, hmin 24px");
            message.add((Component)spLanguageList, "grow, hmin 50px");
            message.add((Component)spOrderCombo, "grow, hmin 24px");
            JOptionPane pane = new JOptionPane(message, -1, 2);
            pane.createDialog(SwingUtilities.getWindowAncestor(this), "Preferences").setVisible(true);
            if (pane.getValue() != null && pane.getValue().equals(0)) {
                persistentPreferredMatchMode.setValue((String)modeCombo.getSelectedItem());
                persistentPreferredLanguage.setValue(((Language)languageList.getSelectedValue()).getCode());
                persistentPreferredEpisodeOrder.setValue(((SortOrder)((Object)((Object)((Object)orderCombo.getSelectedItem())))).name());
                this.matchAction.setMatchMode(this.isMatchModeStrict());
            }
        }));
        return actionPopup;
    }

    private ActionPopup createSettingsPopup() {
        ActionPopup actionPopup = new ActionPopup("Rename Options", ResourceManager.getIcon("action.settings"));
        actionPopup.addDescription(new JLabel("Extension:"));
        actionPopup.add(new SetRenameMode(false, "Preserve", ResourceManager.getIcon("action.extension.preserve")));
        actionPopup.add(new SetRenameMode(true, "Override", ResourceManager.getIcon("action.extension.override")));
        actionPopup.addSeparator();
        actionPopup.addDescription(new JLabel("Action:"));
        for (StandardRenameAction action : Preset.getSupportedActions()) {
            actionPopup.add(new SetRenameAction(action));
        }
        return actionPopup;
    }

    private FormatDialog.Mode getFormatEditorMode(MediaBindingBean binding) {
        if (binding != null) {
            if (binding.getInfoObject() instanceof Episode) {
                return FormatDialog.Mode.Episode;
            }
            if (binding.getInfoObject() instanceof Movie) {
                return FormatDialog.Mode.Movie;
            }
            if (binding.getInfoObject() instanceof AudioTrack) {
                return FormatDialog.Mode.Music;
            }
            if (binding.getInfoObject() instanceof File) {
                return FormatDialog.Mode.File;
            }
            throw new IllegalArgumentException("Cannot format class: " + binding.getInfoObjectType());
        }
        try {
            return FormatDialog.Mode.valueOf(persistentLastFormatState.getValue());
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::getMessage);
            return FormatDialog.Mode.Episode;
        }
    }

    private void showFormatEditor(MediaBindingBean binding) {
        SwingUI.withWaitCursor(this, () -> {
            FormatDialog dialog = new FormatDialog(SwingUtilities.getWindowAncestor(this), this.getFormatEditorMode(binding), binding, binding != null);
            dialog.setLocation(SwingUI.getOffsetLocation(dialog.getOwner()));
            dialog.setVisible(true);
            if (dialog.submit()) {
                switch (dialog.getMode()) {
                    case Episode: {
                        this.renameModel.useFormatter(Episode.class, new ExpressionFormatter(dialog.getFormat().getExpression(), (Format)EpisodeFormat.SeasonEpisode, Episode.class));
                        persistentEpisodeFormat.setValue(dialog.getFormat().getExpression());
                        break;
                    }
                    case Movie: {
                        this.renameModel.useFormatter(Movie.class, new ExpressionFormatter(dialog.getFormat().getExpression(), (Format)MovieFormat.NameYear, Movie.class));
                        persistentMovieFormat.setValue(dialog.getFormat().getExpression());
                        break;
                    }
                    case Music: {
                        this.renameModel.useFormatter(AudioTrack.class, new ExpressionFormatter(dialog.getFormat().getExpression(), (Format)new AudioTrackFormat(), AudioTrack.class));
                        persistentMusicFormat.setValue(dialog.getFormat().getExpression());
                        break;
                    }
                    case File: {
                        this.renameModel.useFormatter(File.class, new ExpressionFormatter(dialog.getFormat().getExpression(), (Format)new FileNameFormat(), File.class));
                        persistentFileFormat.setValue(dialog.getFormat().getExpression());
                    }
                }
                if (binding == null) {
                    persistentLastFormatState.setValue(dialog.getMode().name());
                }
            }
        });
    }

    private void showPresetEditor(Preset preset, Window owner) {
        try {
            PresetEditor presetEditor = new PresetEditor(owner);
            presetEditor.setPreset(preset);
            presetEditor.setLocation(SwingUI.getOffsetLocation(presetEditor.getOwner()));
            presetEditor.setVisible(true);
            switch (presetEditor.getResult()) {
                case SET: {
                    persistentPresets.put(preset.getName(), presetEditor.getPreset());
                    break;
                }
                case DELETE: {
                    persistentPresets.remove(preset.getName());
                    break;
                }
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e, e::toString);
        }
    }

    private List<Preset> getPresets() {
        ArrayList<Preset> presets = new ArrayList<Preset>(persistentPresets.values());
        presets.sort(Comparator.comparing(Preset::getName, new AlphanumComparator(Locale.getDefault())));
        return presets;
    }

    private String getDebugInfo() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Match match : this.renameModel.matches()) {
            String f = MediaDetection.getStructurePathTail((File)match.getCandidate()).getPath();
            Object v = match.getValue();
            if (v instanceof File) {
                v = new SimpleFileInfo(MediaDetection.getStructurePathTail((File)v).getPath(), ((File)v).length());
            }
            sb.append(f).append('\t').append(MetaAttributes.toJson(v)).append('\n');
        }
        return sb.toString();
    }

    @Subscribe
    public void handle(Transferable transferable) throws Exception {
        for (TransferablePolicy handler : new TransferablePolicy[]{this.filesList.getTransferablePolicy(), this.namesList.getTransferablePolicy()}) {
            if (handler == null || !handler.accept(transferable)) continue;
            handler.handleTransferable(transferable, TransferablePolicy.TransferAction.PUT);
            return;
        }
    }

    private static /* synthetic */ AutoCompleteMatcher lambda$createFetchPopup$16(MusicIdentificationService it) {
        return new MusicMatcher(it);
    }

    private static /* synthetic */ AutoCompleteMatcher lambda$createFetchPopup$15(MovieIdentificationService it) {
        return new MovieMatcher(it);
    }

    private class AutoCompleteAction
    extends AbstractAction {
        protected final Supplier<AutoCompleteMatcher> matcher;

        public AutoCompleteAction(String name, Icon icon, Supplier<AutoCompleteMatcher> matcher) {
            super(name, icon);
            this.matcher = matcher;
            RenamePanel.this.namesList.addPropertyChangeListener("loading", evt -> this.setEnabled((Boolean)evt.getNewValue() == false));
        }

        public List<File> getFiles(ActionEvent evt) {
            return RenamePanel.this.renameModel.files();
        }

        public boolean isStrict(ActionEvent evt) {
            return RenamePanel.this.isMatchModeStrict();
        }

        public SortOrder getSortOrder(ActionEvent evt) {
            return SortOrder.forName((String)persistentPreferredEpisodeOrder.getValue());
        }

        public Locale getLocale(ActionEvent evt) {
            return Language.getLanguage((String)persistentPreferredLanguage.getValue()).getLocale();
        }

        private boolean isAutoDetectionEnabled(ActionEvent evt) {
            return !SwingUI.isShiftOrAltDown(evt);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RenamePanel.this.renameModel.values().clear();
            List<File> files = this.getFiles(evt);
            if (files == null) {
                RenamePanel.this.namesList.firePropertyChange("loading", true, false);
                return;
            }
            final LinkedList<File> remainingFiles = new LinkedList<File>(files);
            final boolean strict = this.isStrict(evt);
            final SortOrder order = this.getSortOrder(evt);
            final Locale locale = this.getLocale(evt);
            final boolean autodetection = this.isAutoDetectionEnabled(evt);
            if (Settings.isMacSandbox() && !MacAppUtilities.askUnlockFolders(SwingUI.getWindow(RenamePanel.this), remainingFiles)) {
                RenamePanel.this.namesList.firePropertyChange("loading", true, false);
                return;
            }
            SwingWorker worker = new SwingWorker<List<Match<File, ?>>, Void>(){

                @Override
                protected List<Match<File, ?>> doInBackground() throws Exception {
                    List<Match<File, ?>> matches = AutoCompleteAction.this.matcher.get().match(remainingFiles, strict, order, locale, autodetection, SwingUI.getWindow(RenamePanel.this));
                    for (Match<File, ?> match : matches) {
                        remainingFiles.remove(match.getValue());
                    }
                    return matches;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        ArrayList matches = new ArrayList();
                        for (Match match : (List)this.get()) {
                            matches.add(new Match(match.getCandidate(), (File)match.getValue()));
                        }
                        RenamePanel.this.renameModel.clear();
                        RenamePanel.this.renameModel.addAll(matches);
                        RenamePanel.this.renameModel.files().addAll(remainingFiles);
                    }
                    catch (Exception e) {
                        if (ExceptionUtilities.findCause(e, CancellationException.class) != null) {
                            return;
                        }
                        if (ExceptionUtilities.findCause(e, InvalidResponseException.class) != null) {
                            Logging.log.log(Level.WARNING, ExceptionUtilities.findCause(e, InvalidResponseException.class).getMessage());
                            return;
                        }
                        Logging.log.log(Level.WARNING, e, Logging.cause(ExceptionUtilities.getRootCause(e)));
                    }
                    finally {
                        RenamePanel.this.namesList.firePropertyChange("loading", true, false);
                    }
                }
            };
            RenamePanel.this.namesList.firePropertyChange("loading", false, true);
            worker.execute();
        }
    }

    private class SetRenameAction
    extends AbstractAction {
        private final StandardRenameAction action;

        public SetRenameAction(StandardRenameAction action) {
            super(action.getDisplayName(), ResourceManager.getIcon("rename.action." + action.name().toLowerCase()));
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.action == StandardRenameAction.MOVE) {
                RenamePanel.this.renameAction.resetValues();
            } else {
                RenamePanel.this.renameAction.putValue("RENAME_ACTION", this.action);
                RenamePanel.this.renameAction.putValue("Name", this.getValue("Name"));
                RenamePanel.this.renameAction.putValue("SmallIcon", ResourceManager.getIcon("action." + this.action.name().toLowerCase()));
            }
        }
    }

    private class SetRenameMode
    extends AbstractAction {
        private final boolean activate;

        private SetRenameMode(boolean activate, String name, Icon icon) {
            super(name, icon);
            this.activate = activate;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            RenamePanel.this.renameModel.setPreserveExtension(!this.activate);
            RenamePanel.this.filesList.repaint();
        }
    }

    private class ApplyPresetAction
    extends AutoCompleteAction {
        private Preset preset;

        public ApplyPresetAction(Preset preset) {
            super(preset.getName(), preset.getIcon(), preset::getAutoCompleteMatcher);
            this.preset = preset;
        }

        @Override
        public List<File> getFiles(ActionEvent evt) {
            File inputFolder = this.preset.getInputFolder();
            if (inputFolder == null) {
                return super.getFiles(evt);
            }
            if (Settings.isMacSandbox() && !MacAppUtilities.askUnlockFolders(SwingUI.getWindow(RenamePanel.this), Collections.singleton(inputFolder))) {
                return Collections.emptyList();
            }
            try {
                List selection = SwingUI.onSecondaryLoop(this.preset::selectFiles);
                if (selection.size() > 0) {
                    RenamePanel.this.renameModel.clear();
                    RenamePanel.this.renameModel.files().addAll(selection);
                    return selection;
                }
                Logging.log.info("No files have been selected.");
            }
            catch (Exception e) {
                Logging.log.log(Level.WARNING, e, e::toString);
            }
            return null;
        }

        @Override
        public boolean isStrict(ActionEvent evt) {
            return this.preset.getMatchMode() != null ? RenamePanel.MATCH_MODE_STRICT.equals(this.preset.getMatchMode()) : super.isStrict(evt);
        }

        @Override
        public SortOrder getSortOrder(ActionEvent evt) {
            return this.preset.getSortOrder() != null ? this.preset.getSortOrder() : super.getSortOrder(evt);
        }

        @Override
        public Locale getLocale(ActionEvent evt) {
            return this.preset.getLanguage() != null ? this.preset.getLanguage().getLocale() : super.getLocale(evt);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SwingWorker<ExpressionFormatter, Void> worker = SwingUI.newSwingWorker(() -> {
                ExpressionFileFormat format = this.preset.getFormat();
                if (format != null && this.preset.getDatasource() != null) {
                    switch (FormatDialog.Mode.getMode(this.preset.getDatasource())) {
                        case Episode: {
                            return new ExpressionFormatter(format, (Format)EpisodeFormat.SeasonEpisode, Episode.class);
                        }
                        case Movie: {
                            return new ExpressionFormatter(format, (Format)MovieFormat.NameYear, Movie.class);
                        }
                        case Music: {
                            return new ExpressionFormatter(format, (Format)new AudioTrackFormat(), AudioTrack.class);
                        }
                        case File: {
                            return new ExpressionFormatter(format, (Format)new FileNameFormat(), File.class);
                        }
                    }
                }
                return null;
            }, formatter -> {
                if (formatter != null) {
                    RenamePanel.this.renameModel.useFormatter(formatter.getTargetClass(), (MatchFormatter)formatter);
                }
                if (this.preset.getRenameAction() != null) {
                    new SetRenameAction(this.preset.getRenameAction()).actionPerformed(evt);
                }
                super.actionPerformed(evt);
            });
            RenamePanel.this.namesList.firePropertyChange("loading", false, true);
            worker.execute();
        }
    }

    private class ShowPresetsPopupAction
    extends AbstractAction {
        public ShowPresetsPopupAction() {
            super("Presets", ResourceManager.getIcon("action.script"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                JComponent source = (JComponent)evt.getSource();
                RenamePanel.this.createPresetsPopup().show(source, -3, source.getHeight() + 4);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e, e::toString);
            }
        }
    }

    private static class ShowPopupAction
    extends AbstractAction {
        public ShowPopupAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent source = (JComponent)e.getSource();
            source.getComponentPopupMenu().show(source, -3, source.getHeight() + 4);
        }
    }
}

