/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.io.File;
import java.util.List;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;

public class TextColorizer {
    private Color pathRainbowBeginColor;
    private Color pathRainbowEndColor;
    private String before;
    private String after;

    public TextColorizer() {
        this("<html><nobr>", "</nobr></html>");
    }

    public TextColorizer(String before, String after) {
        this(before, after, new Color(0xCC3300), new Color(32896));
    }

    public TextColorizer(String before, String after, Color pathRainbowBeginColor, Color pathRainbowEndColor) {
        this.before = before;
        this.after = after;
        this.pathRainbowBeginColor = pathRainbowBeginColor;
        this.pathRainbowEndColor = pathRainbowEndColor;
    }

    public StringBuilder colorizePath(StringBuilder html, File file, boolean hasExtension) {
        html.append(this.before);
        List<File> path = FileUtilities.listPath(file);
        for (int i = 0; i < path.size() - 1; ++i) {
            float f = path.size() <= 2 ? 1.0f : (float)i / (float)(path.size() - 2);
            Color c = SwingUI.interpolateHSB(this.pathRainbowBeginColor, this.pathRainbowEndColor, f);
            html.append(String.format("<span style='color:rgb(%1$d, %2$d, %3$d)'>%4$s</span><span style='color:rgb(%1$d, %2$d, %3$d)'>/</span>", c.getRed(), c.getGreen(), c.getBlue(), SwingUI.escapeHTML(FileUtilities.getFolderName(path.get(i)))));
        }
        if (hasExtension) {
            html.append(SwingUI.escapeHTML(FileUtilities.getNameWithoutExtension(file.getName())));
            String extension = FileUtilities.getExtension(file);
            if (extension != null) {
                html.append(String.format("<span style='color:#607080'>.%s</span>", SwingUI.escapeHTML(extension)));
            }
        } else {
            html.append(file.getName());
        }
        return html.append(this.after);
    }
}

