/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import net.filebot.ResourceManager;

public class ChecksumButton
extends JToggleButton {
    private static final Icon contentArea = ResourceManager.getIcon("button.checksum");
    private static final Icon contentAreaSelected = ResourceManager.getIcon("button.checksum.selected");

    public ChecksumButton(Action action) {
        super(action);
        this.setPreferredSize(new Dimension(Math.max(contentAreaSelected.getIconWidth(), contentArea.getIconWidth()), Math.max(contentAreaSelected.getIconHeight(), contentArea.getIconHeight())));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setForeground(Color.WHITE);
        this.setFont(new Font("Dialog", 0, 11));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setCursor(Cursor.getPredefinedCursor(enabled ? 12 : 0));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.isSelected()) {
            contentAreaSelected.paintIcon(this, g2d, (int)Math.round((double)(this.getWidth() - contentAreaSelected.getIconWidth()) / 2.0), (int)Math.round((double)(this.getHeight() - contentAreaSelected.getIconHeight()) / 2.0));
        } else {
            contentArea.paintIcon(this, g2d, (int)Math.round((double)(this.getWidth() - contentArea.getIconWidth()) / 2.0), (int)Math.round((double)(this.getHeight() - contentArea.getIconHeight()) / 2.0));
        }
        Rectangle2D textBounds = g2d.getFontMetrics().getStringBounds(this.getText(), g2d);
        g2d.drawString(this.getText(), (float)(Math.round(((double)this.getWidth() - textBounds.getWidth()) / 2.0) + 1L), (float)Math.round((double)(this.getHeight() / 2) - textBounds.getY() - textBounds.getHeight() / 2.0));
    }
}

