/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.SwingWorker;
import javax.swing.event.SwingPropertyChangeSupport;
import net.filebot.hash.HashType;
import net.filebot.ui.sfv.ChecksumComputationTask;
import net.filebot.util.ExceptionUtilities;

class ChecksumCell {
    private final String name;
    private final File root;
    private Map<HashType, String> hashes;
    private ChecksumComputationTask task;
    private Throwable error;
    private final PropertyChangeListener taskListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName())) {
                if (evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    this.done(evt);
                }
                ChecksumCell.this.pcs.firePropertyChange("state", null, (Object)ChecksumCell.this.getState());
            } else {
                ChecksumCell.this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done(PropertyChangeEvent evt) {
            try {
                ChecksumCell.this.hashes.putAll((Map)ChecksumCell.this.task.get());
            }
            catch (Exception e) {
                Throwable cause = ExceptionUtilities.getRootCause(e);
                if (cause instanceof CancellationException) {
                    return;
                }
                ChecksumCell.this.error = cause;
            }
            finally {
                ChecksumCell.this.task = null;
            }
        }
    };
    private SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);

    public ChecksumCell(String name, File root, Map<HashType, String> hashes) {
        this.name = name;
        this.root = root;
        this.hashes = hashes;
    }

    public ChecksumCell(String name, File root, ChecksumComputationTask task) {
        this.name = name;
        this.root = root;
        this.hashes = new EnumMap<HashType, String>(HashType.class);
        this.task = task;
        task.addPropertyChangeListener(this.taskListener);
    }

    public String getName() {
        return this.name;
    }

    public File getRoot() {
        return this.root;
    }

    public String getChecksum(HashType hash) {
        return this.hashes.get((Object)hash);
    }

    public void putTask(ChecksumComputationTask computationTask) {
        if (this.task != null) {
            this.task.removePropertyChangeListener(this.taskListener);
            this.task.cancel(true);
        }
        this.task = computationTask;
        this.error = null;
        this.task.addPropertyChangeListener(this.taskListener);
        this.pcs.firePropertyChange("state", null, (Object)this.getState());
    }

    public ChecksumComputationTask getTask() {
        return this.task;
    }

    public Throwable getError() {
        return this.error;
    }

    public State getState() {
        if (this.task != null) {
            switch (this.task.getState()) {
                case PENDING: {
                    return State.PENDING;
                }
            }
            return State.PROGRESS;
        }
        if (this.error != null) {
            return State.ERROR;
        }
        return State.READY;
    }

    public void dispose() {
        for (PropertyChangeListener listener : this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(listener);
        }
        if (this.task != null) {
            this.task.removePropertyChangeListener(this.taskListener);
            this.task.cancel(true);
        }
        this.hashes = null;
        this.error = null;
        this.task = null;
        this.pcs = null;
    }

    public String toString() {
        return String.format("%s %s", this.name, this.hashes);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static enum State {
        PENDING,
        PROGRESS,
        READY,
        ERROR;

    }
}

