/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.filebot.hash.VerificationUtilities;
import net.filebot.ui.sfv.ChecksumCell;
import net.filebot.ui.sfv.ChecksumCellRenderer;
import net.filebot.ui.sfv.ChecksumRow;
import net.filebot.ui.sfv.ChecksumTableModel;
import net.filebot.ui.sfv.HighlightPatternCellRenderer;
import net.filebot.ui.sfv.StateIconCellRenderer;
import net.filebot.util.ui.SwingUI;

class ChecksumTable
extends JTable {
    public ChecksumTable() {
        this.setFillsViewportHeight(true);
        this.setAutoCreateRowSorter(true);
        this.setAutoCreateColumnsFromModel(true);
        this.setAutoResizeMode(2);
        this.setSelectionMode(2);
        this.setRowHeight(20);
        this.setDragEnabled(true);
        this.setUI(new SwingUI.DragDropRowTableUI());
        this.setBackground(Color.WHITE);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setDefaultRenderer(String.class, new HighlightPatternCellRenderer(VerificationUtilities.EMBEDDED_CHECKSUM));
        this.setDefaultRenderer(ChecksumRow.State.class, new StateIconCellRenderer());
        this.setDefaultRenderer(ChecksumCell.class, new ChecksumCellRenderer());
    }

    @Override
    protected ChecksumTableModel createDefaultDataModel() {
        return new ChecksumTableModel();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent evt) {
                try {
                    int columnIndex = this.columnModel.getColumnIndexAtX(evt.getX());
                    int modelIndex = this.columnModel.getColumn(columnIndex).getModelIndex();
                    return ChecksumTable.this.getModel().getColumnRoot(modelIndex).getPath();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
    }

    @Override
    public ChecksumTableModel getModel() {
        return (ChecksumTableModel)super.getModel();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(45);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(400);
                continue;
            }
            if (i < 2) continue;
            column.setPreferredWidth(150);
        }
    }
}

