/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationFileWriter;
import net.filebot.ui.sfv.ChecksumCell;
import net.filebot.ui.sfv.ChecksumRow;
import net.filebot.ui.sfv.ChecksumTableModel;
import net.filebot.ui.transfer.TextFileExportHandler;
import net.filebot.util.FileUtilities;

class ChecksumTableExportHandler
extends TextFileExportHandler {
    private final ChecksumTableModel model;

    public ChecksumTableExportHandler(ChecksumTableModel model) {
        this.model = model;
    }

    @Override
    public boolean canExport() {
        return this.model.getRowCount() > 0 && this.defaultColumn() != null;
    }

    @Override
    public void export(PrintWriter out) {
        this.export(new VerificationFileWriter(out, this.model.getHashType().getFormat(), StandardCharsets.UTF_8), this.defaultColumn(), this.model.getHashType());
    }

    @Override
    public String getDefaultFileName() {
        return this.getDefaultFileName(this.defaultColumn());
    }

    protected File defaultColumn() {
        for (File root : this.model.getChecksumColumns()) {
            if (!root.isDirectory()) continue;
            return root;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(File file, File column) throws IOException {
        try (VerificationFileWriter writer = new VerificationFileWriter(file, this.model.getHashType().getFormat(), StandardCharsets.UTF_8);){
            this.export(writer, column, this.model.getHashType());
        }
    }

    public void export(VerificationFileWriter out, File column, HashType type) {
        for (ChecksumRow row : this.model.rows()) {
            String hash;
            ChecksumCell cell = row.getChecksum(column);
            if (cell == null || (hash = cell.getChecksum(type)) == null) continue;
            out.write(cell.getName(), hash);
        }
    }

    public String getDefaultFileName(File column) {
        StringBuilder sb = new StringBuilder();
        sb.append(column != null ? FileUtilities.getName(column) : "name");
        sb.append('.').append(this.model.getHashType().name().toLowerCase());
        return sb.toString();
    }
}

