/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.Settings;
import net.filebot.hash.HashType;
import net.filebot.hash.VerificationFileReader;
import net.filebot.hash.VerificationUtilities;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.ui.sfv.ChecksumCell;
import net.filebot.ui.sfv.ChecksumComputationService;
import net.filebot.ui.sfv.ChecksumComputationTask;
import net.filebot.ui.sfv.ChecksumTable;
import net.filebot.ui.sfv.ChecksumTableModel;
import net.filebot.ui.transfer.BackgroundFileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileSet;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;

class ChecksumTableTransferablePolicy
extends BackgroundFileTransferablePolicy<ChecksumCell> {
    private final ChecksumTable table;
    private final ChecksumTableModel model;
    private final ChecksumComputationService computationService;
    private final ThreadLocal<ExecutorService> executor = new ThreadLocal();
    private final ThreadLocal<VerificationTracker> verificationTracker = new ThreadLocal();

    public ChecksumTableTransferablePolicy(ChecksumTable table, ChecksumComputationService checksumComputationService) {
        this.table = table;
        this.model = table.getModel();
        this.computationService = checksumComputationService;
    }

    @Override
    protected boolean accept(List<File> files) {
        return true;
    }

    @Override
    protected void clear() {
        super.clear();
        this.computationService.reset();
        this.model.clear();
    }

    @Override
    protected void handleInBackground(List<File> files, TransferablePolicy.TransferAction action) {
        if (files.size() == 1 && VerificationUtilities.getHashType(files.get(0)) != null) {
            this.model.setHashType(VerificationUtilities.getHashType(files.get(0)));
        }
        super.handleInBackground(files, action);
    }

    @Override
    protected void process(List<ChecksumCell> chunks) {
        this.model.addAll(chunks);
    }

    @Override
    protected void process(Exception e) {
        Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(List<File> files, TransferablePolicy.TransferAction action) throws IOException {
        if (Settings.isMacSandbox()) {
            MacAppUtilities.askUnlockFolders(SwingUI.getWindow(this.table), files);
        }
        this.executor.set(this.computationService.newExecutor());
        this.verificationTracker.set(new VerificationTracker(5));
        try {
            if (FileUtilities.containsOnly(files, MediaTypes.VERIFICATION_FILES)) {
                for (File file : files) {
                    this.loadVerificationFile(file, VerificationUtilities.getHashType(file));
                }
                return;
            }
            if (files.size() == 1 && FileUtilities.containsOnly(files, FileUtilities.FOLDERS)) {
                for (File folder : files) {
                    for (File file : FileUtilities.getChildren(folder, FileUtilities.NOT_HIDDEN, FileUtilities.HUMAN_NAME_ORDER)) {
                        this.load(file, null, folder);
                    }
                }
                return;
            }
            if (FileUtilities.mapByFolder(files).size() == 1) {
                for (File file : files) {
                    this.load(file, null, file.getParentFile());
                }
                return;
            }
            FileSet fileset = new FileSet();
            files.forEach(fileset::add);
            for (Map.Entry<Path, List<Path>> it : fileset.getRoots().entrySet()) {
                File root = it.getKey().toFile();
                for (Path path : it.getValue()) {
                    File relativeFile = path.toFile().getParentFile();
                    File absoluteFile = new File(root, path.toString());
                    this.load(absoluteFile, relativeFile, root);
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.executor.get().shutdown();
            this.executor.remove();
            this.verificationTracker.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadVerificationFile(File file, HashType type) throws IOException, InterruptedException {
        try (VerificationFileReader parser = new VerificationFileReader(FileUtilities.createTextReader(file), type.getFormat());){
            File baseFolder = file.getParentFile();
            while (parser.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Object entry = parser.next();
                String name = FileUtilities.normalizePathSeparators(((File)entry.getKey()).getPath());
                String hash = new String((String)entry.getValue());
                ChecksumCell correct = new ChecksumCell(name, file, Collections.singletonMap(type, hash));
                ChecksumCell current = this.createComputationCell(name, baseFolder, type);
                ChecksumCell[] columns = new ChecksumCell[]{correct, current};
                this.publish(columns);
            }
        }
    }

    protected void load(File absoluteFile, File relativeFile, File root) throws IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (absoluteFile.isHidden()) {
            return;
        }
        relativeFile = new File(relativeFile, absoluteFile.getName());
        if (absoluteFile.isDirectory()) {
            for (File child : FileUtilities.getChildren(absoluteFile, FileUtilities.NOT_HIDDEN, FileUtilities.HUMAN_NAME_ORDER)) {
                this.load(child, relativeFile, root);
            }
        } else {
            String name = FileUtilities.normalizePathSeparators(relativeFile.getPath());
            ChecksumCell[] computeCell = new ChecksumCell[]{this.createComputationCell(name, root, this.model.getHashType())};
            this.publish(computeCell);
            Map<File, String> hashByVerificationFile = this.verificationTracker.get().getHashByVerificationFile(absoluteFile);
            for (Map.Entry<File, String> entry : hashByVerificationFile.entrySet()) {
                HashType hashType = this.verificationTracker.get().getVerificationFileType(entry.getKey());
                ChecksumCell[] verifyCell = new ChecksumCell[]{new ChecksumCell(name, entry.getKey(), Collections.singletonMap(hashType, entry.getValue()))};
                this.publish(verifyCell);
            }
        }
    }

    protected ChecksumCell createComputationCell(String name, File root, HashType hash) {
        ChecksumCell cell = new ChecksumCell(name, root, new ChecksumComputationTask(new File(root, name), hash));
        this.executor.get().execute(cell.getTask());
        return cell;
    }

    @Override
    public String getFileFilterDescription() {
        return "Folders and SFV Files";
    }

    @Override
    public List<String> getFileFilterExtensions() {
        return Arrays.asList(MediaTypes.VERIFICATION_FILES.extensions());
    }

    private static class VerificationTracker {
        private final Map<File, Integer> seen = new HashMap<File, Integer>();
        private final Map<File, Map<File, String>> cache = new HashMap<File, Map<File, String>>();
        private final Map<File, HashType> types = new HashMap<File, HashType>();
        private final int maxDepth;

        public VerificationTracker(int maxDepth) {
            this.maxDepth = maxDepth;
        }

        public Map<File, String> getHashByVerificationFile(File file) throws IOException {
            Integer seenLevel;
            File folder = file.getParentFile();
            for (int depth = 0; folder != null && depth <= this.maxDepth && ((seenLevel = this.seen.get(folder)) == null || seenLevel > depth); folder = folder.getParentFile(), ++depth) {
                if (seenLevel == null) {
                    for (File verificationFile : FileUtilities.getChildren(folder, MediaTypes.VERIFICATION_FILES)) {
                        HashType hashType = VerificationUtilities.getHashType(verificationFile);
                        this.cache.put(verificationFile, this.importVerificationFile(verificationFile, hashType, verificationFile.getParentFile()));
                        this.types.put(verificationFile, hashType);
                    }
                }
                this.seen.put(folder, depth);
            }
            if (this.cache.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<File, String> result = new HashMap<File, String>(2);
            for (Map.Entry<File, Map<File, String>> entry : this.cache.entrySet()) {
                String hash = entry.getValue().get(file);
                if (hash == null) continue;
                result.put(entry.getKey(), hash);
            }
            return result;
        }

        public HashType getVerificationFileType(File verificationFile) {
            return this.types.get(verificationFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<File, String> importVerificationFile(File verificationFile, HashType hashType, File baseFolder) throws IOException {
            HashMap<File, String> result = new HashMap<File, String>();
            try (VerificationFileReader parser = new VerificationFileReader(FileUtilities.createTextReader(verificationFile), hashType.getFormat());){
                while (parser.hasNext()) {
                    Object entry = parser.next();
                    result.put(new File(baseFolder, ((File)entry.getKey()).getPath()), new String((String)entry.getValue()));
                }
            }
            return result;
        }
    }
}

